/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.TypeReference;
import org.axonframework.common.configuration.BaseModule;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.ComponentDefinition;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.LifecycleRegistry;
import org.axonframework.eventsourcing.CriteriaResolver;
import org.axonframework.eventsourcing.EventSourcedEntityFactory;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.configuration.EventSourcedEntityModule;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.commandhandling.CommandBus;
import org.axonframework.messaging.commandhandling.CommandHandlingComponent;
import org.axonframework.modelling.EntityEvolver;
import org.axonframework.modelling.EntityIdResolver;
import org.axonframework.modelling.StateManager;
import org.axonframework.modelling.configuration.EntityMetamodelConfigurationBuilder;
import org.axonframework.modelling.entity.EntityCommandHandlingComponent;
import org.axonframework.modelling.entity.EntityMetamodel;
import org.axonframework.modelling.repository.Repository;

class SimpleEventSourcedEntityModule<ID, E>
extends BaseModule<SimpleEventSourcedEntityModule<ID, E>>
implements EventSourcedEntityModule<ID, E>,
EventSourcedEntityModule.MessagingModelPhase<ID, E>,
EventSourcedEntityModule.EntityFactoryPhase<ID, E>,
EventSourcedEntityModule.CriteriaResolverPhase<ID, E>,
EventSourcedEntityModule.EntityIdResolverPhase<ID, E> {
    private final Class<ID> idType;
    private final Class<E> entityType;
    private ComponentBuilder<EventSourcedEntityFactory<ID, E>> entityFactory;
    private ComponentBuilder<CriteriaResolver<ID>> criteriaResolver;
    private ComponentBuilder<EntityMetamodel<E>> entityModel;
    private ComponentBuilder<EntityIdResolver<ID>> entityIdResolver;

    SimpleEventSourcedEntityModule(@Nonnull Class<ID> idType, @Nonnull Class<E> entityType) {
        super("SimpleEventSourcedEntityModule<%s, %s>".formatted(idType.getName(), entityType.getName()));
        this.idType = Objects.requireNonNull(idType, "The identifier type cannot be null.");
        this.entityType = Objects.requireNonNull(entityType, "The entity type cannot be null.");
    }

    @Override
    public EventSourcedEntityModule.EntityFactoryPhase<ID, E> messagingModel(@Nonnull EntityMetamodelConfigurationBuilder<E> metamodelFactory) {
        Objects.requireNonNull(metamodelFactory, "The metamodelFactory cannot be null.");
        this.entityModel = c -> metamodelFactory.build(c, EntityMetamodel.forEntityType(this.entityType));
        return this;
    }

    @Override
    public EventSourcedEntityModule.CriteriaResolverPhase<ID, E> entityFactory(@Nonnull ComponentBuilder<EventSourcedEntityFactory<ID, E>> entityFactory) {
        this.entityFactory = Objects.requireNonNull(entityFactory, "The entity factory cannot be null.");
        return this;
    }

    @Override
    public EventSourcedEntityModule.EntityIdResolverPhase<ID, E> criteriaResolver(@Nonnull ComponentBuilder<CriteriaResolver<ID>> criteriaResolver) {
        this.criteriaResolver = Objects.requireNonNull(criteriaResolver, "The criteria resolver cannot be null.");
        return this;
    }

    @Override
    public EventSourcedEntityModule<ID, E> entityIdResolver(@Nonnull ComponentBuilder<EntityIdResolver<ID>> entityIdResolver) {
        this.entityIdResolver = Objects.requireNonNull(entityIdResolver, "The entity ID resolver cannot be null.");
        return this;
    }

    public Class<ID> idType() {
        return this.idType;
    }

    public Class<E> entityType() {
        return this.entityType;
    }

    public Configuration build(@Nonnull Configuration parent, @Nonnull LifecycleRegistry lifecycleRegistry) {
        this.validate();
        this.registerComponents();
        return super.build(parent, lifecycleRegistry);
    }

    private void validate() {
        Objects.requireNonNull(this.entityFactory, "The EntityFactory must be provided to module [%s].".formatted(this.name()));
        Objects.requireNonNull(this.criteriaResolver, "The CriteriaResolver must be provided to module [%s].".formatted(this.name()));
        Objects.requireNonNull(this.entityModel, "The EntityModel must be provided to module [%s].".formatted(this.name()));
    }

    private void registerComponents() {
        this.componentRegistry(cr -> {
            cr.registerComponent(this.entityFactory());
            cr.registerComponent(this.criteriaResolver());
            cr.registerComponent(this.entityModel());
            cr.registerComponent(this.repository());
            if (this.entityIdResolver != null) {
                cr.registerComponent(this.idResolver());
                cr.registerComponent(this.commandHandlingComponent());
            }
        });
    }

    private ComponentDefinition<EntityMetamodel<E>> entityModel() {
        TypeReference type = new TypeReference<EntityMetamodel<E>>(this){};
        return ComponentDefinition.ofTypeAndName((TypeReference)type, (String)this.entityName()).withBuilder(this.entityModel);
    }

    private ComponentDefinition<EntityIdResolver<ID>> idResolver() {
        TypeReference type = new TypeReference<EntityIdResolver<ID>>(this){};
        return ComponentDefinition.ofTypeAndName((TypeReference)type, (String)this.entityName()).withBuilder(this.entityIdResolver);
    }

    private ComponentDefinition<Repository<ID, E>> repository() {
        TypeReference type = new TypeReference<Repository<ID, E>>(this){};
        return ComponentDefinition.ofTypeAndName((TypeReference)type, (String)this.entityName()).withBuilder(config -> new EventSourcingRepository<ID, E>(this.idType, this.entityType, (EventStore)config.getComponent(EventStore.class), (EventSourcedEntityFactory)config.getComponent(EventSourcedEntityFactory.class, this.entityName()), (CriteriaResolver)config.getComponent(CriteriaResolver.class, this.entityName()), (EntityEvolver)config.getComponent(EntityMetamodel.class, this.entityName()))).onStart(0, (config, component) -> {
            ((StateManager)config.getComponent(StateManager.class)).register(component);
            return FutureUtils.emptyCompletedFuture();
        });
    }

    private ComponentDefinition<CommandHandlingComponent> commandHandlingComponent() {
        return ComponentDefinition.ofTypeAndName(CommandHandlingComponent.class, (String)this.entityName()).withBuilder(c -> new EntityCommandHandlingComponent((Repository)c.getComponent(Repository.class, this.entityName()), (EntityMetamodel)c.getComponent(EntityMetamodel.class, this.entityName()), (EntityIdResolver)c.getComponent(EntityIdResolver.class, this.entityName()))).onStart(0, (config, component) -> {
            ((CommandBus)config.getComponent(CommandBus.class)).subscribe(component);
            return FutureUtils.emptyCompletedFuture();
        });
    }

    private ComponentDefinition<EventSourcedEntityFactory<ID, E>> entityFactory() {
        TypeReference type = new TypeReference<EventSourcedEntityFactory<ID, E>>(this){};
        return ComponentDefinition.ofTypeAndName((TypeReference)type, (String)this.entityName()).withBuilder(this.entityFactory);
    }

    private ComponentDefinition<CriteriaResolver<ID>> criteriaResolver() {
        TypeReference type = new TypeReference<CriteriaResolver<ID>>(this){};
        return ComponentDefinition.ofTypeAndName((TypeReference)type, (String)this.entityName()).withBuilder(this.criteriaResolver);
    }

    public EventSourcedEntityModule<ID, E> build() {
        return this;
    }
}

