/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.configuration;

import jakarta.annotation.Nonnull;
import java.util.List;
import org.axonframework.common.configuration.ComponentRegistry;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.ConfigurationEnhancer;
import org.axonframework.eventsourcing.eventstore.AnnotationBasedTagResolver;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.InterceptingEventStore;
import org.axonframework.eventsourcing.eventstore.StorageEngineBackedEventStore;
import org.axonframework.eventsourcing.eventstore.TagResolver;
import org.axonframework.eventsourcing.eventstore.inmemory.InMemoryEventStorageEngine;
import org.axonframework.messaging.core.interception.DispatchInterceptorRegistry;
import org.axonframework.messaging.eventhandling.EventBus;
import org.axonframework.messaging.eventhandling.SimpleEventBus;
import org.axonframework.messaging.eventhandling.configuration.EventBusConfigurationDefaults;

public class EventSourcingConfigurationDefaults
implements ConfigurationEnhancer {
    public static final int ENHANCER_ORDER = 2147483547;

    public int order() {
        return 2147483547;
    }

    public void enhance(@Nonnull ComponentRegistry registry) {
        registry.disableEnhancer(EventBusConfigurationDefaults.class);
        registry.registerIfNotPresent(TagResolver.class, EventSourcingConfigurationDefaults::defaultTagResolver).registerIfNotPresent(EventStorageEngine.class, EventSourcingConfigurationDefaults::defaultEventStorageEngine).registerIfNotPresent(EventStore.class, EventSourcingConfigurationDefaults::simpleEventStore);
        registry.registerDecorator(EventStore.class, -2147483598, (config, name, delegate) -> {
            List dispatchInterceptors = ((DispatchInterceptorRegistry)config.getComponent(DispatchInterceptorRegistry.class)).eventInterceptors(config);
            return dispatchInterceptors.isEmpty() ? delegate : new InterceptingEventStore((EventStore)delegate, dispatchInterceptors);
        });
    }

    private static TagResolver defaultTagResolver(Configuration configuration) {
        return new AnnotationBasedTagResolver();
    }

    private static EventStorageEngine defaultEventStorageEngine(Configuration config) {
        return new InMemoryEventStorageEngine();
    }

    private static StorageEngineBackedEventStore simpleEventStore(Configuration config) {
        return new StorageEngineBackedEventStore((EventStorageEngine)config.getComponent(EventStorageEngine.class), (EventBus)new SimpleEventBus(), (TagResolver)config.getComponent(TagResolver.class));
    }
}

