/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.configuration;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.axonframework.common.ConstructorUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.common.configuration.BaseModule;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.eventsourcing.CriteriaResolver;
import org.axonframework.eventsourcing.EventSourcedEntityFactory;
import org.axonframework.eventsourcing.annotation.CriteriaResolverDefinition;
import org.axonframework.eventsourcing.annotation.EventSourcedEntity;
import org.axonframework.eventsourcing.annotation.EventSourcedEntityFactoryDefinition;
import org.axonframework.eventsourcing.configuration.EventSourcedEntityModule;
import org.axonframework.messaging.core.MessageTypeResolver;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.messaging.core.conversion.MessageConverter;
import org.axonframework.messaging.eventhandling.conversion.EventConverter;
import org.axonframework.modelling.EntityIdResolver;
import org.axonframework.modelling.annotation.EntityIdResolverDefinition;
import org.axonframework.modelling.entity.EntityMetamodel;
import org.axonframework.modelling.entity.annotation.AnnotatedEntityMetamodel;

class AnnotatedEventSourcedEntityModule<I, E>
extends BaseModule<AnnotatedEventSourcedEntityModule<I, E>>
implements EventSourcedEntityModule<I, E> {
    private final Class<I> idType;
    private final Class<E> entityType;
    private final Set<Class<? extends E>> concreteTypes;

    AnnotatedEventSourcedEntityModule(@Nonnull Class<I> idType, @Nonnull Class<E> entityType) {
        super("AnnotatedEventSourcedEntityModule<%s, %s>".formatted(idType.getName(), entityType.getName()));
        this.idType = Objects.requireNonNull(idType, "The idType may not be null.");
        this.entityType = Objects.requireNonNull(entityType, "The entityType may not be null.");
        Map annotationAttributes = (Map)AnnotationUtils.findAnnotationAttributes(entityType, EventSourcedEntity.class).orElseThrow(() -> new IllegalArgumentException("The given class is not an @EventSourcedEntity."));
        this.concreteTypes = this.getConcreteEntityTypes(annotationAttributes);
        this.componentRegistry(cr -> cr.registerModule(EventSourcedEntityModule.declarative(idType, entityType).messagingModel((c, b) -> this.buildMetaModel(c)).entityFactory(this.entityFactory(annotationAttributes, this.concreteTypes)).criteriaResolver(this.criteriaResolver(annotationAttributes)).entityIdResolver(this.entityIdResolver(annotationAttributes))));
    }

    private AnnotatedEntityMetamodel<E> buildMetaModel(@Nonnull Configuration c) {
        if (!this.concreteTypes.isEmpty()) {
            return AnnotatedEntityMetamodel.forPolymorphicType(this.entityType, this.concreteTypes, (ParameterResolverFactory)((ParameterResolverFactory)c.getComponent(ParameterResolverFactory.class)), (MessageTypeResolver)((MessageTypeResolver)c.getComponent(MessageTypeResolver.class)), (MessageConverter)((MessageConverter)c.getComponent(MessageConverter.class)), (EventConverter)((EventConverter)c.getComponent(EventConverter.class)));
        }
        return AnnotatedEntityMetamodel.forConcreteType(this.entityType, (ParameterResolverFactory)((ParameterResolverFactory)c.getComponent(ParameterResolverFactory.class)), (MessageTypeResolver)((MessageTypeResolver)c.getComponent(MessageTypeResolver.class)), (MessageConverter)((MessageConverter)c.getComponent(MessageConverter.class)), (EventConverter)((EventConverter)c.getComponent(EventConverter.class)));
    }

    private ComponentBuilder<CriteriaResolver<I>> criteriaResolver(Map<String, Object> attributes) {
        Class criteriaResolverType = (Class)attributes.get("criteriaResolverDefinition");
        CriteriaResolverDefinition criteriaResolverDefinition = (CriteriaResolverDefinition)ConstructorUtils.getConstructorFunctionWithZeroArguments((Class)criteriaResolverType).get();
        return c -> criteriaResolverDefinition.createEventCriteriaResolver(this.entityType, this.idType, c);
    }

    private ComponentBuilder<EventSourcedEntityFactory<I, E>> entityFactory(Map<String, Object> attributes, Set<Class<? extends E>> concreteTypes) {
        Class type = (Class)attributes.get("entityFactoryDefinition");
        EventSourcedEntityFactoryDefinition entityFactoryDefinition = (EventSourcedEntityFactoryDefinition)ConstructorUtils.getConstructorFunctionWithZeroArguments((Class)type).get();
        return c -> entityFactoryDefinition.createFactory(this.entityType, concreteTypes, this.idType, c);
    }

    private ComponentBuilder<EntityIdResolver<I>> entityIdResolver(Map<String, Object> annotationAttributes) {
        Class type = (Class)annotationAttributes.get("entityIdResolverDefinition");
        EntityIdResolverDefinition definition = (EntityIdResolverDefinition)ConstructorUtils.getConstructorFunctionWithZeroArguments((Class)type).get();
        return c -> {
            AnnotatedEntityMetamodel component = (AnnotatedEntityMetamodel)c.getComponent(EntityMetamodel.class, this.entityName());
            return definition.createIdResolver(this.entityType, this.idType, component, c);
        };
    }

    private Set<Class<? extends E>> getConcreteEntityTypes(Map<String, Object> attributes) {
        Class[] concreteTypes = (Class[])attributes.get("concreteTypes");
        Arrays.stream(concreteTypes).filter(concreteType -> !this.entityType.isAssignableFrom((Class<?>)concreteType)).forEach(concreteType -> {
            throw new IllegalArgumentException("The declared concrete type [%s] is not assignable to the entity type [%s]. Please ensure the concrete type is a subclass of the entity type.".formatted(concreteType.getName(), this.entityType.getName()));
        });
        return Set.of(concreteTypes);
    }

    public Class<I> idType() {
        return this.idType;
    }

    public Class<E> entityType() {
        return this.entityType;
    }
}

