/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.axonframework.eventsourcing.eventstore.Position;

public final class AggregateSequenceNumberPosition
implements Position {
    private static final long MINIMUM_SEQUENCE_NUMBER = 0L;
    private final long sequenceNumber;

    public static long toSequenceNumber(@Nonnull Position position) {
        long l;
        Position position2 = position;
        Objects.requireNonNull(position2);
        Position position3 = position2;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AggregateSequenceNumberPosition.class, Position.class}, (Object)position3, n)) {
                case 0: {
                    AggregateSequenceNumberPosition gip = (AggregateSequenceNumberPosition)position3;
                    l = gip.sequenceNumber;
                    break block4;
                }
                case 1: {
                    Position p = position3;
                    if (p != Position.START) {
                        n = 2;
                        continue block4;
                    }
                    l = 0L;
                    break block4;
                }
                default: {
                    throw new IllegalArgumentException("position must be of type AggregateSequenceNumberPosition: " + String.valueOf(position));
                }
            }
            break;
        }
        return l;
    }

    AggregateSequenceNumberPosition(long sequenceNumber) {
        if (sequenceNumber < 0L) {
            throw new IllegalArgumentException("sequenceNumber cannot be negative");
        }
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    @Nonnull
    public Position min(@Nonnull Position other) {
        Position position;
        Position position2 = other;
        Objects.requireNonNull(position2);
        Position position3 = position2;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Position.class, AggregateSequenceNumberPosition.class}, (Object)position3, n)) {
                case 0: {
                    Position p = position3;
                    if (p != Position.START) {
                        n = 1;
                        continue block4;
                    }
                    position = Position.START;
                    break block4;
                }
                case 1: {
                    AggregateSequenceNumberPosition asnp = (AggregateSequenceNumberPosition)position3;
                    if (this.sequenceNumber < asnp.sequenceNumber) {
                        position = this;
                        break block4;
                    }
                    position = asnp;
                    break block4;
                }
                default: {
                    throw new IllegalArgumentException("other must be of type AggregateSequenceNumberPosition: " + String.valueOf(other));
                }
            }
            break;
        }
        return position;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateSequenceNumberPosition that = (AggregateSequenceNumberPosition)o;
        return this.sequenceNumber == that.sequenceNumber;
    }

    public int hashCode() {
        return Long.hashCode(this.sequenceNumber);
    }

    public String toString() {
        return "AggregateSequenceNumberPosition{sequenceNumber=%d}".formatted(this.sequenceNumber);
    }
}

