/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventMessage;

@FunctionalInterface
public interface EventSourcedEntityFactory<ID, E> {
    @Nullable
    public E create(@Nonnull ID var1, @Nullable EventMessage var2, @Nonnull ProcessingContext var3);

    public static <ID, E> EventSourcedEntityFactory<ID, E> fromNoArgument(@Nonnull Supplier<E> creator) {
        Objects.requireNonNull(creator, "The creator must not be null.");
        return (id, evt, context) -> creator.get();
    }

    public static <ID, E> EventSourcedEntityFactory<ID, E> fromIdentifier(@Nonnull Function<ID, E> creator) {
        Objects.requireNonNull(creator, "The creator must not be null.");
        return (id, evt, context) -> creator.apply(id);
    }

    public static <ID, E> EventSourcedEntityFactory<ID, E> fromEventMessage(@Nonnull BiFunction<ID, EventMessage, E> creator) {
        Objects.requireNonNull(creator, "The creator must not be null.");
        return (id, evt, context) -> evt == null ? null : creator.apply(id, evt);
    }
}

