/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.annotations.EventTag;
import org.axonframework.eventsourcing.annotations.EventTags;
import org.axonframework.eventsourcing.eventstore.TagResolver;
import org.axonframework.eventstreaming.Tag;

public class AnnotationBasedTagResolver
implements TagResolver {
    private static final Class<EventTag> EVENT_TAG_ANNOTATION = EventTag.class;
    private static final Class<EventTags> CONTAINING_ANNOTATION_TYPE = EventTags.class;

    @Override
    public Set<Tag> resolve(@Nonnull EventMessage<?> event) {
        Objects.requireNonNull(event, "Event cannot be null");
        Object payload = event.getPayload();
        return Stream.concat(this.resolveFieldTags(payload), this.resolveMethodTags(payload)).collect(Collectors.toSet());
    }

    private Stream<Tag> resolveFieldTags(Object payload) {
        Iterable fields = ReflectionUtils.fieldsOf(payload.getClass());
        return StreamSupport.stream(fields.spliterator(), false).filter(AnnotationBasedTagResolver::isTagAnnotationPresent).flatMap(field -> this.tagsFrom((Field)field, payload).stream()).filter(Objects::nonNull);
    }

    private Set<Tag> tagsFrom(Field field, Object payload) {
        try {
            EventTag[] annotations;
            Object value = ReflectionUtils.getMemberValue((Member)field, (Object)payload);
            if (value == null) {
                return Set.of();
            }
            HashSet<Tag> tags = new HashSet<Tag>();
            for (EventTag annotation : annotations = (EventTag[])field.getAnnotationsByType(EVENT_TAG_ANNOTATION)) {
                tags.addAll(this.createTagsForValue(value, field.getName(), annotation.key()));
            }
            return tags;
        }
        catch (Exception e) {
            throw new TagResolutionException("Failed to resolve tag from field: " + field.getName(), e);
        }
    }

    private Stream<Tag> resolveMethodTags(Object payload) {
        Iterable methods = ReflectionUtils.methodsOf(payload.getClass());
        return StreamSupport.stream(methods.spliterator(), false).filter(AnnotationBasedTagResolver::isTagAnnotationPresent).flatMap(field -> this.tagsFrom((Method)field, payload).stream()).filter(Objects::nonNull);
    }

    private static boolean isTagAnnotationPresent(AnnotatedElement member) {
        return member.isAnnotationPresent(EVENT_TAG_ANNOTATION) || member.isAnnotationPresent(CONTAINING_ANNOTATION_TYPE);
    }

    private Set<Tag> tagsFrom(Method method, Object payload) {
        this.assertValidTagMethod(method);
        try {
            EventTag[] annotations;
            Object value = ReflectionUtils.getMemberValue((Member)method, (Object)payload);
            if (value == null) {
                return Set.of();
            }
            HashSet<Tag> tags = new HashSet<Tag>();
            for (EventTag annotation : annotations = (EventTag[])method.getAnnotationsByType(EVENT_TAG_ANNOTATION)) {
                tags.addAll(this.createTagsForValue(value, this.getMemberIdentifierName(method), annotation.key()));
            }
            return tags;
        }
        catch (Exception e) {
            throw new TagResolutionException("Failed to resolve tag from method: " + method.getName(), e);
        }
    }

    private Set<Tag> createTagsForValue(Object value, String memberName, String annotationKey) {
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            String key = AnnotationBasedTagResolver.annotationKeyOrMemberName(annotationKey, memberName);
            return StreamSupport.stream(iterable.spliterator(), false).filter(Objects::nonNull).map(item -> new Tag(key, item.toString())).collect(Collectors.toSet());
        }
        if (value instanceof Map) {
            boolean annotationKeyProvided;
            Map map = (Map)value;
            boolean bl = annotationKeyProvided = !annotationKey.isBlank();
            if (annotationKeyProvided) {
                return map.values().stream().filter(Objects::nonNull).map(val -> new Tag(annotationKey, val.toString())).collect(Collectors.toSet());
            }
            return map.entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).map(entry -> new Tag(entry.getKey().toString(), entry.getValue().toString())).collect(Collectors.toSet());
        }
        String key = AnnotationBasedTagResolver.annotationKeyOrMemberName(annotationKey, memberName);
        return Set.of(new Tag(key, value.toString()));
    }

    private static String annotationKeyOrMemberName(String annotationKey, String memberName) {
        return annotationKey.isBlank() ? memberName : annotationKey;
    }

    private void assertValidTagMethod(Method method) {
        if (method.getParameterCount() > 0) {
            throw new TagResolutionException(String.format("The @%s annotated method [%s] should not contain any parameters as none are allowed on event Tag providers", EVENT_TAG_ANNOTATION.getSimpleName(), method));
        }
        if (Void.TYPE.equals(method.getReturnType())) {
            throw new TagResolutionException(String.format("The @%s annotated method [%s] should not return void", EVENT_TAG_ANNOTATION.getSimpleName(), method));
        }
    }

    private String getMemberIdentifierName(Member member) {
        String identifierName = member.getName();
        return member instanceof Method && this.isGetterByConvention(identifierName) ? this.stripGetterConvention(identifierName) : identifierName;
    }

    private boolean isGetterByConvention(String identifierName) {
        return identifierName.startsWith("get") && identifierName.length() >= 4 && Character.isUpperCase(identifierName.charAt(3));
    }

    private String stripGetterConvention(String identifierName) {
        return identifierName.substring(3, 4).toLowerCase() + identifierName.substring(4);
    }

    public static class TagResolutionException
    extends RuntimeException {
        private TagResolutionException(String message) {
            super(message);
        }

        private TagResolutionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

