/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.axonframework.common.CollectionUtils;
import org.axonframework.eventsourcing.eventstore.AbstractConsistencyMarker;
import org.axonframework.eventsourcing.eventstore.AppendCondition;
import org.axonframework.eventsourcing.eventstore.ConsistencyMarker;

public class AggregateBasedConsistencyMarker
extends AbstractConsistencyMarker<AggregateBasedConsistencyMarker> {
    private final Map<String, Long> aggregatePositions;

    public AggregateBasedConsistencyMarker(String aggregateIdentifier, long sequenceNumber) {
        this(Map.of(aggregateIdentifier, sequenceNumber));
    }

    private AggregateBasedConsistencyMarker(Map<String, Long> aggregatePositions) {
        this.aggregatePositions = aggregatePositions;
    }

    public static AggregateBasedConsistencyMarker from(AppendCondition appendCondition) {
        ConsistencyMarker consistencyMarker = appendCondition.consistencyMarker();
        if (consistencyMarker instanceof AggregateBasedConsistencyMarker) {
            AggregateBasedConsistencyMarker abcm = (AggregateBasedConsistencyMarker)consistencyMarker;
            return abcm;
        }
        if (appendCondition.criteria().hasCriteria() && appendCondition.consistencyMarker() == INFINITY) {
            throw new IllegalArgumentException("Consistency marker must not be infinity when criteria are provided");
        }
        if (appendCondition.consistencyMarker() == ORIGIN || appendCondition.consistencyMarker() == INFINITY) {
            return new AggregateBasedConsistencyMarker(Map.of());
        }
        throw new IllegalArgumentException("Unsupported consistency marker: " + String.valueOf(appendCondition.consistencyMarker()));
    }

    public AggregateBasedConsistencyMarker doLowerBound(AggregateBasedConsistencyMarker other) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public AggregateBasedConsistencyMarker doUpperBound(AggregateBasedConsistencyMarker other) {
        HashMap<String, Long> newPositions = new HashMap<String, Long>(this.aggregatePositions);
        other.aggregatePositions.forEach((id, seq) -> {
            if (!newPositions.containsKey(id) || (Long)newPositions.get(id) < seq) {
                newPositions.put((String)id, (Long)seq);
            }
        });
        return new AggregateBasedConsistencyMarker(newPositions);
    }

    public long positionOf(@Nonnull String aggregateIdentifier) {
        return this.aggregatePositions.getOrDefault(aggregateIdentifier, -1L);
    }

    public AggregateBasedConsistencyMarker forwarded(String aggregateIdentifier, long newSequence) {
        long current = this.positionOf(aggregateIdentifier);
        if (current > newSequence) {
            throw new IllegalArgumentException("Aggregate " + aggregateIdentifier + " is already beyond provided position. Current position: " + current + ", provided: " + newSequence);
        }
        if (current == newSequence) {
            return this;
        }
        Map newMap = CollectionUtils.mapWith(this.aggregatePositions, (Object)aggregateIdentifier, (Object)newSequence);
        return new AggregateBasedConsistencyMarker(newMap);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AggregateBasedConsistencyMarker)) {
            return false;
        }
        AggregateBasedConsistencyMarker that = (AggregateBasedConsistencyMarker)o;
        return Objects.equals(this.aggregatePositions, that.aggregatePositions);
    }

    public int hashCode() {
        return Objects.hashCode(this.aggregatePositions);
    }

    public String toString() {
        return "AggregateBasedConsistencyMarker{aggregatePositions=" + String.valueOf(this.aggregatePositions) + "}";
    }
}

