/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.CriteriaResolver;
import org.axonframework.eventsourcing.EntityMissingAfterFirstEventException;
import org.axonframework.eventsourcing.EntityMissingAfterLoadOrCreateException;
import org.axonframework.eventsourcing.EventSourcedEntityFactory;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.SourcingCondition;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.EntityEvolver;
import org.axonframework.modelling.repository.ManagedEntity;
import org.axonframework.modelling.repository.Repository;

public class EventSourcingRepository<ID, E>
implements Repository.LifecycleManagement<ID, E> {
    private final Context.ResourceKey<Map<ID, CompletableFuture<EventSourcedEntity<ID, E>>>> managedEntitiesKey = Context.ResourceKey.withLabel((String)"managedEntities");
    private final Class<ID> idType;
    private final Class<E> entityType;
    private final EventStore eventStore;
    private final CriteriaResolver<ID> criteriaResolver;
    private final EntityEvolver<E> entityEvolver;
    private final EventSourcedEntityFactory<ID, E> entityFactory;

    public EventSourcingRepository(@Nonnull Class<ID> idType, @Nonnull Class<E> entityType, @Nonnull EventStore eventStore, @Nonnull EventSourcedEntityFactory<ID, E> entityFactory, @Nonnull CriteriaResolver<ID> criteriaResolver, @Nonnull EntityEvolver<E> entityEvolver) {
        this.idType = Objects.requireNonNull(idType, "The id type must not be null.");
        this.entityType = Objects.requireNonNull(entityType, "The entity type must not be null.");
        this.eventStore = Objects.requireNonNull(eventStore, "The event store must not be null.");
        this.entityFactory = Objects.requireNonNull(entityFactory, "The entity factory must not be null.");
        this.criteriaResolver = Objects.requireNonNull(criteriaResolver, "The criteria resolver must not be null.");
        this.entityEvolver = Objects.requireNonNull(entityEvolver, "The entity evolver must not be null.");
    }

    public ManagedEntity<ID, E> attach(@Nonnull ManagedEntity<ID, E> entity, @Nonnull ProcessingContext processingContext) {
        Map managedEntities = (Map)processingContext.computeResourceIfAbsent(this.managedEntitiesKey, ConcurrentHashMap::new);
        return (ManagedEntity)managedEntities.computeIfAbsent(entity.identifier(), id -> {
            EventSourcedEntity sourcedEntity = EventSourcedEntity.mapToEventSourcedEntity(entity);
            this.updateActiveEntity(sourcedEntity, processingContext);
            return CompletableFuture.completedFuture(sourcedEntity);
        }).resultNow();
    }

    @Nonnull
    public Class<E> entityType() {
        return this.entityType;
    }

    @Nonnull
    public Class<ID> idType() {
        return this.idType;
    }

    public CompletableFuture<ManagedEntity<ID, E>> load(@Nonnull ID identifier, @Nonnull ProcessingContext context) {
        Map managedEntities = (Map)context.computeResourceIfAbsent(this.managedEntitiesKey, ConcurrentHashMap::new);
        return managedEntities.computeIfAbsent(identifier, id -> this.doLoad(identifier, context).whenComplete((entity, exception) -> this.updateActiveEntity((EventSourcedEntity<ID, E>)entity, context, (Throwable)exception))).thenApply(Function.identity());
    }

    public CompletableFuture<ManagedEntity<ID, E>> loadOrCreate(@Nonnull ID identifier, @Nonnull ProcessingContext context) {
        Map managedEntities = (Map)context.computeResourceIfAbsent(this.managedEntitiesKey, ConcurrentHashMap::new);
        return managedEntities.computeIfAbsent(identifier, id -> ((CompletableFuture)this.doLoad(identifier, context).thenApply(entity -> this.createEntityIfNullFromLoad(identifier, (EventSourcedEntity<ID, E>)entity, context))).whenComplete((entity, exception) -> this.updateActiveEntity((EventSourcedEntity<ID, E>)entity, context, (Throwable)exception))).thenApply(Function.identity());
    }

    private EventSourcedEntity<ID, E> createEntityIfNullFromLoad(ID identifier, EventSourcedEntity<ID, E> entity, ProcessingContext context) {
        if (entity.entity() == null) {
            E createdEntity = this.entityFactory.create(identifier, null, context);
            if (createdEntity == null) {
                throw new EntityMissingAfterLoadOrCreateException(identifier);
            }
            return new EventSourcedEntity<ID, E>(identifier, createdEntity);
        }
        return entity;
    }

    private CompletableFuture<EventSourcedEntity<ID, E>> doLoad(ID identifier, ProcessingContext context) {
        return this.eventStore.transaction(context).source(SourcingCondition.conditionFor(this.criteriaResolver.resolve(identifier, context))).reduce(new EventSourcedEntity(identifier), (entity, entry) -> {
            entity.ensureInitialState(() -> this.entityFactory.create(identifier, (EventMessage)entry.message(), context));
            entity.evolve((EventMessage)entry.message(), this.entityEvolver, context);
            return entity;
        });
    }

    public ManagedEntity<ID, E> persist(@Nonnull ID identifier, @Nonnull E entity, @Nonnull ProcessingContext processingContext) {
        Map managedEntities = (Map)processingContext.computeResourceIfAbsent(this.managedEntitiesKey, ConcurrentHashMap::new);
        return (ManagedEntity)managedEntities.computeIfAbsent(identifier, id -> {
            EventSourcedEntity<Object, Object> sourcedEntity = new EventSourcedEntity<Object, Object>(identifier, entity);
            this.updateActiveEntity(sourcedEntity, processingContext);
            return CompletableFuture.completedFuture(sourcedEntity);
        }).resultNow();
    }

    private void updateActiveEntity(EventSourcedEntity<ID, E> entity, ProcessingContext processingContext, Throwable exception) {
        if (exception == null) {
            this.updateActiveEntity(entity, processingContext);
        }
    }

    private void updateActiveEntity(EventSourcedEntity<ID, E> entity, ProcessingContext processingContext) {
        this.eventStore.transaction(processingContext).onAppend(event -> {
            if (entity.entity() == null) {
                entity.applyStateChange(e -> this.entityFactory.create(entity.identifier(), (EventMessage<?>)event, processingContext));
            } else {
                entity.evolve((EventMessage<?>)event, this.entityEvolver, processingContext);
            }
        });
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("idType", this.idType);
        descriptor.describeProperty("entityType", this.entityType);
        descriptor.describeProperty("eventStore", (Object)this.eventStore);
        descriptor.describeProperty("entityFactory", this.entityFactory);
        descriptor.describeProperty("criteriaResolver", this.criteriaResolver);
        descriptor.describeProperty("entityEvolver", this.entityEvolver);
    }

    private static class EventSourcedEntity<ID, M>
    implements ManagedEntity<ID, M> {
        private final ID identifier;
        private final AtomicReference<M> currentState;
        private boolean initialized;

        private EventSourcedEntity(ID identifier) {
            this(identifier, null);
        }

        private EventSourcedEntity(ID identifier, M currentState) {
            this.identifier = identifier;
            this.currentState = new AtomicReference<M>(currentState);
            this.initialized = currentState != null;
        }

        private static <ID, T> EventSourcedEntity<ID, T> mapToEventSourcedEntity(ManagedEntity<ID, T> entity) {
            EventSourcedEntity<Object, Object> eventSourcedEntity;
            if (entity instanceof EventSourcedEntity) {
                EventSourcedEntity eventSourcedEntity2 = (EventSourcedEntity)entity;
                eventSourcedEntity = eventSourcedEntity2;
            } else {
                eventSourcedEntity = new EventSourcedEntity<Object, Object>(entity.identifier(), entity.entity());
            }
            return eventSourcedEntity;
        }

        public ID identifier() {
            return this.identifier;
        }

        public M entity() {
            return this.currentState.get();
        }

        public M applyStateChange(UnaryOperator<M> change) {
            return this.currentState.updateAndGet(change);
        }

        public void ensureInitialState(Supplier<M> initialStateSupplier) {
            if (!this.initialized) {
                this.initialized = true;
                M entityInitialState = initialStateSupplier.get();
                if (entityInitialState == null) {
                    throw new EntityMissingAfterFirstEventException(this.identifier);
                }
                this.currentState.set(entityInitialState);
            }
        }

        private M evolve(EventMessage<?> event, EntityEvolver<M> evolver, ProcessingContext processingContext) {
            this.initialized = true;
            return this.currentState.updateAndGet(current -> evolver.evolve(current, event, processingContext));
        }
    }
}

