/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import jakarta.annotation.Nonnull;
import org.axonframework.eventsourcing.AbstractSnapshotTrigger;
import org.axonframework.eventsourcing.SnapshotTrigger;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.Snapshotter;

public class EventCountSnapshotTriggerDefinition
implements SnapshotTriggerDefinition {
    private final Snapshotter snapshotter;
    private final int threshold;

    public EventCountSnapshotTriggerDefinition(Snapshotter snapshotter, int threshold) {
        this.snapshotter = snapshotter;
        this.threshold = threshold;
    }

    @Override
    public SnapshotTrigger prepareTrigger(@Nonnull Class<?> aggregateType) {
        return new EventCountSnapshotTrigger(this.snapshotter, aggregateType, this.threshold);
    }

    @Override
    public SnapshotTrigger reconfigure(@Nonnull Class<?> aggregateType, @Nonnull SnapshotTrigger trigger) {
        if (trigger instanceof EventCountSnapshotTrigger) {
            ((EventCountSnapshotTrigger)trigger).setSnapshotter(this.snapshotter);
            return trigger;
        }
        return new EventCountSnapshotTrigger(this.snapshotter, aggregateType, this.threshold);
    }

    private static class EventCountSnapshotTrigger
    extends AbstractSnapshotTrigger {
        private final int threshold;
        private int counter = 0;

        public EventCountSnapshotTrigger(Snapshotter snapshotter, Class<?> aggregateType, int threshold) {
            super(snapshotter, aggregateType);
            this.threshold = threshold;
        }

        @Override
        public boolean exceedsThreshold() {
            return ++this.counter >= this.threshold;
        }

        @Override
        public void reset() {
            this.counter = 0;
        }
    }
}

