/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import org.axonframework.common.BuilderUtils;
import org.axonframework.common.caching.Cache;
import org.axonframework.eventsourcing.AggregateCacheEntry;
import org.axonframework.eventsourcing.AggregateDeletedException;
import org.axonframework.eventsourcing.EventSourcedAggregate;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.RepositoryProvider;

public class CachingEventSourcingRepository<T>
extends EventSourcingRepository<T> {
    private final EventStore eventStore;
    private final RepositoryProvider repositoryProvider;
    private final Cache cache;
    private final SnapshotTriggerDefinition snapshotTriggerDefinition;

    protected CachingEventSourcingRepository(EventSourcingRepository.Builder<T> builder) {
        super(builder);
        BuilderUtils.assertNonNull((Object)builder.cache, (String)"The Cache is a hard requirement and should be provided");
        this.cache = builder.cache;
        this.eventStore = builder.eventStore;
        this.snapshotTriggerDefinition = builder.snapshotTriggerDefinition;
        this.repositoryProvider = builder.repositoryProvider;
    }

    @Override
    protected void validateOnLoad(Aggregate<T> aggregate, Long expectedVersion) {
        CurrentUnitOfWork.get().onRollback(u -> this.cache.remove((Object)aggregate.identifierAsString()));
        super.validateOnLoad(aggregate, expectedVersion);
    }

    @Override
    protected void doSaveWithLock(EventSourcedAggregate<T> aggregate) {
        super.doSaveWithLock(aggregate);
        String key = aggregate.identifierAsString();
        CurrentUnitOfWork.get().onRollback(u -> this.cache.remove((Object)aggregate.identifierAsString()));
        this.cache.put((Object)key, new AggregateCacheEntry<T>(aggregate));
    }

    @Override
    protected void doDeleteWithLock(EventSourcedAggregate<T> aggregate) {
        super.doDeleteWithLock(aggregate);
        String key = aggregate.identifierAsString();
        CurrentUnitOfWork.get().onRollback(u -> this.cache.remove((Object)aggregate.identifierAsString()));
        this.cache.put((Object)key, new AggregateCacheEntry<T>(aggregate));
    }

    @Override
    protected EventSourcedAggregate<T> doLoadWithLock(String aggregateIdentifier, Long expectedVersion) {
        EventSourcedAggregate aggregate = null;
        AggregateCacheEntry cacheEntry = (AggregateCacheEntry)this.cache.get((Object)aggregateIdentifier);
        if (cacheEntry != null) {
            CurrentUnitOfWork.get().onRollback(u -> this.cache.remove((Object)aggregateIdentifier));
            aggregate = cacheEntry.recreateAggregate(this.aggregateModel(), this.eventStore, this.repositoryProvider, this.snapshotTriggerDefinition);
        }
        if (aggregate == null) {
            aggregate = super.doLoadWithLock(aggregateIdentifier, expectedVersion);
        } else if (aggregate.isDeleted()) {
            throw new AggregateDeletedException(aggregateIdentifier);
        }
        return aggregate;
    }
}

