/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jpa;

import java.sql.SQLException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.sql.DataSource;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventUtils;
import org.axonframework.eventhandling.GapAwareTrackingToken;
import org.axonframework.eventhandling.GenericDomainEventEntry;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.TrackedDomainEventData;
import org.axonframework.eventhandling.TrackedEventData;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.BatchingEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.jpa.DomainEventEntry;
import org.axonframework.eventsourcing.eventstore.jpa.SQLErrorCodesResolver;
import org.axonframework.eventsourcing.eventstore.jpa.SnapshotEventEntry;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaEventStorageEngine
extends BatchingEventStorageEngine {
    private static final Logger logger = LoggerFactory.getLogger(JpaEventStorageEngine.class);
    private static final int DEFAULT_MAX_GAP_OFFSET = 10000;
    private static final long DEFAULT_LOWEST_GLOBAL_SEQUENCE = 1L;
    private static final int DEFAULT_GAP_TIMEOUT = 60000;
    private static final int DEFAULT_GAP_CLEANING_THRESHOLD = 250;
    private final EntityManagerProvider entityManagerProvider;
    private final TransactionManager transactionManager;
    private final boolean explicitFlush;
    private final int maxGapOffset;
    private final long lowestGlobalSequence;
    private int gapTimeout;
    private int gapCleaningThreshold;

    protected JpaEventStorageEngine(Builder builder) {
        super(builder);
        this.entityManagerProvider = builder.entityManagerProvider;
        this.transactionManager = builder.transactionManager;
        this.explicitFlush = builder.explicitFlush;
        this.maxGapOffset = builder.maxGapOffset;
        this.lowestGlobalSequence = builder.lowestGlobalSequence;
        this.gapTimeout = builder.gapTimeout;
        this.gapCleaningThreshold = builder.gapCleaningThreshold;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected List<? extends TrackedEventData<?>> fetchTrackedEvents(TrackingToken lastToken, int batchSize) {
        Assert.isTrue((lastToken == null || lastToken instanceof GapAwareTrackingToken ? 1 : 0) != 0, () -> String.format("Token [%s] is of the wrong type. Expected [%s]", lastToken, GapAwareTrackingToken.class.getSimpleName()));
        GapAwareTrackingToken previousToken = this.cleanedToken((GapAwareTrackingToken)lastToken);
        List entries = (List)this.transactionManager.fetchInTransaction(() -> {
            TypedQuery query = previousToken == null || previousToken.getGaps().isEmpty() ? this.entityManager().createQuery("SELECT e.globalIndex, e.type, e.aggregateIdentifier, e.sequenceNumber, e.eventIdentifier, e.timeStamp, e.payloadType, e.payloadRevision, e.payload, e.metaData FROM " + this.domainEventEntryEntityName() + " e WHERE e.globalIndex > :token ORDER BY e.globalIndex ASC", Object[].class) : this.entityManager().createQuery("SELECT e.globalIndex, e.type, e.aggregateIdentifier, e.sequenceNumber, e.eventIdentifier, e.timeStamp, e.payloadType, e.payloadRevision, e.payload, e.metaData FROM " + this.domainEventEntryEntityName() + " e WHERE e.globalIndex > :token OR e.globalIndex IN :gaps ORDER BY e.globalIndex ASC", Object[].class).setParameter("gaps", (Object)previousToken.getGaps());
            return query.setParameter("token", (Object)(previousToken == null ? -1L : previousToken.getIndex())).setMaxResults(batchSize).getResultList();
        });
        ArrayList<TrackedDomainEventData> result = new ArrayList<TrackedDomainEventData>();
        GapAwareTrackingToken token = previousToken;
        for (Object[] entry : entries) {
            long globalSequence = (Long)entry[0];
            GenericDomainEventEntry domainEvent = new GenericDomainEventEntry((String)entry[1], (String)entry[2], ((Long)entry[3]).longValue(), (String)entry[4], entry[5], (String)entry[6], (String)entry[7], entry[8], entry[9]);
            boolean allowGaps = domainEvent.getTimestamp().isAfter(this.gapTimeoutFrame());
            token = token == null ? GapAwareTrackingToken.newInstance((long)globalSequence, allowGaps ? (Collection)LongStream.range(Math.min(this.lowestGlobalSequence, globalSequence), globalSequence).boxed().collect(Collectors.toCollection(TreeSet::new)) : Collections.emptySortedSet()) : token.advanceTo(globalSequence, this.maxGapOffset, allowGaps);
            result.add(new TrackedDomainEventData((TrackingToken)token, (DomainEventData)domainEvent));
        }
        return result;
    }

    private GapAwareTrackingToken cleanedToken(GapAwareTrackingToken lastToken) {
        GapAwareTrackingToken previousToken = lastToken;
        if (lastToken != null && lastToken.getGaps().size() > this.gapCleaningThreshold) {
            List results = (List)this.transactionManager.fetchInTransaction(() -> this.entityManager().createQuery("SELECT e.globalIndex, e.timeStamp FROM " + this.domainEventEntryEntityName() + " e WHERE e.globalIndex >= :firstGapOffset AND e.globalIndex <= :maxGlobalIndex", Object[].class).setParameter("firstGapOffset", lastToken.getGaps().first()).setParameter("maxGlobalIndex", (Object)((Long)lastToken.getGaps().last() + 1L)).getResultList());
            for (Object[] result : results) {
                try {
                    Instant timestamp = DateTimeUtils.parseInstant((CharSequence)result[1].toString());
                    long sequenceNumber = (Long)result[0];
                    if (previousToken.getGaps().contains(sequenceNumber) || timestamp.isAfter(this.gapTimeoutFrame())) break;
                    if (!previousToken.getGaps().contains(sequenceNumber - 1L)) continue;
                    previousToken = previousToken.advanceTo(sequenceNumber - 1L, this.maxGapOffset, false);
                }
                catch (DateTimeParseException e) {
                    logger.info("Unable to parse timestamp to clean old gaps", (Throwable)e);
                    break;
                }
            }
        }
        return previousToken;
    }

    private Instant gapTimeoutFrame() {
        return GenericEventMessage.clock.instant().minus(this.gapTimeout, ChronoUnit.MILLIS);
    }

    @Override
    protected List<? extends DomainEventData<?>> fetchDomainEvents(String aggregateIdentifier, long firstSequenceNumber, int batchSize) {
        return (List)this.transactionManager.fetchInTransaction(() -> this.entityManager().createQuery("SELECT new org.axonframework.eventhandling.GenericDomainEventEntry(e.type, e.aggregateIdentifier, e.sequenceNumber, e.eventIdentifier, e.timeStamp, e.payloadType, e.payloadRevision, e.payload, e.metaData) FROM " + this.domainEventEntryEntityName() + " e WHERE e.aggregateIdentifier = :id AND e.sequenceNumber >= :seq ORDER BY e.sequenceNumber ASC").setParameter("id", (Object)aggregateIdentifier).setParameter("seq", (Object)firstSequenceNumber).setMaxResults(batchSize).getResultList());
    }

    @Override
    protected Stream<? extends DomainEventData<?>> readSnapshotData(String aggregateIdentifier) {
        return (Stream)this.transactionManager.fetchInTransaction(() -> this.entityManager().createQuery("SELECT new org.axonframework.eventhandling.GenericDomainEventEntry(e.type, e.aggregateIdentifier, e.sequenceNumber, e.eventIdentifier, e.timeStamp, e.payloadType, e.payloadRevision, e.payload, e.metaData) FROM " + this.snapshotEventEntryEntityName() + " e WHERE e.aggregateIdentifier = :id ORDER BY e.sequenceNumber DESC").setParameter("id", (Object)aggregateIdentifier).setMaxResults(1).getResultList().stream());
    }

    @Override
    protected void appendEvents(List<? extends EventMessage<?>> events, Serializer serializer) {
        if (events.isEmpty()) {
            return;
        }
        try {
            events.stream().map(event -> this.createEventEntity((EventMessage<?>)event, serializer)).forEach(arg_0 -> ((EntityManager)this.entityManager()).persist(arg_0));
            if (this.explicitFlush) {
                this.entityManager().flush();
            }
        }
        catch (Exception e) {
            this.handlePersistenceException(e, events.get(0));
        }
    }

    @Override
    protected void storeSnapshot(DomainEventMessage<?> snapshot, Serializer serializer) {
        try {
            this.entityManager().merge(this.createSnapshotEntity(snapshot, serializer));
            this.deleteSnapshots(snapshot.getAggregateIdentifier(), snapshot.getSequenceNumber());
            if (this.explicitFlush) {
                this.entityManager().flush();
            }
        }
        catch (Exception e) {
            this.handlePersistenceException(e, (EventMessage<?>)snapshot);
        }
    }

    @Override
    public Optional<Long> lastSequenceNumberFor(String aggregateIdentifier) {
        List results = this.entityManager().createQuery("SELECT MAX(e.sequenceNumber) FROM " + this.domainEventEntryEntityName() + " e WHERE e.aggregateIdentifier = :aggregateId", Long.class).setParameter("aggregateId", (Object)aggregateIdentifier).getResultList();
        if (results.size() == 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(results.get(0));
    }

    @Override
    public TrackingToken createTailToken() {
        List results = this.entityManager().createQuery("SELECT MIN(e.globalIndex) - 1 FROM " + this.domainEventEntryEntityName() + " e", Long.class).getResultList();
        return this.createToken(results);
    }

    @Override
    public TrackingToken createHeadToken() {
        List results = this.entityManager().createQuery("SELECT MAX(e.globalIndex) FROM " + this.domainEventEntryEntityName() + " e", Long.class).getResultList();
        return this.createToken(results);
    }

    @Override
    public TrackingToken createTokenAt(Instant dateTime) {
        List results = this.entityManager().createQuery("SELECT MIN(e.globalIndex) - 1 FROM " + this.domainEventEntryEntityName() + " e WHERE e.timeStamp >= :dateTime", Long.class).setParameter("dateTime", (Object)DateTimeUtils.formatInstant((TemporalAccessor)dateTime)).getResultList();
        return this.createToken(results);
    }

    private TrackingToken createToken(List<Long> results) {
        if (results.size() == 0 || results.get(0) == null) {
            return null;
        }
        return GapAwareTrackingToken.newInstance((long)results.get(0), Collections.emptySet());
    }

    protected void deleteSnapshots(String aggregateIdentifier, long sequenceNumber) {
        this.entityManager().createQuery("DELETE FROM " + this.snapshotEventEntryEntityName() + " e WHERE e.aggregateIdentifier = :aggregateIdentifier AND e.sequenceNumber < :sequenceNumber").setParameter("aggregateIdentifier", (Object)aggregateIdentifier).setParameter("sequenceNumber", (Object)sequenceNumber).executeUpdate();
    }

    protected Object createEventEntity(EventMessage<?> eventMessage, Serializer serializer) {
        return new DomainEventEntry(EventUtils.asDomainEventMessage(eventMessage), serializer);
    }

    protected Object createSnapshotEntity(DomainEventMessage<?> snapshot, Serializer serializer) {
        return new SnapshotEventEntry(snapshot, serializer);
    }

    protected String domainEventEntryEntityName() {
        return DomainEventEntry.class.getSimpleName();
    }

    protected String snapshotEventEntryEntityName() {
        return SnapshotEventEntry.class.getSimpleName();
    }

    protected EntityManager entityManager() {
        return this.entityManagerProvider.getEntityManager();
    }

    public void setGapTimeout(int gapTimeout) {
        this.gapTimeout = gapTimeout;
    }

    public void setGapCleaningThreshold(int gapCleaningThreshold) {
        this.gapCleaningThreshold = gapCleaningThreshold;
    }

    public static class Builder
    extends BatchingEventStorageEngine.Builder {
        private EntityManagerProvider entityManagerProvider;
        private TransactionManager transactionManager;
        private boolean explicitFlush = true;
        private int maxGapOffset = 10000;
        private long lowestGlobalSequence = 1L;
        private int gapTimeout = 60000;
        private int gapCleaningThreshold = 250;

        @Override
        public Builder snapshotSerializer(Serializer snapshotSerializer) {
            super.snapshotSerializer(snapshotSerializer);
            return this;
        }

        @Override
        public Builder upcasterChain(EventUpcaster upcasterChain) {
            super.upcasterChain(upcasterChain);
            return this;
        }

        @Override
        public Builder persistenceExceptionResolver(PersistenceExceptionResolver persistenceExceptionResolver) {
            super.persistenceExceptionResolver(persistenceExceptionResolver);
            return this;
        }

        @Override
        public Builder eventSerializer(Serializer eventSerializer) {
            super.eventSerializer(eventSerializer);
            return this;
        }

        @Override
        public Builder snapshotFilter(Predicate<? super DomainEventData<?>> snapshotFilter) {
            super.snapshotFilter((Predicate)snapshotFilter);
            return this;
        }

        @Override
        public Builder batchSize(int batchSize) {
            super.batchSize(batchSize);
            return this;
        }

        public Builder dataSource(DataSource dataSource) throws SQLException {
            this.persistenceExceptionResolver(new SQLErrorCodesResolver(dataSource));
            return this;
        }

        public Builder entityManagerProvider(EntityManagerProvider entityManagerProvider) {
            BuilderUtils.assertNonNull((Object)entityManagerProvider, (String)"EntityManagerProvider may not be null");
            this.entityManagerProvider = entityManagerProvider;
            return this;
        }

        public Builder transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull((Object)transactionManager, (String)"TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder explicitFlush(boolean explicitFlush) {
            this.explicitFlush = explicitFlush;
            return this;
        }

        public Builder maxGapOffset(int maxGapOffset) {
            this.assertPositive(maxGapOffset, "maxGapOffset");
            this.maxGapOffset = maxGapOffset;
            return this;
        }

        public Builder lowestGlobalSequence(long lowestGlobalSequence) {
            BuilderUtils.assertThat((Object)lowestGlobalSequence, number -> number > 0L, (String)"The lowestGlobalSequence must be a positive number");
            this.lowestGlobalSequence = lowestGlobalSequence;
            return this;
        }

        public Builder gapTimeout(int gapTimeout) {
            this.assertPositive(gapTimeout, "gapTimeout");
            this.gapTimeout = gapTimeout;
            return this;
        }

        public Builder gapCleaningThreshold(int gapCleaningThreshold) {
            this.assertPositive(gapCleaningThreshold, "gapCleaningThreshold");
            this.gapCleaningThreshold = gapCleaningThreshold;
            return this;
        }

        private void assertPositive(int num, String numberDescription) {
            BuilderUtils.assertThat((Object)num, number -> number > 0, (String)("The " + numberDescription + " must be a positive number"));
        }

        public JpaEventStorageEngine build() {
            return new JpaEventStorageEngine(this);
        }

        @Override
        protected void validate() throws AxonConfigurationException {
            super.validate();
            BuilderUtils.assertNonNull((Object)this.entityManagerProvider, (String)"The EntityManagerProvider is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.transactionManager, (String)"The TransactionManager is a hard requirement and should be provided");
        }
    }
}

