/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventUtils;
import org.axonframework.eventhandling.GapAwareTrackingToken;
import org.axonframework.eventhandling.GenericDomainEventEntry;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.TrackedDomainEventData;
import org.axonframework.eventhandling.TrackedEventData;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.BatchingEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStoreException;
import org.axonframework.eventsourcing.eventstore.jdbc.EventSchema;
import org.axonframework.eventsourcing.eventstore.jdbc.EventTableFactory;
import org.axonframework.eventsourcing.eventstore.jdbc.JdbcSQLErrorCodesResolver;
import org.axonframework.eventsourcing.eventstore.jpa.JpaEventStorageEngine;
import org.axonframework.modelling.command.ConcurrencyException;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcEventStorageEngine
extends BatchingEventStorageEngine {
    private static final Logger logger = LoggerFactory.getLogger(JpaEventStorageEngine.class);
    private static final int DEFAULT_MAX_GAP_OFFSET = 10000;
    private static final long DEFAULT_LOWEST_GLOBAL_SEQUENCE = 1L;
    private static final int DEFAULT_GAP_TIMEOUT = 60000;
    private static final int DEFAULT_GAP_CLEANING_THRESHOLD = 250;
    private final ConnectionProvider connectionProvider;
    private final TransactionManager transactionManager;
    private final Class<?> dataType;
    private final EventSchema schema;
    private final int maxGapOffset;
    private final long lowestGlobalSequence;
    private int gapTimeout;
    private int gapCleaningThreshold;

    protected JdbcEventStorageEngine(Builder builder) {
        super(builder);
        this.connectionProvider = builder.connectionProvider;
        this.transactionManager = builder.transactionManager;
        this.dataType = builder.dataType;
        this.schema = builder.schema;
        this.lowestGlobalSequence = builder.lowestGlobalSequence;
        this.maxGapOffset = builder.maxGapOffset;
        this.gapTimeout = builder.gapTimeout;
        this.gapCleaningThreshold = builder.gapCleaningThreshold;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void createSchema(EventTableFactory schemaFactory) {
        JdbcUtils.executeUpdates((Connection)this.getConnection(), e -> {
            throw new EventStoreException("Failed to create event tables", (Throwable)e);
        }, (JdbcUtils.SqlFunction[])new JdbcUtils.SqlFunction[]{connection -> schemaFactory.createDomainEventTable(connection, this.schema), connection -> schemaFactory.createSnapshotEventTable(connection, this.schema)});
    }

    @Override
    protected void appendEvents(List<? extends EventMessage<?>> events, Serializer serializer) {
        if (events.isEmpty()) {
            return;
        }
        String table = this.schema.domainEventTable();
        String sql = "INSERT INTO " + table + " (" + String.join((CharSequence)", ", this.schema.eventIdentifierColumn(), this.schema.aggregateIdentifierColumn(), this.schema.sequenceNumberColumn(), this.schema.typeColumn(), this.schema.timestampColumn(), this.schema.payloadTypeColumn(), this.schema.payloadRevisionColumn(), this.schema.payloadColumn(), this.schema.metaDataColumn()) + ") VALUES (?,?,?,?,?,?,?,?,?)";
        this.transactionManager.executeInTransaction(() -> JdbcUtils.executeBatch((Connection)this.getConnection(), connection -> {
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            for (EventMessage eventMessage : events) {
                DomainEventMessage event = EventUtils.asDomainEventMessage((EventMessage)eventMessage);
                SerializedObject payload = event.serializePayload(serializer, this.dataType);
                SerializedObject metaData = event.serializeMetaData(serializer, this.dataType);
                preparedStatement.setString(1, event.getIdentifier());
                preparedStatement.setString(2, event.getAggregateIdentifier());
                preparedStatement.setLong(3, event.getSequenceNumber());
                preparedStatement.setString(4, event.getType());
                this.writeTimestamp(preparedStatement, 5, event.getTimestamp());
                preparedStatement.setString(6, payload.getType().getName());
                preparedStatement.setString(7, payload.getType().getRevision());
                preparedStatement.setObject(8, payload.getData());
                preparedStatement.setObject(9, metaData.getData());
                preparedStatement.addBatch();
            }
            return preparedStatement;
        }, e -> this.handlePersistenceException((Exception)e, (EventMessage<?>)((EventMessage)events.get(0)))));
    }

    @Override
    protected void storeSnapshot(DomainEventMessage<?> snapshot, Serializer serializer) {
        this.transactionManager.executeInTransaction(() -> {
            try {
                JdbcUtils.executeUpdates((Connection)this.getConnection(), e -> this.handlePersistenceException((Exception)e, (EventMessage<?>)snapshot), (JdbcUtils.SqlFunction[])new JdbcUtils.SqlFunction[]{connection -> this.appendSnapshot(connection, snapshot, serializer), connection -> this.deleteSnapshots(connection, snapshot.getAggregateIdentifier(), snapshot.getSequenceNumber())});
            }
            catch (ConcurrencyException concurrencyException) {
                // empty catch block
            }
        });
    }

    @Override
    public Optional<Long> lastSequenceNumberFor(String aggregateIdentifier) {
        String sql = "SELECT max(" + this.schema.sequenceNumberColumn() + ") FROM " + this.schema.domainEventTable() + " WHERE " + this.schema.aggregateIdentifierColumn() + " = ?";
        return Optional.ofNullable(this.transactionManager.fetchInTransaction(() -> (Long)JdbcUtils.executeQuery((Connection)this.getConnection(), connection -> {
            PreparedStatement stmt = connection.prepareStatement(sql);
            stmt.setString(1, aggregateIdentifier);
            return stmt;
        }, resultSet -> (Long)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class), e -> new EventStoreException(String.format("Failed to read events for aggregate [%s]", aggregateIdentifier), (Throwable)e))));
    }

    @Override
    public TrackingToken createTailToken() {
        String sql = "SELECT min(" + this.schema.globalIndexColumn() + ") - 1 FROM " + this.schema.domainEventTable();
        Long index = (Long)this.transactionManager.fetchInTransaction(() -> (Long)JdbcUtils.executeQuery((Connection)this.getConnection(), connection -> connection.prepareStatement(sql), resultSet -> (Long)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class), e -> new EventStoreException("Failed to get tail token", (Throwable)e)));
        return Optional.ofNullable(index).map(seq -> GapAwareTrackingToken.newInstance((long)seq, Collections.emptySet())).orElse(null);
    }

    @Override
    public TrackingToken createHeadToken() {
        String sql = "SELECT max(" + this.schema.globalIndexColumn() + ") FROM " + this.schema.domainEventTable();
        Long index = (Long)this.transactionManager.fetchInTransaction(() -> (Long)JdbcUtils.executeQuery((Connection)this.getConnection(), connection -> connection.prepareStatement(sql), resultSet -> (Long)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class), e -> new EventStoreException("Failed to get head token", (Throwable)e)));
        return Optional.ofNullable(index).map(seq -> GapAwareTrackingToken.newInstance((long)seq, Collections.emptySet())).orElse(null);
    }

    @Override
    public TrackingToken createTokenAt(Instant dateTime) {
        String sql = "SELECT min(" + this.schema.globalIndexColumn() + ") - 1 FROM " + this.schema.domainEventTable() + " WHERE " + this.schema.timestampColumn() + " >= ?";
        Long index = (Long)this.transactionManager.fetchInTransaction(() -> (Long)JdbcUtils.executeQuery((Connection)this.getConnection(), connection -> {
            PreparedStatement stmt = connection.prepareStatement(sql);
            stmt.setString(1, DateTimeUtils.formatInstant((TemporalAccessor)dateTime));
            return stmt;
        }, resultSet -> (Long)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class), e -> new EventStoreException(String.format("Failed to get token at [%s]", dateTime), (Throwable)e)));
        if (index == null) {
            return null;
        }
        return GapAwareTrackingToken.newInstance((long)index, Collections.emptySet());
    }

    protected PreparedStatement appendSnapshot(Connection connection, DomainEventMessage<?> snapshot, Serializer serializer) throws SQLException {
        SerializedObject payload = snapshot.serializePayload(serializer, this.dataType);
        SerializedObject metaData = snapshot.serializeMetaData(serializer, this.dataType);
        String sql = "INSERT INTO " + this.schema.snapshotTable() + " (" + String.join((CharSequence)", ", this.schema.eventIdentifierColumn(), this.schema.aggregateIdentifierColumn(), this.schema.sequenceNumberColumn(), this.schema.typeColumn(), this.schema.timestampColumn(), this.schema.payloadTypeColumn(), this.schema.payloadRevisionColumn(), this.schema.payloadColumn(), this.schema.metaDataColumn()) + ") VALUES (?,?,?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, snapshot.getIdentifier());
        preparedStatement.setString(2, snapshot.getAggregateIdentifier());
        preparedStatement.setLong(3, snapshot.getSequenceNumber());
        preparedStatement.setString(4, snapshot.getType());
        this.writeTimestamp(preparedStatement, 5, snapshot.getTimestamp());
        preparedStatement.setString(6, payload.getType().getName());
        preparedStatement.setString(7, payload.getType().getRevision());
        preparedStatement.setObject(8, payload.getData());
        preparedStatement.setObject(9, metaData.getData());
        return preparedStatement;
    }

    protected PreparedStatement deleteSnapshots(Connection connection, String aggregateIdentifier, long sequenceNumber) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM " + this.schema.snapshotTable() + " WHERE " + this.schema.aggregateIdentifierColumn() + " = ? AND " + this.schema.sequenceNumberColumn() + " < ?");
        preparedStatement.setString(1, aggregateIdentifier);
        preparedStatement.setLong(2, sequenceNumber);
        return preparedStatement;
    }

    @Override
    protected List<? extends DomainEventData<?>> fetchDomainEvents(String aggregateIdentifier, long firstSequenceNumber, int batchSize) {
        return (List)this.transactionManager.fetchInTransaction(() -> (List)JdbcUtils.executeQuery((Connection)this.getConnection(), connection -> this.readEventData(connection, aggregateIdentifier, firstSequenceNumber, batchSize), (JdbcUtils.SqlResultConverter)JdbcUtils.listResults(this::getDomainEventData), e -> new EventStoreException(String.format("Failed to read events for aggregate [%s]", aggregateIdentifier), (Throwable)e)));
    }

    @Override
    protected List<? extends TrackedEventData<?>> fetchTrackedEvents(TrackingToken lastToken, int batchSize) {
        Assert.isTrue((lastToken == null || lastToken instanceof GapAwareTrackingToken ? 1 : 0) != 0, () -> "Unsupported token format: " + lastToken);
        return (List)this.transactionManager.fetchInTransaction(() -> {
            GapAwareTrackingToken cleanedToken = lastToken != null && ((GapAwareTrackingToken)lastToken).getGaps().size() > this.gapCleaningThreshold ? this.cleanGaps(lastToken) : (GapAwareTrackingToken)lastToken;
            return (List)JdbcUtils.executeQuery((Connection)this.getConnection(), connection -> this.readEventData(connection, (TrackingToken)cleanedToken, batchSize), resultSet -> {
                GapAwareTrackingToken previousToken = cleanedToken;
                ArrayList results = new ArrayList();
                while (resultSet.next()) {
                    TrackedEventData<?> next = this.getTrackedEventData(resultSet, previousToken);
                    results.add(next);
                    previousToken = (GapAwareTrackingToken)next.trackingToken();
                }
                return results;
            }, e -> new EventStoreException(String.format("Failed to read events from token [%s]", lastToken), (Throwable)e));
        });
    }

    private GapAwareTrackingToken cleanGaps(TrackingToken lastToken) {
        SortedSet gaps = ((GapAwareTrackingToken)lastToken).getGaps();
        return (GapAwareTrackingToken)JdbcUtils.executeQuery((Connection)this.getConnection(), conn -> {
            PreparedStatement statement = conn.prepareStatement(String.format("SELECT %s, %s FROM %s WHERE %s >= ? AND %s <= ?", this.schema.globalIndexColumn(), this.schema.timestampColumn(), this.schema.domainEventTable(), this.schema.globalIndexColumn(), this.schema.globalIndexColumn()));
            statement.setLong(1, (Long)gaps.first());
            statement.setLong(2, (Long)gaps.last() + 1L);
            return statement;
        }, resultSet -> {
            GapAwareTrackingToken cleanToken = (GapAwareTrackingToken)lastToken;
            while (resultSet.next()) {
                try {
                    long sequenceNumber = resultSet.getLong(this.schema.globalIndexColumn());
                    Instant timestamp = DateTimeUtils.parseInstant((CharSequence)this.readTimeStamp(resultSet, this.schema.timestampColumn()).toString());
                    if (gaps.contains(sequenceNumber) || timestamp.isAfter(this.gapTimeoutFrame())) break;
                    if (!gaps.contains(sequenceNumber - 1L)) continue;
                    cleanToken = cleanToken.advanceTo(sequenceNumber - 1L, this.maxGapOffset, false);
                }
                catch (DateTimeParseException e) {
                    logger.info("Unable to parse timestamp to clean old gaps. Tokens may contain large numbers of gaps, decreasing Tracking performance.");
                    break;
                }
            }
            return cleanToken;
        }, e -> new EventStoreException(String.format("Failed to read events from token [%s]", lastToken), (Throwable)e));
    }

    @Override
    protected Stream<? extends DomainEventData<?>> readSnapshotData(String aggregateIdentifier) {
        return (Stream)this.transactionManager.fetchInTransaction(() -> {
            List result = (List)JdbcUtils.executeQuery((Connection)this.getConnection(), connection -> this.readSnapshotData(connection, aggregateIdentifier), (JdbcUtils.SqlResultConverter)JdbcUtils.listResults(this::getSnapshotData), e -> new EventStoreException(String.format("Error reading aggregate snapshot [%s]", aggregateIdentifier), (Throwable)e));
            return result.stream();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreparedStatement readEventData(Connection connection, String identifier, long firstSequenceNumber, int batchSize) throws SQLException {
        Transaction tx = this.transactionManager.startTransaction();
        try {
            String sql = "SELECT " + this.trackedEventFields() + " FROM " + this.schema.domainEventTable() + " WHERE " + this.schema.aggregateIdentifierColumn() + " = ? AND " + this.schema.sequenceNumberColumn() + " >= ? AND " + this.schema.sequenceNumberColumn() + " < ? ORDER BY " + this.schema.sequenceNumberColumn() + " ASC";
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, identifier);
            preparedStatement.setLong(2, firstSequenceNumber);
            preparedStatement.setLong(3, firstSequenceNumber + (long)batchSize);
            PreparedStatement preparedStatement2 = preparedStatement;
            return preparedStatement2;
        }
        finally {
            tx.commit();
        }
    }

    protected PreparedStatement readEventData(Connection connection, TrackingToken lastToken, int batchSize) throws SQLException {
        List gaps;
        Assert.isTrue((lastToken == null || lastToken instanceof GapAwareTrackingToken ? 1 : 0) != 0, () -> String.format("Token [%s] is of the wrong type", lastToken));
        GapAwareTrackingToken previousToken = (GapAwareTrackingToken)lastToken;
        String sql = "SELECT " + this.trackedEventFields() + " FROM " + this.schema.domainEventTable() + " WHERE (" + this.schema.globalIndexColumn() + " > ? AND " + this.schema.globalIndexColumn() + " <= ?) ";
        if (previousToken != null) {
            gaps = new ArrayList(previousToken.getGaps());
            if (!gaps.isEmpty()) {
                sql = sql + " OR " + this.schema.globalIndexColumn() + " IN (" + String.join((CharSequence)",", Collections.nCopies(gaps.size(), "?")) + ") ";
            }
        } else {
            gaps = Collections.emptyList();
        }
        sql = sql + "ORDER BY " + this.schema.globalIndexColumn() + " ASC";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        long globalIndex = previousToken == null ? -1L : previousToken.getIndex();
        preparedStatement.setLong(1, globalIndex);
        preparedStatement.setLong(2, globalIndex + (long)batchSize);
        for (int i = 0; i < gaps.size(); ++i) {
            preparedStatement.setLong(i + 3, (Long)gaps.get(i));
        }
        return preparedStatement;
    }

    protected PreparedStatement readSnapshotData(Connection connection, String identifier) throws SQLException {
        String s = "SELECT " + this.domainEventFields() + " FROM " + this.schema.snapshotTable() + " WHERE " + this.schema.aggregateIdentifierColumn() + " = ? ORDER BY " + this.schema.sequenceNumberColumn() + " DESC";
        PreparedStatement statement = connection.prepareStatement(s);
        statement.setString(1, identifier);
        return statement;
    }

    protected TrackedEventData<?> getTrackedEventData(ResultSet resultSet, GapAwareTrackingToken previousToken) throws SQLException {
        long globalSequence = resultSet.getLong(this.schema.globalIndexColumn());
        GenericDomainEventEntry domainEvent = new GenericDomainEventEntry(resultSet.getString(this.schema.typeColumn()), resultSet.getString(this.schema.aggregateIdentifierColumn()), resultSet.getLong(this.schema.sequenceNumberColumn()), resultSet.getString(this.schema.eventIdentifierColumn()), this.readTimeStamp(resultSet, this.schema.timestampColumn()), resultSet.getString(this.schema.payloadTypeColumn()), resultSet.getString(this.schema.payloadRevisionColumn()), this.readPayload(resultSet, this.schema.payloadColumn()), this.readPayload(resultSet, this.schema.metaDataColumn()));
        boolean allowGaps = domainEvent.getTimestamp().isAfter(this.gapTimeoutFrame());
        GapAwareTrackingToken token = previousToken;
        token = token == null ? GapAwareTrackingToken.newInstance((long)globalSequence, allowGaps ? (Collection)LongStream.range(Math.min(this.lowestGlobalSequence, globalSequence), globalSequence).boxed().collect(Collectors.toCollection(TreeSet::new)) : Collections.emptySortedSet()) : token.advanceTo(globalSequence, this.maxGapOffset, allowGaps);
        return new TrackedDomainEventData((TrackingToken)token, (DomainEventData)domainEvent);
    }

    private Instant gapTimeoutFrame() {
        return GenericEventMessage.clock.instant().minus(this.gapTimeout, ChronoUnit.MILLIS);
    }

    protected DomainEventData<?> getDomainEventData(ResultSet resultSet) throws SQLException {
        return new GenericDomainEventEntry(resultSet.getString(this.schema.typeColumn()), resultSet.getString(this.schema.aggregateIdentifierColumn()), resultSet.getLong(this.schema.sequenceNumberColumn()), resultSet.getString(this.schema.eventIdentifierColumn()), this.readTimeStamp(resultSet, this.schema.timestampColumn()), resultSet.getString(this.schema.payloadTypeColumn()), resultSet.getString(this.schema.payloadRevisionColumn()), this.readPayload(resultSet, this.schema.payloadColumn()), this.readPayload(resultSet, this.schema.metaDataColumn()));
    }

    protected DomainEventData<?> getSnapshotData(ResultSet resultSet) throws SQLException {
        return new GenericDomainEventEntry(resultSet.getString(this.schema.typeColumn()), resultSet.getString(this.schema.aggregateIdentifierColumn()), resultSet.getLong(this.schema.sequenceNumberColumn()), resultSet.getString(this.schema.eventIdentifierColumn()), this.readTimeStamp(resultSet, this.schema.timestampColumn()), resultSet.getString(this.schema.payloadTypeColumn()), resultSet.getString(this.schema.payloadRevisionColumn()), this.readPayload(resultSet, this.schema.payloadColumn()), this.readPayload(resultSet, this.schema.metaDataColumn()));
    }

    protected Object readTimeStamp(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getString(columnName);
    }

    protected void writeTimestamp(PreparedStatement preparedStatement, int position, Instant timestamp) throws SQLException {
        preparedStatement.setString(position, DateTimeUtils.formatInstant((TemporalAccessor)timestamp));
    }

    protected <T> T readPayload(ResultSet resultSet, String columnName) throws SQLException {
        if (byte[].class.equals(this.dataType)) {
            return (T)resultSet.getBytes(columnName);
        }
        return (T)resultSet.getObject(columnName);
    }

    protected String domainEventFields() {
        return String.join((CharSequence)", ", this.schema.eventIdentifierColumn(), this.schema.timestampColumn(), this.schema.payloadTypeColumn(), this.schema.payloadRevisionColumn(), this.schema.payloadColumn(), this.schema.metaDataColumn(), this.schema.typeColumn(), this.schema.aggregateIdentifierColumn(), this.schema.sequenceNumberColumn());
    }

    protected String trackedEventFields() {
        return this.schema.globalIndexColumn() + ", " + this.domainEventFields();
    }

    protected EventSchema schema() {
        return this.schema;
    }

    protected Connection getConnection() {
        try {
            return this.connectionProvider.getConnection();
        }
        catch (SQLException e) {
            throw new EventStoreException("Failed to obtain a database connection", e);
        }
    }

    public void setGapTimeout(int gapTimeout) {
        this.gapTimeout = gapTimeout;
    }

    public void setGapCleaningThreshold(int gapCleaningThreshold) {
        this.gapCleaningThreshold = gapCleaningThreshold;
    }

    public static class Builder
    extends BatchingEventStorageEngine.Builder {
        private ConnectionProvider connectionProvider;
        private TransactionManager transactionManager;
        private Class<?> dataType = byte[].class;
        private EventSchema schema = new EventSchema();
        private int maxGapOffset = 10000;
        private long lowestGlobalSequence = 1L;
        private int gapTimeout = 60000;
        private int gapCleaningThreshold = 250;

        private Builder() {
            this.persistenceExceptionResolver(new JdbcSQLErrorCodesResolver());
        }

        @Override
        public Builder snapshotSerializer(Serializer snapshotSerializer) {
            super.snapshotSerializer(snapshotSerializer);
            return this;
        }

        @Override
        public Builder upcasterChain(EventUpcaster upcasterChain) {
            super.upcasterChain(upcasterChain);
            return this;
        }

        @Override
        public Builder persistenceExceptionResolver(PersistenceExceptionResolver persistenceExceptionResolver) {
            super.persistenceExceptionResolver(persistenceExceptionResolver);
            return this;
        }

        @Override
        public Builder eventSerializer(Serializer eventSerializer) {
            super.eventSerializer(eventSerializer);
            return this;
        }

        @Override
        public Builder snapshotFilter(Predicate<? super DomainEventData<?>> snapshotFilter) {
            super.snapshotFilter((Predicate)snapshotFilter);
            return this;
        }

        @Override
        public Builder batchSize(int batchSize) {
            super.batchSize(batchSize);
            return this;
        }

        public Builder connectionProvider(ConnectionProvider connectionProvider) {
            BuilderUtils.assertNonNull((Object)connectionProvider, (String)"ConnectionProvider may not be null");
            this.connectionProvider = connectionProvider;
            return this;
        }

        public Builder transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull((Object)transactionManager, (String)"TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder dataType(Class<?> dataType) {
            BuilderUtils.assertNonNull(dataType, (String)"dataType may not be null");
            this.dataType = dataType;
            return this;
        }

        public Builder schema(EventSchema schema) {
            BuilderUtils.assertNonNull((Object)schema, (String)"EventSchema may not be null");
            this.schema = schema;
            return this;
        }

        public Builder maxGapOffset(int maxGapOffset) {
            this.assertPositive(maxGapOffset, "maxGapOffset");
            this.maxGapOffset = maxGapOffset;
            return this;
        }

        public Builder lowestGlobalSequence(long lowestGlobalSequence) {
            BuilderUtils.assertThat((Object)lowestGlobalSequence, number -> number > 0L, (String)"The lowestGlobalSequence must be a positive number");
            this.lowestGlobalSequence = lowestGlobalSequence;
            return this;
        }

        public Builder gapTimeout(int gapTimeout) {
            this.assertPositive(gapTimeout, "gapTimeout");
            this.gapTimeout = gapTimeout;
            return this;
        }

        public Builder gapCleaningThreshold(int gapCleaningThreshold) {
            this.assertPositive(gapCleaningThreshold, "gapCleaningThreshold");
            this.gapCleaningThreshold = gapCleaningThreshold;
            return this;
        }

        private void assertPositive(int num, String numberDescription) {
            BuilderUtils.assertThat((Object)num, number -> number > 0, (String)("The " + numberDescription + " must be a positive number"));
        }

        public JdbcEventStorageEngine build() {
            return new JdbcEventStorageEngine(this);
        }

        @Override
        protected void validate() throws AxonConfigurationException {
            super.validate();
            BuilderUtils.assertNonNull((Object)this.connectionProvider, (String)"The ConnectionProvider is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.transactionManager, (String)"The TransactionManager is a hard requirement and should be provided");
        }
    }
}

