/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.disruptor.commandhandling;

import java.util.List;
import java.util.concurrent.Callable;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.disruptor.commandhandling.BlacklistDetectingCallback;
import org.axonframework.disruptor.commandhandling.DisruptorUnitOfWork;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.unitofwork.UnitOfWork;

public class CommandHandlingEntry
extends DisruptorUnitOfWork<CommandMessage<?>> {
    private final MessageHandler<CommandMessage<?>> repeatingCommandHandler = new RepeatingCommandHandler();
    private InterceptorChain invocationInterceptorChain;
    private InterceptorChain publisherInterceptorChain;
    private CommandResultMessage<?> result;
    private int publisherSegmentId;
    private BlacklistDetectingCallback<?, ?> callback;
    private boolean isRecoverEntry;
    private String aggregateIdentifier;
    private int invokerSegmentId;

    public InterceptorChain getInvocationInterceptorChain() {
        return this.invocationInterceptorChain;
    }

    public InterceptorChain getPublisherInterceptorChain() {
        return this.publisherInterceptorChain;
    }

    public void setResult(CommandResultMessage<?> result) {
        this.result = result;
    }

    public CommandResultMessage<?> getResult() {
        return this.result;
    }

    public BlacklistDetectingCallback<?, ?> getCallback() {
        return this.callback;
    }

    public boolean isRecoverEntry() {
        return this.isRecoverEntry;
    }

    public String getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    public int getInvokerId() {
        return this.invokerSegmentId;
    }

    public int getPublisherId() {
        return this.publisherSegmentId;
    }

    public void reset(CommandMessage<?> newCommand, MessageHandler<? super CommandMessage<?>> newCommandHandler, int newInvokerSegmentId, int newPublisherSegmentId, BlacklistDetectingCallback<?, ?> newCallback, List<MessageHandlerInterceptor<? super CommandMessage<?>>> invokerInterceptors, List<MessageHandlerInterceptor<? super CommandMessage<?>>> publisherInterceptors) {
        this.invokerSegmentId = newInvokerSegmentId;
        this.publisherSegmentId = newPublisherSegmentId;
        this.callback = newCallback;
        this.isRecoverEntry = false;
        this.result = null;
        this.aggregateIdentifier = null;
        this.invocationInterceptorChain = new DefaultInterceptorChain((UnitOfWork)this, invokerInterceptors, newCommandHandler);
        this.publisherInterceptorChain = new DefaultInterceptorChain((UnitOfWork)this, publisherInterceptors, this.repeatingCommandHandler);
        this.reset(newCommand);
    }

    public void resetAsRecoverEntry(String newAggregateIdentifier) {
        this.isRecoverEntry = true;
        this.callback = null;
        this.result = null;
        this.invocationInterceptorChain = null;
        this.invokerSegmentId = -1;
        this.publisherSegmentId = -1;
        this.aggregateIdentifier = newAggregateIdentifier;
        this.reset(null);
    }

    public void resetAsCallable(Callable<Object> callable, int newInvokerSegmentId, int newPublisherSegmentId, BlacklistDetectingCallback<Object, Object> newCallback) {
        this.isRecoverEntry = false;
        this.invokerSegmentId = newInvokerSegmentId;
        this.publisherSegmentId = newPublisherSegmentId;
        this.callback = newCallback;
        this.result = null;
        this.aggregateIdentifier = null;
        this.invocationInterceptorChain = callable::call;
        this.publisherInterceptorChain = () -> this.repeatingCommandHandler.handle(null);
        this.reset(null);
    }

    public void registerAggregateIdentifier(String aggregateIdentifier) {
        if (this.aggregateIdentifier != null && !this.aggregateIdentifier.equals(aggregateIdentifier)) {
            throw new IllegalStateException("Cannot load multiple aggregates in the same unit of work when usingDisruptorCommandBus! Already loaded " + this.aggregateIdentifier + ", attempted to load " + aggregateIdentifier);
        }
        this.aggregateIdentifier = aggregateIdentifier;
    }

    private class RepeatingCommandHandler
    implements MessageHandler<CommandMessage<?>> {
        private RepeatingCommandHandler() {
        }

        public Object handle(CommandMessage<?> message) throws Exception {
            return CommandHandlingEntry.this.result;
        }
    }
}

