/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.disruptor.commandhandling;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.DuplicateCommandHandlerResolution;
import org.axonframework.commandhandling.DuplicateCommandHandlerResolver;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.MonitorAwareCallback;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.commandhandling.callbacks.NoOpCallback;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.Registration;
import org.axonframework.common.caching.Cache;
import org.axonframework.common.caching.NoCache;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.disruptor.commandhandling.BlacklistDetectingCallback;
import org.axonframework.disruptor.commandhandling.CommandHandlerInvoker;
import org.axonframework.disruptor.commandhandling.CommandHandlingEntry;
import org.axonframework.disruptor.commandhandling.EventPublisher;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.NoSnapshotTriggerDefinition;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.RollbackConfigurationType;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.AggregateNotFoundException;
import org.axonframework.modelling.command.AggregateScopeDescriptor;
import org.axonframework.modelling.command.AnnotationCommandTargetResolver;
import org.axonframework.modelling.command.CommandTargetResolver;
import org.axonframework.modelling.command.Repository;
import org.axonframework.modelling.command.RepositoryProvider;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisruptorCommandBus
implements CommandBus {
    private static final Logger logger = LoggerFactory.getLogger(DisruptorCommandBus.class);
    private final ConcurrentMap<String, MessageHandler<? super CommandMessage<?>>> commandHandlers = new ConcurrentHashMap();
    private final List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors;
    private final List<MessageHandlerInterceptor<? super CommandMessage<?>>> invokerInterceptors;
    private final List<MessageHandlerInterceptor<? super CommandMessage<?>>> publisherInterceptors;
    private final ExecutorService executorService;
    private final boolean rescheduleOnCorruptState;
    private final long coolingDownPeriod;
    private final CommandTargetResolver commandTargetResolver;
    private final int publisherCount;
    private final MessageMonitor<? super CommandMessage<?>> messageMonitor;
    private final Disruptor<CommandHandlingEntry> disruptor;
    private final CommandHandlerInvoker[] commandHandlerInvokers;
    private final DuplicateCommandHandlerResolver duplicateCommandHandlerResolver;
    private final CommandCallback<Object, Object> defaultCommandCallback;
    private volatile boolean started = true;
    private volatile boolean disruptorShutDown = false;

    public static Builder builder() {
        return new Builder();
    }

    protected DisruptorCommandBus(Builder builder) {
        builder.validate();
        this.dispatchInterceptors = new CopyOnWriteArrayList(builder.dispatchInterceptors);
        this.invokerInterceptors = new CopyOnWriteArrayList(builder.invokerInterceptors);
        this.publisherInterceptors = new ArrayList(builder.publisherInterceptors);
        Executor executor = builder.executor;
        if (executor == null) {
            this.executorService = Executors.newCachedThreadPool((ThreadFactory)new AxonThreadFactory("DisruptorCommandBus"));
            executor = this.executorService;
        } else {
            this.executorService = null;
        }
        this.rescheduleOnCorruptState = builder.rescheduleCommandsOnCorruptState;
        this.coolingDownPeriod = builder.coolingDownPeriod;
        this.commandTargetResolver = builder.commandTargetResolver;
        this.defaultCommandCallback = builder.defaultCommandCallback;
        EventHandler[] publishers = this.initializePublisherThreads(builder.publisherThreadCount, executor, builder.transactionManager, builder.rollbackConfiguration);
        this.publisherCount = publishers.length;
        this.messageMonitor = builder.messageMonitor;
        this.duplicateCommandHandlerResolver = builder.duplicateCommandHandlerResolver;
        this.disruptor = new Disruptor(CommandHandlingEntry::new, builder.bufferSize, executor, builder.producerType, builder.waitStrategy);
        this.commandHandlerInvokers = this.initializeInvokerThreads(builder.invokerThreadCount, builder.cache);
        this.disruptor.setDefaultExceptionHandler((com.lmax.disruptor.ExceptionHandler)new ExceptionHandler());
        this.disruptor.handleEventsWith((EventHandler[])this.commandHandlerInvokers).then(publishers);
        this.disruptor.start();
    }

    private EventPublisher[] initializePublisherThreads(int publisherThreadCount, Executor executor, TransactionManager transactionManager, RollbackConfiguration rollbackConfiguration) {
        EventPublisher[] publishers = new EventPublisher[publisherThreadCount];
        Arrays.setAll(publishers, t -> new EventPublisher(executor, transactionManager, rollbackConfiguration, t));
        return publishers;
    }

    private CommandHandlerInvoker[] initializeInvokerThreads(int invokerThreadCount, Cache cache) {
        CommandHandlerInvoker[] invokers = new CommandHandlerInvoker[invokerThreadCount];
        Arrays.setAll(invokers, t -> new CommandHandlerInvoker(cache, t));
        return invokers;
    }

    public <C> void dispatch(CommandMessage<C> command) {
        this.dispatch(command, this.defaultCommandCallback);
    }

    public <C, R> void dispatch(CommandMessage<C> command, CommandCallback<? super C, ? super R> callback) {
        Assert.state((boolean)this.started, () -> "CommandBus has been shut down. It is not accepting any Commands");
        CommandMessage commandToDispatch = command;
        for (MessageDispatchInterceptor<? super CommandMessage<?>> messageDispatchInterceptor : this.dispatchInterceptors) {
            commandToDispatch = (CommandMessage)messageDispatchInterceptor.handle((Message)commandToDispatch);
        }
        MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested((Message)commandToDispatch);
        try {
            this.doDispatch((CommandMessage<? extends C>)commandToDispatch, (CommandCallback<? super C, R>)new MonitorAwareCallback(callback, monitorCallback));
        }
        catch (Exception exception) {
            monitorCallback.reportFailure((Throwable)exception);
            callback.onResult(commandToDispatch, GenericCommandResultMessage.asCommandResultMessage((Throwable)exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C, R> void doDispatch(CommandMessage<? extends C> command, CommandCallback<? super C, R> callback) {
        String aggregateIdentifier;
        Assert.state((!this.disruptorShutDown ? 1 : 0) != 0, () -> "Disruptor has been shut down. Cannot dispatch or re-dispatch commands");
        MessageHandler commandHandler = (MessageHandler)this.commandHandlers.get(command.getCommandName());
        if (commandHandler == null) {
            callback.onResult(command, GenericCommandResultMessage.asCommandResultMessage((Throwable)new NoHandlerForCommandException(String.format("No handler was subscribed to command [%s]", command.getCommandName()))));
            return;
        }
        RingBuffer ringBuffer = this.disruptor.getRingBuffer();
        int invokerSegment = 0;
        int publisherSegment = 0;
        if ((this.commandHandlerInvokers.length > 1 || this.publisherCount > 1) && (aggregateIdentifier = this.commandTargetResolver.resolveTarget(command).getIdentifier()) != null) {
            int idHash = aggregateIdentifier.hashCode() & Integer.MAX_VALUE;
            if (this.commandHandlerInvokers.length > 1) {
                invokerSegment = idHash % this.commandHandlerInvokers.length;
            }
            if (this.publisherCount > 1) {
                publisherSegment = idHash % this.publisherCount;
            }
        }
        long sequence = ringBuffer.next();
        try {
            CommandHandlingEntry event = (CommandHandlingEntry)((Object)ringBuffer.get(sequence));
            event.reset(command, commandHandler, invokerSegment, publisherSegment, new BlacklistDetectingCallback(callback, (RingBuffer<CommandHandlingEntry>)this.disruptor.getRingBuffer(), this::doDispatch, this.rescheduleOnCorruptState), this.invokerInterceptors, this.publisherInterceptors);
        }
        finally {
            ringBuffer.publish(sequence);
        }
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory) {
        return this.createRepository(eventStore, aggregateFactory, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE);
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory, RepositoryProvider repositoryProvider) {
        return this.createRepository(eventStore, aggregateFactory, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE, repositoryProvider);
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory, SnapshotTriggerDefinition snapshotTriggerDefinition) {
        return this.createRepository(eventStore, aggregateFactory, snapshotTriggerDefinition, ClasspathParameterResolverFactory.forClass((Class)aggregateFactory.getAggregateType()));
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory, SnapshotTriggerDefinition snapshotTriggerDefinition, RepositoryProvider repositoryProvider) {
        return this.createRepository(eventStore, aggregateFactory, snapshotTriggerDefinition, ClasspathParameterResolverFactory.forClass((Class)aggregateFactory.getAggregateType()), (HandlerDefinition)ClasspathHandlerDefinition.forClass((Class)aggregateFactory.getAggregateType()), repositoryProvider);
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory, ParameterResolverFactory parameterResolverFactory) {
        return this.createRepository(eventStore, aggregateFactory, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE, parameterResolverFactory);
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, RepositoryProvider repositoryProvider) {
        return this.createRepository(eventStore, aggregateFactory, (SnapshotTriggerDefinition)NoSnapshotTriggerDefinition.INSTANCE, parameterResolverFactory, handlerDefinition, repositoryProvider);
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory, SnapshotTriggerDefinition snapshotTriggerDefinition, ParameterResolverFactory parameterResolverFactory) {
        return this.createRepository(eventStore, aggregateFactory, snapshotTriggerDefinition, parameterResolverFactory, (HandlerDefinition)ClasspathHandlerDefinition.forClass((Class)aggregateFactory.getAggregateType()), null);
    }

    public <T> Repository<T> createRepository(EventStore eventStore, AggregateFactory<T> aggregateFactory, SnapshotTriggerDefinition snapshotTriggerDefinition, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, RepositoryProvider repositoryProvider) {
        for (CommandHandlerInvoker invoker : this.commandHandlerInvokers) {
            invoker.createRepository(eventStore, repositoryProvider, aggregateFactory, snapshotTriggerDefinition, parameterResolverFactory, handlerDefinition);
        }
        return new DisruptorRepository(aggregateFactory.getAggregateType());
    }

    public Registration subscribe(String commandName, MessageHandler<? super CommandMessage<?>> handler) {
        logger.debug("Subscribing command with name [{}]", (Object)commandName);
        this.commandHandlers.compute(commandName, (cn, existingHandler) -> {
            if (existingHandler == null || existingHandler == handler) {
                return handler;
            }
            return this.duplicateCommandHandlerResolver.resolve(cn, existingHandler, handler);
        });
        return () -> this.commandHandlers.remove(commandName, handler);
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        long lastChangeDetected = System.currentTimeMillis();
        long lastKnownCursor = this.disruptor.getRingBuffer().getCursor();
        while (System.currentTimeMillis() - lastChangeDetected < this.coolingDownPeriod && !Thread.interrupted()) {
            if (this.disruptor.getRingBuffer().getCursor() == lastKnownCursor) continue;
            lastChangeDetected = System.currentTimeMillis();
            lastKnownCursor = this.disruptor.getRingBuffer().getCursor();
        }
        this.disruptorShutDown = true;
        this.disruptor.shutdown();
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super CommandMessage<?>> dispatchInterceptor) {
        this.dispatchInterceptors.add(dispatchInterceptor);
        return () -> this.dispatchInterceptors.remove(dispatchInterceptor);
    }

    public Registration registerHandlerInterceptor(MessageHandlerInterceptor<? super CommandMessage<?>> handlerInterceptor) {
        this.invokerInterceptors.add(handlerInterceptor);
        return () -> this.invokerInterceptors.remove(handlerInterceptor);
    }

    private class ExceptionHandler
    implements com.lmax.disruptor.ExceptionHandler<Object> {
        private ExceptionHandler() {
        }

        public void handleEventException(Throwable ex, long sequence, Object event) {
            logger.error("Exception occurred while processing a {}.", (Object)((CommandMessage)((CommandHandlingEntry)((Object)event)).getMessage()).getPayloadType().getSimpleName(), (Object)ex);
        }

        public void handleOnStartException(Throwable ex) {
            logger.error("Failed to start the DisruptorCommandBus.", ex);
            DisruptorCommandBus.this.disruptor.shutdown();
        }

        public void handleOnShutdownException(Throwable ex) {
            logger.error("Error while shutting down the DisruptorCommandBus", ex);
        }
    }

    private class DisruptorRepository<T>
    implements Repository<T> {
        private final Class<T> type;

        public DisruptorRepository(Class<T> type) {
            this.type = type;
        }

        public Aggregate<T> load(String aggregateIdentifier, Long expectedVersion) {
            return CommandHandlerInvoker.getRepository(this.type).load(aggregateIdentifier, expectedVersion);
        }

        public Aggregate<T> load(String aggregateIdentifier) {
            return CommandHandlerInvoker.getRepository(this.type).load(aggregateIdentifier);
        }

        public Aggregate<T> newInstance(Callable<T> factoryMethod) throws Exception {
            return CommandHandlerInvoker.getRepository(this.type).newInstance(factoryMethod);
        }

        public Aggregate<T> loadOrCreate(String aggregateIdentifier, Callable<T> factoryMethod) throws Exception {
            return CommandHandlerInvoker.getRepository(this.type).loadOrCreate(aggregateIdentifier, factoryMethod);
        }

        public void send(Message<?> message, ScopeDescriptor scopeDescription) throws Exception {
            CompletableFuture future = new CompletableFuture();
            this.send(message, scopeDescription, future);
            try {
                future.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void send(Message<?> message, ScopeDescriptor scopeDescription, CompletableFuture<?> future) {
            if (!this.canResolve(scopeDescription)) {
                future.complete(null);
                return;
            }
            String aggregateIdentifier = ((AggregateScopeDescriptor)scopeDescription).getIdentifier().toString();
            RingBuffer ringBuffer = DisruptorCommandBus.this.disruptor.getRingBuffer();
            int invokerSegment = 0;
            int publisherSegment = 0;
            if ((DisruptorCommandBus.this.commandHandlerInvokers.length > 1 || DisruptorCommandBus.this.publisherCount > 1) && aggregateIdentifier != null) {
                int idHash = aggregateIdentifier.hashCode() & Integer.MAX_VALUE;
                if (DisruptorCommandBus.this.commandHandlerInvokers.length > 1) {
                    invokerSegment = idHash % DisruptorCommandBus.this.commandHandlerInvokers.length;
                }
                if (DisruptorCommandBus.this.publisherCount > 1) {
                    publisherSegment = idHash % DisruptorCommandBus.this.publisherCount;
                }
            }
            long sequence = ringBuffer.next();
            try {
                CommandHandlingEntry event = (CommandHandlingEntry)((Object)ringBuffer.get(sequence));
                event.resetAsCallable(() -> {
                    try {
                        return this.load(aggregateIdentifier).handle(message);
                    }
                    catch (AggregateNotFoundException e) {
                        logger.debug("Aggregate (with id: [{}]) cannot be loaded. Hence, message '[{}]' cannot be handled.", (Object)aggregateIdentifier, (Object)message);
                        return null;
                    }
                }, invokerSegment, publisherSegment, new BlacklistDetectingCallback((commandMessage, commandResultMessage) -> {
                    if (commandResultMessage.isExceptional()) {
                        logger.warn("Failed sending message [{}] to aggregate with id [{}]", (Object)message, (Object)aggregateIdentifier);
                        future.completeExceptionally(commandResultMessage.exceptionResult());
                    } else {
                        future.complete(null);
                    }
                }, (RingBuffer<CommandHandlingEntry>)DisruptorCommandBus.this.disruptor.getRingBuffer(), (commandMessage, callback) -> this.send(message, scopeDescription, future), DisruptorCommandBus.this.rescheduleOnCorruptState));
            }
            finally {
                ringBuffer.publish(sequence);
            }
        }

        public boolean canResolve(ScopeDescriptor scopeDescription) {
            return scopeDescription instanceof AggregateScopeDescriptor && Objects.equals(this.type.getSimpleName(), ((AggregateScopeDescriptor)scopeDescription).getType());
        }
    }

    public static class Builder {
        private static final int DEFAULT_BUFFER_SIZE = 4096;
        private final List<MessageHandlerInterceptor<? super CommandMessage<?>>> invokerInterceptors = new ArrayList();
        private final List<MessageHandlerInterceptor<? super CommandMessage<?>>> publisherInterceptors = new ArrayList();
        private final List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors = new ArrayList();
        private Executor executor;
        private boolean rescheduleCommandsOnCorruptState = true;
        private long coolingDownPeriod = 1000L;
        private CommandTargetResolver commandTargetResolver = AnnotationCommandTargetResolver.builder().build();
        private int publisherThreadCount = 1;
        private MessageMonitor<? super CommandMessage<?>> messageMonitor = NoOpMessageMonitor.INSTANCE;
        private TransactionManager transactionManager;
        private RollbackConfiguration rollbackConfiguration = RollbackConfigurationType.UNCHECKED_EXCEPTIONS;
        private int bufferSize = 4096;
        private ProducerType producerType = ProducerType.MULTI;
        private WaitStrategy waitStrategy = new BlockingWaitStrategy();
        private int invokerThreadCount = 1;
        private Cache cache = NoCache.INSTANCE;
        private DuplicateCommandHandlerResolver duplicateCommandHandlerResolver = DuplicateCommandHandlerResolution.logAndOverride();
        private CommandCallback<Object, Object> defaultCommandCallback = FailureLoggingCommandCallback.access$2000();

        public Builder invokerInterceptors(List<MessageHandlerInterceptor<? super CommandMessage<?>>> invokerInterceptors) {
            this.invokerInterceptors.clear();
            this.invokerInterceptors.addAll(invokerInterceptors);
            return this;
        }

        public Builder publisherInterceptors(List<MessageHandlerInterceptor<CommandMessage<?>>> publisherInterceptors) {
            this.publisherInterceptors.clear();
            this.publisherInterceptors.addAll(publisherInterceptors);
            return this;
        }

        public Builder dispatchInterceptors(List<MessageDispatchInterceptor<CommandMessage<?>>> dispatchInterceptors) {
            this.dispatchInterceptors.clear();
            this.dispatchInterceptors.addAll(dispatchInterceptors);
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder rescheduleCommandsOnCorruptState(boolean rescheduleCommandsOnCorruptState) {
            this.rescheduleCommandsOnCorruptState = rescheduleCommandsOnCorruptState;
            return this;
        }

        public Builder coolingDownPeriod(long coolingDownPeriod) {
            this.assertCoolingDownPeriod(coolingDownPeriod);
            this.coolingDownPeriod = coolingDownPeriod;
            return this;
        }

        public Builder commandTargetResolver(CommandTargetResolver commandTargetResolver) {
            BuilderUtils.assertNonNull((Object)commandTargetResolver, (String)"CommandTargetResolver may not be null");
            this.commandTargetResolver = commandTargetResolver;
            return this;
        }

        public Builder publisherThreadCount(int publisherThreadCount) {
            this.assertPublisherThreadCount(publisherThreadCount);
            this.publisherThreadCount = publisherThreadCount;
            return this;
        }

        public Builder messageMonitor(MessageMonitor<? super CommandMessage<?>> messageMonitor) {
            BuilderUtils.assertNonNull(messageMonitor, (String)"MessageMonitor may not be null");
            this.messageMonitor = messageMonitor;
            return this;
        }

        public Builder transactionManager(TransactionManager transactionManager) {
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
            BuilderUtils.assertNonNull((Object)rollbackConfiguration, (String)"RollbackConfiguration may not be null");
            this.rollbackConfiguration = rollbackConfiguration;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            this.assertBufferSize(bufferSize);
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder producerType(ProducerType producerType) {
            BuilderUtils.assertNonNull((Object)producerType, (String)"ProducerType may not be null");
            this.producerType = producerType;
            return this;
        }

        public Builder waitStrategy(WaitStrategy waitStrategy) {
            BuilderUtils.assertNonNull((Object)waitStrategy, (String)"WaitStrategy may not be null");
            this.waitStrategy = waitStrategy;
            return this;
        }

        public Builder invokerThreadCount(int invokerThreadCount) {
            this.assertInvokerThreadCount(invokerThreadCount);
            this.invokerThreadCount = invokerThreadCount;
            return this;
        }

        public Builder cache(Cache cache) {
            BuilderUtils.assertNonNull((Object)cache, (String)"Cache may not be null");
            this.cache = cache;
            return this;
        }

        public Builder duplicateCommandHandlerResolver(DuplicateCommandHandlerResolver duplicateCommandHandlerResolver) {
            BuilderUtils.assertNonNull((Object)duplicateCommandHandlerResolver, (String)"DuplicateCommandHandlerResolver may not be null");
            this.duplicateCommandHandlerResolver = duplicateCommandHandlerResolver;
            return this;
        }

        public Builder defaultCommandCallback(CommandCallback<Object, Object> defaultCommandCallback) {
            this.defaultCommandCallback = (CommandCallback)ObjectUtils.getOrDefault(defaultCommandCallback, (Object)NoOpCallback.INSTANCE);
            return this;
        }

        public DisruptorCommandBus build() {
            return new DisruptorCommandBus(this);
        }

        protected void validate() {
            this.assertCoolingDownPeriod(this.coolingDownPeriod);
            this.assertPublisherThreadCount(this.publisherThreadCount);
            this.assertBufferSize(this.bufferSize);
            this.assertInvokerThreadCount(this.invokerThreadCount);
        }

        private void assertCoolingDownPeriod(long coolingDownPeriod) {
            BuilderUtils.assertThat((Object)coolingDownPeriod, count -> count > 0L, (String)"The cooling down period must be a positive number");
        }

        private void assertBufferSize(int bufferSize) {
            BuilderUtils.assertThat((Object)bufferSize, size -> size > 0 && size % 2 == 0, (String)"The buffer size must be positive and a power of 2");
        }

        private void assertPublisherThreadCount(int publisherThreadCount) {
            BuilderUtils.assertThat((Object)publisherThreadCount, count -> count > 0, (String)"The publisher thread count must at least be 1");
        }

        private void assertInvokerThreadCount(int invokerThreadCount) {
            BuilderUtils.assertThat((Object)invokerThreadCount, count -> count > 0, (String)"The invoker thread count must be at least 1");
        }
    }

    private static class FailureLoggingCommandCallback
    implements CommandCallback<Object, Object> {
        private static final FailureLoggingCommandCallback INSTANCE = new FailureLoggingCommandCallback();

        private FailureLoggingCommandCallback() {
        }

        public void onResult(CommandMessage<?> commandMessage, CommandResultMessage<?> commandResultMessage) {
            if (commandResultMessage.isExceptional()) {
                logger.info("An error occurred while handling a command [{}].", (Object)commandMessage.getCommandName(), (Object)commandResultMessage.exceptionResult());
            }
        }

        static /* synthetic */ FailureLoggingCommandCallback access$2000() {
            return INSTANCE;
        }
    }
}

