/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.disruptor.commandhandling;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.eventsourcing.EventSourcedAggregate;

class FirstLevelCache<T> {
    private Map<String, WeakValue> delegate;
    private ReferenceQueue<EventSourcedAggregate<T>> queue;

    private FirstLevelCache(int capacity) {
        this.delegate = new ConcurrentHashMap<String, WeakValue>(capacity);
        this.queue = new ReferenceQueue();
    }

    FirstLevelCache() {
        this(1);
    }

    public EventSourcedAggregate<T> put(String key, EventSourcedAggregate<T> value) {
        this.processQueue();
        WeakValue valueRef = new WeakValue(key, value, this.queue);
        return this.getReferenceValue(this.delegate.put(key, valueRef));
    }

    public EventSourcedAggregate<T> get(Object key) {
        this.processQueue();
        return this.getReferenceValue(this.delegate.get(key));
    }

    public EventSourcedAggregate<T> remove(Object key) {
        return this.getReferenceValue(this.delegate.remove(key));
    }

    private EventSourcedAggregate<T> getReferenceValue(WeakValue valueRef) {
        return valueRef == null ? null : (EventSourcedAggregate)valueRef.get();
    }

    private void processQueue() {
        WeakValue valueRef;
        while ((valueRef = (WeakValue)this.queue.poll()) != null) {
            this.delegate.remove(valueRef.getKey());
        }
    }

    private class WeakValue
    extends WeakReference<EventSourcedAggregate<T>> {
        private final String key;

        private WeakValue(String key, EventSourcedAggregate<T> value, ReferenceQueue<EventSourcedAggregate<T>> queue) {
            super(value, queue);
            this.key = key;
        }

        private String getKey() {
            return this.key;
        }
    }
}

