/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.conversion.avro;

import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.InvalidAvroMagicException;
import org.apache.avro.InvalidNumberEncodingException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.SchemaNormalization;
import org.apache.avro.generic.GenericData;
import org.apache.avro.message.BadHeaderException;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecordBase;
import org.axonframework.conversion.ConversionException;

public class AvroUtil {
    public static final int MAGIC_BYTE = 195;
    public static final int FORMAT_VERSION = 1;
    public static final int AVRO_FINGERPRINT_LENGTH = 8;
    public static final int AVRO_HEADER_LENGTH = 10;
    public static final GenericData genericData = GenericData.get();

    private AvroUtil() {
    }

    public static long fingerprint(@Nonnull byte[] singleObjectEncodedBytes) {
        long l;
        ByteArrayInputStream bis = new ByteArrayInputStream(singleObjectEncodedBytes);
        try {
            int magicByte = bis.read();
            int versionByte = bis.read();
            if (magicByte != 195) {
                throw new InvalidAvroMagicException(String.format("Unrecognized header magic byte: 0x%02X", magicByte));
            }
            if (versionByte != 1) {
                throw new InvalidNumberEncodingException(String.format("Unrecognized header version bytes: 0x%02X", versionByte));
            }
            byte[] fingerprintBytes = new byte[8];
            int read = bis.read(fingerprintBytes);
            if (read != 8) {
                throw new BadHeaderException("Could not read header bytes, end of stream reached at position " + read);
            }
            l = ByteBuffer.wrap(fingerprintBytes).order(ByteOrder.LITTLE_ENDIAN).getLong();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AvroRuntimeException("Could not read fingerprint from byte array");
            }
        }
        bis.close();
        return l;
    }

    public static byte[] payload(@Nonnull byte[] singleObjectEncodedBytes) {
        byte[] byArray;
        ByteArrayInputStream bis = new ByteArrayInputStream(singleObjectEncodedBytes);
        try {
            if (10L != bis.skip(10L)) {
                throw new BadHeaderException("Could not read header bytes, end of stream reached.");
            }
            byte[] payloadBytes = new byte[singleObjectEncodedBytes.length - 10];
            if (bis.read(payloadBytes) != payloadBytes.length) {
                throw new AvroRuntimeException("Could not read payload from byte array - Insufficient payload bytes.");
            }
            byArray = payloadBytes;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AvroRuntimeException("Could not read payload from byte array");
            }
        }
        bis.close();
        return byArray;
    }

    public static GenericData fromSpecificData(SpecificData specificData) {
        GenericData genericData = new GenericData();
        specificData.getConversions().forEach(arg_0 -> ((GenericData)genericData).addLogicalTypeConversion(arg_0));
        return genericData;
    }

    @Nonnull
    public static Schema getClassSchemaChecked(@Nonnull Class<SpecificRecordBase> specificRecordBaseClass) {
        try {
            return AvroUtil.getClassSchema(specificRecordBaseClass);
        }
        catch (Exception e) {
            throw new AvroRuntimeException("Could not get schema from specific record class " + specificRecordBaseClass.getCanonicalName(), (Throwable)e);
        }
    }

    @Nonnull
    public static Schema getClassSchema(@Nonnull Class<SpecificRecordBase> clazz) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return (Schema)clazz.getMethod("getClassSchema", new Class[0]).invoke(null, new Object[0]);
    }

    public static long fingerprint(@Nonnull Schema schema) {
        return SchemaNormalization.parsingFingerprint64((Schema)schema);
    }

    public static List<SchemaCompatibility.Incompatibility> checkCompatibility(@Nonnull Schema readerSchema, @Nonnull Schema writerSchema) {
        SchemaCompatibility.SchemaCompatibilityResult schemaPairCompatibilityResult = SchemaCompatibility.checkReaderWriterCompatibility((Schema)readerSchema, (Schema)writerSchema).getResult();
        if (schemaPairCompatibilityResult.getCompatibility().equals((Object)SchemaCompatibility.SchemaCompatibilityType.INCOMPATIBLE)) {
            return schemaPairCompatibilityResult.getIncompatibilities();
        }
        return new ArrayList<SchemaCompatibility.Incompatibility>();
    }

    @Nonnull
    public static ConversionException createExceptionFailedToDeserialize(@Nonnull Class<?> readerType, @Nonnull Schema readerSchema, @Nonnull Schema writerSchema, Exception cause, boolean includeSchemasInStackTraces) {
        return new ConversionException("Failed to deserialize single-object-encoded bytes to instance of " + readerType.getCanonicalName() + ", writer schema fingerprint is " + AvroUtil.fingerprint(writerSchema) + (String)(includeSchemasInStackTraces ? ", writer schema is " + String.valueOf(writerSchema) : "") + " reader schema fingerprint is " + AvroUtil.fingerprint(readerSchema) + (String)(includeSchemasInStackTraces ? ", reader schema is " + String.valueOf(readerSchema) : ""), cause);
    }

    public static ConversionException createExceptionFailedToDeserialize(@Nonnull Class<?> readerType, @Nonnull Schema readerSchema, @Nonnull Schema writerSchema, String message, boolean includeSchemasInStackTraces) {
        return new ConversionException("Failed to deserialize single-object-encoded bytes to instance of " + readerType.getCanonicalName() + ", writer schema fingerprint is " + AvroUtil.fingerprint(writerSchema) + (String)(includeSchemasInStackTraces ? ", writer schema is " + String.valueOf(writerSchema) : "") + ", reader schema fingerprint is " + AvroUtil.fingerprint(readerSchema) + (String)(includeSchemasInStackTraces ? ", reader schema is " + String.valueOf(readerSchema) : "") + ", detected incompatibilities are: " + message + ". Consider to define an upcaster to fix this problem.");
    }

    public static String incompatibilityPrinter(@Nonnull SchemaCompatibility.Incompatibility incompatibility) {
        return String.format("%s located at \"%s\" with value \"%s\"", incompatibility.getType(), incompatibility.getLocation(), incompatibility.getMessage());
    }

    public static ConversionException createExceptionNoSchemaFound(@Nonnull Class<?> readerType, long fingerprint) {
        return new ConversionException("Schema store could didn't contain schema deserializing " + String.valueOf(readerType) + " with fingerprint:" + fingerprint);
    }
}

