/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.conversion;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.axonframework.common.Assert;
import org.axonframework.conversion.ContentTypeConverter;
import org.axonframework.conversion.ConversionException;

public class ChainedConverter<S, T>
implements ContentTypeConverter<S, T> {
    private final Class<S> source;
    private final Class<T> target;
    private final List<ContentTypeConverter<?, ?>> delegates;

    public static <S, T> ChainedConverter<S, T> calculateChain(@Nonnull Class<S> sourceType, @Nonnull Class<T> targetType, @Nonnull Collection<ContentTypeConverter<?, ?>> candidates) {
        Route route = ChainedConverter.calculateRoute(sourceType, targetType, candidates);
        if (route == null) {
            throw new ConversionException(String.format("Cannot build a converter to convert from %s to %s", sourceType.getName(), targetType.getName()));
        }
        return new ChainedConverter<S, T>(route.asList());
    }

    public static <S, T> boolean canConvert(@Nonnull Class<S> sourceContentType, @Nonnull Class<T> targetContentType, @Nonnull List<ContentTypeConverter<?, ?>> converters) {
        return ChainedConverter.calculateRoute(sourceContentType, targetContentType, converters) != null;
    }

    private static <S, T> Route calculateRoute(Class<S> sourceType, Class<T> targetType, Collection<ContentTypeConverter<?, ?>> candidates) {
        return new RouteCalculator(candidates).calculateRoute(sourceType, targetType);
    }

    public ChainedConverter(@Nonnull List<ContentTypeConverter<?, ?>> delegates) {
        Assert.isTrue((!delegates.isEmpty() ? 1 : 0) != 0, () -> "The given delegates may not be null or empty");
        Assert.isTrue((boolean)this.isContinuous(delegates), () -> "The given delegates must form a continuous chain");
        this.delegates = new ArrayList(delegates);
        this.source = this.delegates.getFirst().expectedSourceType();
        this.target = this.delegates.getLast().targetType();
    }

    private boolean isContinuous(List<ContentTypeConverter<?, ?>> candidates) {
        Class<?> current = null;
        for (ContentTypeConverter<?, ?> candidate : candidates) {
            if (current == null || current.equals(candidate.expectedSourceType())) {
                current = candidate.targetType();
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public Class<S> expectedSourceType() {
        return this.source;
    }

    @Override
    @Nonnull
    public Class<T> targetType() {
        return this.target;
    }

    @Override
    @Nullable
    public T convert(@Nullable S input) {
        Object intermediate = input;
        for (ContentTypeConverter<?, ?> step : this.delegates) {
            intermediate = step.convert(intermediate);
        }
        return (T)intermediate;
    }

    private static final class Route {
        private final ContentTypeConverter<?, ?>[] nodes;
        private final Class<?> endPoint;

        private Route(ContentTypeConverter<?, ?> initialVertex) {
            this.nodes = new ContentTypeConverter[]{initialVertex};
            this.endPoint = initialVertex.targetType();
        }

        private Route(ContentTypeConverter<?, ?>[] baseNodes, ContentTypeConverter<?, ?> newDestination) {
            this.nodes = Arrays.copyOf(baseNodes, baseNodes.length + 1);
            this.nodes[baseNodes.length] = newDestination;
            this.endPoint = newDestination.targetType();
        }

        private Route joinedWith(ContentTypeConverter<?, ?> newVertex) {
            Assert.isTrue((boolean)this.endPoint.equals(newVertex.expectedSourceType()), () -> "Cannot append a vertex if it does not start where the current Route ends");
            return new Route(this.nodes, newVertex);
        }

        private Class<?> endPoint() {
            return this.endPoint;
        }

        private List<ContentTypeConverter<?, ?>> asList() {
            return Arrays.asList(this.nodes);
        }
    }

    private static final class RouteCalculator {
        private final Set<ContentTypeConverter<?, ?>> candidates;
        private final List<Route> routes = new LinkedList<Route>();

        private RouteCalculator(Collection<ContentTypeConverter<?, ?>> candidates) {
            this.candidates = new HashSet(candidates);
        }

        private Route calculateRoute(Class<?> sourceType, Class<?> targetType) {
            Route match = this.buildInitialRoutes(sourceType, targetType);
            if (match != null) {
                return match;
            }
            while (!this.candidates.isEmpty() && !this.routes.isEmpty()) {
                Route route = this.getShortestRoute();
                for (ContentTypeConverter<?, ?> candidate : new HashSet(this.candidates)) {
                    if (!route.endPoint().equals(candidate.expectedSourceType())) continue;
                    Route newRoute = route.joinedWith(candidate);
                    this.candidates.remove(candidate);
                    if (targetType.equals(newRoute.endPoint())) {
                        return newRoute;
                    }
                    this.routes.add(newRoute);
                }
                this.routes.remove(route);
            }
            return null;
        }

        private Route buildInitialRoutes(Class<?> sourceType, Class<?> targetType) {
            for (ContentTypeConverter<?, ?> converter : new HashSet(this.candidates)) {
                if (!converter.expectedSourceType().isAssignableFrom(sourceType)) continue;
                Route route = new Route(converter);
                if (targetType.isAssignableFrom(route.endPoint())) {
                    return route;
                }
                this.routes.add(route);
                this.candidates.remove(converter);
            }
            return null;
        }

        private Route getShortestRoute() {
            return this.routes.getFirst();
        }
    }
}

