/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import jakarta.annotation.Nonnull;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandHandlingComponent;
import org.axonframework.commandhandling.InterceptingCommandBus;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.annotation.AnnotatedCommandHandlingComponent;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.commandhandling.tracing.CommandBusSpanFactory;
import org.axonframework.commandhandling.tracing.DefaultCommandBusSpanFactory;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.AxonIQConsoleModule;
import org.axonframework.config.Component;
import org.axonframework.config.ConfigurationResourceInjector;
import org.axonframework.config.ConfigurationScopeAwareProvider;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.config.EventProcessingConfigurer;
import org.axonframework.config.EventProcessingModule;
import org.axonframework.config.LegacyConfiguration;
import org.axonframework.config.LegacyConfigurer;
import org.axonframework.config.LifecycleHandler;
import org.axonframework.config.MessageHandlerRegistrar;
import org.axonframework.config.MessageMonitorFactory;
import org.axonframework.config.MessageMonitorFactoryBuilder;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.deadline.DeadlineManager;
import org.axonframework.deadline.DeadlineManagerSpanFactory;
import org.axonframework.deadline.DefaultDeadlineManagerSpanFactory;
import org.axonframework.deadline.SimpleDeadlineManager;
import org.axonframework.eventhandling.DefaultEventBusSpanFactory;
import org.axonframework.eventhandling.DefaultEventProcessorSpanFactory;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventBusSpanFactory;
import org.axonframework.eventhandling.EventProcessorSpanFactory;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.gateway.DefaultEventGateway;
import org.axonframework.eventhandling.gateway.EventGateway;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.jpa.JpaTokenStore;
import org.axonframework.eventsourcing.AggregateSnapshotter;
import org.axonframework.eventsourcing.DefaultSnapshotterSpanFactory;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.SnapshotterSpanFactory;
import org.axonframework.eventsourcing.eventstore.LegacyEmbeddedEventStore;
import org.axonframework.eventsourcing.eventstore.LegacyEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.LegacyEventStore;
import org.axonframework.eventsourcing.eventstore.jpa.LegacyJpaEventStorageEngine;
import org.axonframework.lifecycle.LifecycleHandlerInvocationException;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MultiHandlerDefinition;
import org.axonframework.messaging.annotation.MultiHandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.correlation.MessageOriginProvider;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.messaging.unitofwork.ProcessingLifecycleHandlerRegistrar;
import org.axonframework.modelling.command.DefaultRepositorySpanFactory;
import org.axonframework.modelling.command.RepositorySpanFactory;
import org.axonframework.modelling.saga.DefaultSagaManagerSpanFactory;
import org.axonframework.modelling.saga.ResourceInjector;
import org.axonframework.modelling.saga.SagaManagerSpanFactory;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.modelling.saga.repository.jpa.JpaSagaStore;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.queryhandling.DefaultQueryBusSpanFactory;
import org.axonframework.queryhandling.DefaultQueryGateway;
import org.axonframework.queryhandling.DefaultQueryUpdateEmitterSpanFactory;
import org.axonframework.queryhandling.LoggingQueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryBusSpanFactory;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.QueryUpdateEmitterSpanFactory;
import org.axonframework.queryhandling.SimpleQueryBus;
import org.axonframework.queryhandling.SimpleQueryUpdateEmitter;
import org.axonframework.queryhandling.annotation.AnnotationQueryHandlerAdapter;
import org.axonframework.serialization.AnnotationRevisionResolver;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.serialization.upcasting.event.EventUpcasterChain;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.axonframework.tracing.NoOpSpanFactory;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.util.HandlerTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="5.0.0", forRemoval=true)
public class LegacyDefaultConfigurer
implements LegacyConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Runnable NOTHING = () -> {};
    private final LegacyConfiguration config = new ConfigurationImpl();
    private final MessageMonitorFactoryBuilder messageMonitorFactoryBuilder = new MessageMonitorFactoryBuilder();
    private final Component<BiFunction<Class<?>, String, MessageMonitor<Message<?>>>> messageMonitorFactoryComponent = new Component<BiFunction>(this.config, "monitorFactory", this.messageMonitorFactoryBuilder::build);
    private final Component<List<CorrelationDataProvider>> correlationProviders = new Component<List>(this.config, "correlationProviders", c -> Collections.singletonList(new MessageOriginProvider()));
    private final Map<Class<?>, Component<?>> components = new ConcurrentHashMap();
    private final List<Component<MessageHandlerRegistrar>> messageHandlerRegistrars = new ArrayList<Component<MessageHandlerRegistrar>>();
    private final Component<Serializer> eventSerializer = new Component<Serializer>(this.config, "eventSerializer", LegacyConfiguration::messageSerializer);
    private final Component<Serializer> messageSerializer = new Component<Serializer>(this.config, "messageSerializer", LegacyConfiguration::serializer);
    private final List<Component<EventUpcaster>> upcasters = new ArrayList<Component<EventUpcaster>>();
    private final Component<EventUpcasterChain> upcasterChain = new Component<EventUpcasterChain>(this.config, "eventUpcasterChain", this::defaultUpcasterChain);
    private final MessageTypeResolver messageTypeResolver = new ClassBasedMessageTypeResolver();
    private final Component<Function<Class<?>, HandlerDefinition>> handlerDefinition = new Component<Function>(this.config, "handlerDefinition", c -> this::defaultHandlerDefinition);
    private final List<Component<HandlerEnhancerDefinition>> handlerEnhancerDefinitions = new ArrayList<Component<HandlerEnhancerDefinition>>();
    private final List<Consumer<LegacyConfiguration>> initHandlers = new ArrayList<Consumer<LegacyConfiguration>>();
    private final TreeMap<Integer, List<LifecycleHandler>> startHandlers = new TreeMap();
    private final TreeMap<Integer, List<LifecycleHandler>> shutdownHandlers = new TreeMap(Comparator.reverseOrder());
    private final List<ModuleConfiguration> modules = new ArrayList<ModuleConfiguration>();
    private long lifecyclePhaseTimeout = 5L;
    private TimeUnit lifecyclePhaseTimeunit = TimeUnit.SECONDS;
    private boolean initialized = false;
    private Integer currentLifecyclePhase = null;
    private LifecycleState lifecycleState = LifecycleState.DOWN;

    protected LegacyDefaultConfigurer() {
        this.components.put(ParameterResolverFactory.class, new Component<ParameterResolverFactory>(this.config, "parameterResolverFactory", this::defaultParameterResolverFactory));
        this.components.put(Serializer.class, new Component<Serializer>(this.config, "serializer", this::defaultSerializer));
        this.components.put(CommandBus.class, new Component<CommandBus>(this.config, "commandBus", this::defaultCommandBus));
        this.components.put(EventBus.class, new Component<EventBus>(this.config, "eventBus", this::defaultEventBus));
        this.components.put(LegacyEventStore.class, new Component<LegacyEventStore>(this.config, "eventStore", LegacyConfiguration::eventStore));
        this.components.put(CommandGateway.class, new Component<CommandGateway>(this.config, "commandGateway", this::defaultCommandGateway));
        this.components.put(QueryBus.class, new Component<QueryBus>(this.config, "queryBus", this::defaultQueryBus));
        this.components.put(QueryUpdateEmitter.class, new Component<QueryUpdateEmitter>(this.config, "queryUpdateEmitter", this::defaultQueryUpdateEmitter));
        this.components.put(QueryGateway.class, new Component<QueryGateway>(this.config, "queryGateway", this::defaultQueryGateway));
        this.components.put(ResourceInjector.class, new Component<ResourceInjector>(this.config, "resourceInjector", this::defaultResourceInjector));
        this.components.put(ScopeAwareProvider.class, new Component<ScopeAwareProvider>(this.config, "scopeAwareProvider", this::defaultScopeAwareProvider));
        this.components.put(DeadlineManager.class, new Component<DeadlineManager>(this.config, "deadlineManager", this::defaultDeadlineManager));
        this.components.put(EventUpcaster.class, this.upcasterChain);
        this.components.put(EventGateway.class, new Component<EventGateway>(this.config, "eventGateway", this::defaultEventGateway));
        this.components.put(Snapshotter.class, new Component<Snapshotter>(this.config, "snapshotter", this::defaultSnapshotter));
        this.components.put(SpanFactory.class, new Component<SpanFactory>(this.config, "spanFactory", this::defaultSpanFactory));
        this.components.put(SnapshotterSpanFactory.class, new Component<SnapshotterSpanFactory>(this.config, "snapshotterSpanFactory", this::defaultSnapshotterSpanFactory));
        this.components.put(CommandBusSpanFactory.class, new Component<CommandBusSpanFactory>(this.config, "commandBusSpanFactory", this::defaultCommandBusSpanFactory));
        this.components.put(QueryBusSpanFactory.class, new Component<QueryBusSpanFactory>(this.config, "queryBusSpanFactory", this::defaultQueryBusSpanFactory));
        this.components.put(QueryUpdateEmitterSpanFactory.class, new Component<QueryUpdateEmitterSpanFactory>(this.config, "queryUpdateEmitterSpanFactory", this::defaultQueryUpdateEmitterSpanFactory));
        this.components.put(EventBusSpanFactory.class, new Component<EventBusSpanFactory>(this.config, "eventBusSpanFactory", this::defaultEventBusSpanFactory));
        this.components.put(DeadlineManagerSpanFactory.class, new Component<DeadlineManagerSpanFactory>(this.config, "deadlineManagerSpanFactory", this::defaultDeadlineManagerSpanFactory));
        this.components.put(SagaManagerSpanFactory.class, new Component<SagaManagerSpanFactory>(this.config, "sagaManagerSpanFactory", this::defaultSagaManagerSpanFactory));
        this.components.put(RepositorySpanFactory.class, new Component<RepositorySpanFactory>(this.config, "repositorySpanFactory", this::defaultRepositorySpanFactory));
        this.components.put(EventProcessorSpanFactory.class, new Component<EventProcessorSpanFactory>(this.config, "eventProcessorSpanFactory", this::defaultEventProcessorSpanFactory));
        this.registerModule(new AxonIQConsoleModule());
    }

    public static LegacyConfigurer defaultConfiguration() {
        return LegacyDefaultConfigurer.defaultConfiguration(true);
    }

    public static LegacyConfigurer defaultConfiguration(boolean autoLocateConfigurerModules) {
        LegacyDefaultConfigurer configurer = new LegacyDefaultConfigurer();
        if (autoLocateConfigurerModules) {
            ServiceLoader<ConfigurerModule> configurerModuleLoader = ServiceLoader.load(ConfigurerModule.class, configurer.getClass().getClassLoader());
            ArrayList<ConfigurerModule> configurerModules = new ArrayList<ConfigurerModule>();
            configurerModuleLoader.forEach(configurerModules::add);
            configurerModules.sort(Comparator.comparingInt(ConfigurerModule::order));
            configurerModules.forEach(cm -> cm.configureModule(configurer));
        }
        return configurer;
    }

    public static LegacyConfigurer jpaConfiguration(EntityManagerProvider entityManagerProvider, TransactionManager transactionManager) {
        return new LegacyDefaultConfigurer().registerComponent(EntityManagerProvider.class, c -> entityManagerProvider).registerComponent(TransactionManager.class, c -> transactionManager).configureEmbeddedEventStore(c -> LegacyJpaEventStorageEngine.builder().snapshotSerializer(c.serializer()).upcasterChain((EventUpcaster)c.upcasterChain()).persistenceExceptionResolver(c.getComponent(PersistenceExceptionResolver.class)).eventSerializer(c.eventSerializer()).snapshotFilter(c.snapshotFilter()).entityManagerProvider(c.getComponent(EntityManagerProvider.class)).transactionManager(c.getComponent(TransactionManager.class)).build()).registerComponent(TokenStore.class, c -> JpaTokenStore.builder().entityManagerProvider(c.getComponent(EntityManagerProvider.class)).serializer(c.serializer()).build()).registerComponent(SagaStore.class, c -> JpaSagaStore.builder().entityManagerProvider(c.getComponent(EntityManagerProvider.class)).serializer(c.serializer()).build());
    }

    public static LegacyConfigurer jpaConfiguration(EntityManagerProvider entityManagerProvider) {
        return LegacyDefaultConfigurer.jpaConfiguration(entityManagerProvider, (TransactionManager)NoTransactionManager.INSTANCE);
    }

    protected <T> Optional<T> defaultComponent(Class<T> type, LegacyConfiguration configuration) {
        return Optional.empty();
    }

    protected CommandGateway defaultCommandGateway(LegacyConfiguration config) {
        return this.defaultComponent(CommandGateway.class, config).orElseGet(() -> new DefaultCommandGateway(config.commandBus(), this.messageTypeResolver));
    }

    protected QueryGateway defaultQueryGateway(LegacyConfiguration config) {
        return this.defaultComponent(QueryGateway.class, config).orElseGet(() -> DefaultQueryGateway.builder().queryBus(config.queryBus()).build());
    }

    protected QueryBus defaultQueryBus(LegacyConfiguration config) {
        return this.defaultComponent(QueryBus.class, config).orElseGet(() -> {
            SimpleQueryBus queryBus = SimpleQueryBus.builder().messageMonitor(config.messageMonitor(SimpleQueryBus.class, "queryBus")).transactionManager(config.getComponent(TransactionManager.class, NoTransactionManager::instance)).errorHandler(config.getComponent(QueryInvocationErrorHandler.class, () -> LoggingQueryInvocationErrorHandler.builder().build())).queryUpdateEmitter(config.getComponent(QueryUpdateEmitter.class)).spanFactory(config.getComponent(QueryBusSpanFactory.class)).build();
            queryBus.registerHandlerInterceptor((MessageHandlerInterceptor)new CorrelationDataInterceptor(config.correlationDataProviders()));
            return queryBus;
        });
    }

    protected QueryUpdateEmitter defaultQueryUpdateEmitter(LegacyConfiguration config) {
        return this.defaultComponent(QueryUpdateEmitter.class, config).orElseGet(() -> {
            MessageMonitor updateMessageMonitor = config.messageMonitor(QueryUpdateEmitter.class, "queryUpdateEmitter");
            return SimpleQueryUpdateEmitter.builder().updateMessageMonitor(updateMessageMonitor).spanFactory(config.getComponent(QueryUpdateEmitterSpanFactory.class)).build();
        });
    }

    protected ParameterResolverFactory defaultParameterResolverFactory(LegacyConfiguration config) {
        return this.defaultComponent(ParameterResolverFactory.class, config).orElseGet(() -> ClasspathParameterResolverFactory.forClass(this.getClass()));
    }

    protected HandlerDefinition defaultHandlerDefinition(Class<?> inspectedClass) {
        HandlerDefinition definition = this.defaultComponent(HandlerDefinition.class, this.config).orElseGet(() -> ClasspathHandlerDefinition.forClass((Class)inspectedClass));
        List registeredEnhancerDefinitions = this.handlerEnhancerDefinitions.stream().map(Component::get).collect(Collectors.toList());
        if (definition instanceof MultiHandlerDefinition) {
            registeredEnhancerDefinitions.add(((MultiHandlerDefinition)definition).getHandlerEnhancerDefinition());
        }
        return MultiHandlerDefinition.ordered(Collections.singletonList(definition), (HandlerEnhancerDefinition)MultiHandlerEnhancerDefinition.ordered(registeredEnhancerDefinitions));
    }

    protected CommandBus defaultCommandBus(LegacyConfiguration config) {
        return this.defaultComponent(CommandBus.class, config).orElseGet(() -> {
            SimpleCommandBus commandBus;
            TransactionManager txManager = config.getComponent(TransactionManager.class);
            SimpleCommandBus simpleCommandBus = commandBus = txManager != null ? new SimpleCommandBus(new ProcessingLifecycleHandlerRegistrar[]{txManager}) : new SimpleCommandBus(new ProcessingLifecycleHandlerRegistrar[0]);
            if (!config.correlationDataProviders().isEmpty()) {
                CorrelationDataInterceptor interceptor = new CorrelationDataInterceptor(config.correlationDataProviders());
                return new InterceptingCommandBus((CommandBus)commandBus, List.of(interceptor), List.of());
            }
            return commandBus;
        });
    }

    protected ResourceInjector defaultResourceInjector(LegacyConfiguration config) {
        return this.defaultComponent(ResourceInjector.class, config).orElseGet(() -> new ConfigurationResourceInjector(config));
    }

    protected ScopeAwareProvider defaultScopeAwareProvider(LegacyConfiguration config) {
        return this.defaultComponent(ScopeAwareProvider.class, config).orElseGet(() -> new ConfigurationScopeAwareProvider(config));
    }

    protected DeadlineManager defaultDeadlineManager(LegacyConfiguration config) {
        return this.defaultComponent(DeadlineManager.class, config).orElseGet(() -> SimpleDeadlineManager.builder().scopeAwareProvider(config.scopeAwareProvider()).spanFactory(config.getComponent(DeadlineManagerSpanFactory.class)).build());
    }

    protected EventBus defaultEventBus(LegacyConfiguration config) {
        return this.defaultComponent(EventBus.class, config).orElseGet(() -> SimpleEventBus.builder().messageMonitor(config.messageMonitor(EventBus.class, "eventBus")).spanFactory(config.getComponent(EventBusSpanFactory.class)).build());
    }

    protected EventGateway defaultEventGateway(LegacyConfiguration config) {
        return this.defaultComponent(EventGateway.class, config).orElseGet(() -> new DefaultEventGateway(config.getComponent(EventSink.class), config.getComponent(MessageTypeResolver.class)));
    }

    protected SpanFactory defaultSpanFactory(LegacyConfiguration config) {
        return this.defaultComponent(SpanFactory.class, config).orElseGet(NoOpSpanFactory::new);
    }

    protected SnapshotterSpanFactory defaultSnapshotterSpanFactory(LegacyConfiguration config) {
        return this.defaultComponent(SnapshotterSpanFactory.class, this.config).orElseGet(() -> DefaultSnapshotterSpanFactory.builder().spanFactory(config.spanFactory()).build());
    }

    protected CommandBusSpanFactory defaultCommandBusSpanFactory(LegacyConfiguration config) {
        return this.defaultComponent(CommandBusSpanFactory.class, this.config).orElseGet(() -> DefaultCommandBusSpanFactory.builder().spanFactory(config.spanFactory()).build());
    }

    protected QueryBusSpanFactory defaultQueryBusSpanFactory(LegacyConfiguration config) {
        return this.defaultComponent(QueryBusSpanFactory.class, this.config).orElseGet(() -> DefaultQueryBusSpanFactory.builder().spanFactory(config.spanFactory()).build());
    }

    protected QueryUpdateEmitterSpanFactory defaultQueryUpdateEmitterSpanFactory(LegacyConfiguration config) {
        return this.defaultComponent(QueryUpdateEmitterSpanFactory.class, this.config).orElseGet(() -> DefaultQueryUpdateEmitterSpanFactory.builder().spanFactory(config.spanFactory()).build());
    }

    protected EventBusSpanFactory defaultEventBusSpanFactory(LegacyConfiguration config) {
        return this.defaultComponent(EventBusSpanFactory.class, this.config).orElseGet(() -> DefaultEventBusSpanFactory.builder().spanFactory(config.spanFactory()).build());
    }

    protected DeadlineManagerSpanFactory defaultDeadlineManagerSpanFactory(LegacyConfiguration config) {
        return this.defaultComponent(DeadlineManagerSpanFactory.class, this.config).orElseGet(() -> DefaultDeadlineManagerSpanFactory.builder().spanFactory(config.spanFactory()).build());
    }

    protected RepositorySpanFactory defaultRepositorySpanFactory(LegacyConfiguration config) {
        return this.defaultComponent(RepositorySpanFactory.class, this.config).orElseGet(() -> DefaultRepositorySpanFactory.builder().spanFactory(config.spanFactory()).build());
    }

    protected EventProcessorSpanFactory defaultEventProcessorSpanFactory(LegacyConfiguration config) {
        return this.defaultComponent(EventProcessorSpanFactory.class, this.config).orElseGet(() -> DefaultEventProcessorSpanFactory.builder().spanFactory(config.spanFactory()).build());
    }

    protected SagaManagerSpanFactory defaultSagaManagerSpanFactory(LegacyConfiguration config) {
        return this.defaultComponent(SagaManagerSpanFactory.class, this.config).orElseGet(() -> DefaultSagaManagerSpanFactory.builder().spanFactory(config.spanFactory()).build());
    }

    protected Serializer defaultSerializer(LegacyConfiguration config) {
        return this.defaultComponent(Serializer.class, config).orElseGet(() -> XStreamSerializer.builder().revisionResolver(config.getComponent(RevisionResolver.class, AnnotationRevisionResolver::new)).build());
    }

    protected EventUpcasterChain defaultUpcasterChain(LegacyConfiguration config) {
        return new EventUpcasterChain(this.upcasters.stream().map(Component::get).collect(Collectors.toList()));
    }

    protected Snapshotter defaultSnapshotter(LegacyConfiguration config) {
        return this.defaultComponent(Snapshotter.class, config).orElseGet(() -> {
            List<AggregateConfiguration<?>> aggregateConfigurations = config.findModules(AggregateConfiguration.class).stream().map(aggregateConfiguration -> aggregateConfiguration).collect(Collectors.toList());
            if (aggregateConfigurations.isEmpty()) {
                return (aggregateType, aggregateIdentifier) -> {};
            }
            ArrayList aggregateFactories = new ArrayList();
            for (AggregateConfiguration aggregateConfiguration2 : aggregateConfigurations) {
                aggregateFactories.add(aggregateConfiguration2.aggregateFactory());
            }
            return AggregateSnapshotter.builder().eventStore(config.eventStore()).transactionManager(config.getComponent(TransactionManager.class)).aggregateFactories(aggregateFactories).repositoryProvider(config::repository).parameterResolverFactory(config.parameterResolverFactory()).spanFactory(config.getComponent(SnapshotterSpanFactory.class)).handlerDefinition(this.retrieveHandlerDefinition(config, aggregateConfigurations)).build();
        });
    }

    private HandlerDefinition retrieveHandlerDefinition(LegacyConfiguration configuration, List<AggregateConfiguration<?>> aggregateConfigurations) {
        return configuration.handlerDefinition(aggregateConfigurations.get(0).aggregateType());
    }

    @Override
    public EventProcessingConfigurer eventProcessing() {
        List eventProcessingConfigurers = this.modules.stream().filter(module -> module.isType(EventProcessingConfigurer.class)).map(module -> (EventProcessingConfigurer)((Object)module.unwrap())).collect(Collectors.toList());
        switch (eventProcessingConfigurers.size()) {
            case 0: {
                EventProcessingModule eventProcessingModule = new EventProcessingModule();
                this.registerModule(eventProcessingModule);
                return eventProcessingModule;
            }
            case 1: {
                return (EventProcessingConfigurer)eventProcessingConfigurers.get(0);
            }
        }
        throw new AxonConfigurationException("There are several EventProcessingConfigurers defined. The `eventProcessing()` method is used to retrieve a 'singleton' EventProcessingConfigurer.");
    }

    @Override
    public LegacyConfigurer registerEventUpcaster(@Nonnull Function<LegacyConfiguration, EventUpcaster> upcasterBuilder) {
        this.upcasters.add(new Component<EventUpcaster>(this.config, "upcaster", upcasterBuilder));
        return this;
    }

    @Override
    public LegacyConfigurer configureMessageMonitor(@Nonnull Function<LegacyConfiguration, BiFunction<Class<?>, String, MessageMonitor<Message<?>>>> builder) {
        this.messageMonitorFactoryBuilder.add((conf, type, name) -> (MessageMonitor)((BiFunction)builder.apply(conf)).apply(type, name));
        return this;
    }

    @Override
    public LegacyConfigurer configureMessageMonitor(@Nonnull Class<?> componentType, @Nonnull MessageMonitorFactory messageMonitorFactory) {
        this.messageMonitorFactoryBuilder.add(componentType, messageMonitorFactory);
        return this;
    }

    @Override
    public LegacyConfigurer configureMessageMonitor(@Nonnull Class<?> componentType, @Nonnull String componentName, @Nonnull MessageMonitorFactory messageMonitorFactory) {
        this.messageMonitorFactoryBuilder.add(componentType, componentName, messageMonitorFactory);
        return this;
    }

    @Override
    public LegacyConfigurer configureCorrelationDataProviders(@Nonnull Function<LegacyConfiguration, List<CorrelationDataProvider>> correlationDataProviderBuilder) {
        this.correlationProviders.update(correlationDataProviderBuilder);
        return this;
    }

    @Override
    public LegacyConfigurer registerModule(@Nonnull ModuleConfiguration module) {
        logger.debug("Registering module [{}]", (Object)module.getClass().getSimpleName());
        if (this.initialized) {
            module.initialize(this.config);
        }
        this.modules.add(module);
        return this;
    }

    @Override
    public <C> LegacyConfigurer registerComponent(@Nonnull Class<C> componentType, @Nonnull Function<LegacyConfiguration, ? extends C> componentBuilder) {
        logger.debug("Registering component [{}]", (Object)componentType.getSimpleName());
        this.components.put(componentType, new Component<C>(this.config, componentType.getSimpleName(), componentBuilder));
        return this;
    }

    @Override
    public LegacyConfigurer registerCommandHandler(@Nonnull Function<LegacyConfiguration, Object> commandHandlerBuilder) {
        this.messageHandlerRegistrars.add(new Component<MessageHandlerRegistrar>(() -> this.config, "CommandHandlerRegistrar", configuration -> new MessageHandlerRegistrar(() -> configuration, commandHandlerBuilder, (config, commandHandler) -> {
            config.commandBus().subscribe((CommandHandlingComponent)new AnnotatedCommandHandlingComponent(commandHandler, config.parameterResolverFactory(), config.handlerDefinition(commandHandler.getClass()), this.messageTypeResolver));
            return () -> true;
        })));
        return this;
    }

    @Override
    public LegacyConfigurer registerQueryHandler(@Nonnull Function<LegacyConfiguration, Object> queryHandlerBuilder) {
        this.messageHandlerRegistrars.add(new Component<MessageHandlerRegistrar>(() -> this.config, "QueryHandlerRegistrar", configuration -> new MessageHandlerRegistrar(() -> configuration, queryHandlerBuilder, (config, queryHandler) -> new AnnotationQueryHandlerAdapter(queryHandler, config.parameterResolverFactory(), config.handlerDefinition(queryHandler.getClass())).subscribe(config.queryBus()))));
        return this;
    }

    @Override
    public LegacyConfigurer registerMessageHandler(@Nonnull Function<LegacyConfiguration, Object> messageHandlerBuilder) {
        Component<Object> messageHandler = new Component<Object>(() -> this.config, "", messageHandlerBuilder);
        Class<?> handlerClass = messageHandler.get().getClass();
        if (HandlerTypeResolver.isCommandHandler(handlerClass)) {
            this.registerCommandHandler(c -> messageHandler.get());
        }
        if (HandlerTypeResolver.isEventHandler(handlerClass)) {
            this.eventProcessing().registerEventHandler(c -> messageHandler.get());
        }
        if (HandlerTypeResolver.isQueryHandler(handlerClass)) {
            this.registerQueryHandler(c -> messageHandler.get());
        }
        return this;
    }

    @Override
    public LegacyConfigurer configureEmbeddedEventStore(@Nonnull Function<LegacyConfiguration, LegacyEventStorageEngine> storageEngineBuilder) {
        return this.configureEventStore(c -> {
            MessageMonitor<Message<?>> monitor = this.messageMonitorFactoryComponent.get().apply(LegacyEmbeddedEventStore.class, "eventStore");
            LegacyEmbeddedEventStore eventStore = LegacyEmbeddedEventStore.builder().storageEngine((LegacyEventStorageEngine)storageEngineBuilder.apply((LegacyConfiguration)c)).messageMonitor(monitor).build();
            c.onShutdown(() -> ((LegacyEmbeddedEventStore)eventStore).shutDown());
            return eventStore;
        });
    }

    @Override
    public LegacyConfigurer configureEventSerializer(@Nonnull Function<LegacyConfiguration, Serializer> eventSerializerBuilder) {
        this.eventSerializer.update(eventSerializerBuilder);
        return this;
    }

    @Override
    public LegacyConfigurer configureMessageSerializer(@Nonnull Function<LegacyConfiguration, Serializer> messageSerializerBuilder) {
        this.messageSerializer.update(messageSerializerBuilder);
        return this;
    }

    @Override
    public <A> LegacyConfigurer configureAggregate(@Nonnull AggregateConfiguration<A> aggregateConfiguration) {
        return this.registerModule(aggregateConfiguration);
    }

    @Override
    public LegacyConfigurer registerHandlerDefinition(@Nonnull BiFunction<LegacyConfiguration, Class, HandlerDefinition> handlerDefinitionClass) {
        this.handlerDefinition.update(c -> clazz -> (HandlerDefinition)handlerDefinitionClass.apply((LegacyConfiguration)c, (Class)clazz));
        return this;
    }

    @Override
    public LegacyConfigurer registerHandlerEnhancerDefinition(Function<LegacyConfiguration, HandlerEnhancerDefinition> handlerEnhancerBuilder) {
        this.handlerEnhancerDefinitions.add(new Component<HandlerEnhancerDefinition>(this.config, "HandlerEnhancerDefinition", handlerEnhancerBuilder));
        return this;
    }

    @Override
    public LegacyConfigurer configureLifecyclePhaseTimeout(long timeout, TimeUnit timeUnit) {
        BuilderUtils.assertStrictPositive((long)timeout, (String)"The lifecycle phase timeout should be strictly positive");
        BuilderUtils.assertNonNull((Object)((Object)timeUnit), (String)"The lifecycle phase time unit should not be null");
        this.lifecyclePhaseTimeout = timeout;
        this.lifecyclePhaseTimeunit = timeUnit;
        return this;
    }

    @Override
    public LegacyConfiguration buildConfiguration() {
        if (!this.initialized) {
            this.verifyIdentifierFactory();
            this.prepareModules();
            this.prepareMessageHandlerRegistrars();
            this.invokeInitHandlers();
        }
        return this.config;
    }

    protected void prepareModules() {
        this.modules.forEach(module -> this.initHandlers.add(module::initialize));
    }

    private void verifyIdentifierFactory() {
        try {
            IdentifierFactory.getInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The configured IdentifierFactory could not be instantiated.", e);
        }
    }

    protected void prepareMessageHandlerRegistrars() {
        this.messageHandlerRegistrars.forEach(registrar -> this.initHandlers.add(c -> registrar.get()));
    }

    protected void invokeInitHandlers() {
        this.initialized = true;
        this.initHandlers.forEach(h -> h.accept(this.config));
    }

    protected void invokeStartHandlers() {
        logger.debug("Initiating start up");
        this.lifecycleState = LifecycleState.STARTING_UP;
        this.invokeLifecycleHandlers(this.startHandlers, e -> {
            logger.debug("Start up is being ended prematurely due to an exception");
            String startFailure = String.format("One of the start handlers in phase [%d] failed with the following exception: ", this.currentLifecyclePhase);
            logger.warn(startFailure, (Throwable)e);
            this.invokeShutdownHandlers();
            throw new LifecycleHandlerInvocationException(startFailure, (Throwable)e);
        });
        this.lifecycleState = LifecycleState.UP;
        logger.debug("Finalized start sequence");
    }

    protected void invokeShutdownHandlers() {
        logger.debug("Initiating shutdown");
        this.lifecycleState = LifecycleState.SHUTTING_DOWN;
        this.invokeLifecycleHandlers(this.shutdownHandlers, e -> logger.warn("One of the shutdown handlers in phase [{}] failed with the following exception: ", (Object)this.currentLifecyclePhase, e));
        this.lifecycleState = LifecycleState.DOWN;
        logger.debug("Finalized shutdown sequence");
    }

    private void invokeLifecycleHandlers(TreeMap<Integer, List<LifecycleHandler>> lifecycleHandlerMap, Consumer<Exception> exceptionHandler) {
        Map.Entry<Integer, List<LifecycleHandler>> phasedHandlers = lifecycleHandlerMap.firstEntry();
        if (phasedHandlers == null) {
            return;
        }
        do {
            this.currentLifecyclePhase = phasedHandlers.getKey();
            logger.debug("Entered {} handler lifecycle phase [{}]", (Object)this.lifecycleState.description, (Object)this.currentLifecyclePhase);
            List<LifecycleHandler> handlers = phasedHandlers.getValue();
            try {
                handlers.stream().map(LifecycleHandler::run).map(c -> c.thenRun(NOTHING)).reduce((xva$0, xva$1) -> CompletableFuture.allOf(xva$0, xva$1)).orElse(FutureUtils.emptyCompletedFuture()).get(this.lifecyclePhaseTimeout, this.lifecyclePhaseTimeunit);
            }
            catch (CompletionException | ExecutionException e) {
                exceptionHandler.accept(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Completion interrupted during {} phase [{}]. Proceeding to following phase", (Object)this.lifecycleState.description, (Object)this.currentLifecyclePhase);
            }
            catch (TimeoutException e) {
                long lifecyclePhaseTimeoutInSeconds = TimeUnit.SECONDS.convert(this.lifecyclePhaseTimeout, this.lifecyclePhaseTimeunit);
                logger.warn("Timed out during {} phase [{}] after {} second(s). Proceeding to following phase", new Object[]{this.lifecycleState.description, this.currentLifecyclePhase, lifecyclePhaseTimeoutInSeconds});
            }
        } while ((phasedHandlers = lifecycleHandlerMap.higherEntry(this.currentLifecyclePhase)) != null);
        this.currentLifecyclePhase = null;
    }

    protected LegacyConfiguration getConfig() {
        return this.config;
    }

    public Map<Class<?>, Component<?>> getComponents() {
        return this.components;
    }

    @Override
    public void onStart(int phase, LifecycleHandler startHandler) {
        this.onInitialize(cfg -> cfg.onStart(phase, startHandler));
    }

    @Override
    public void onShutdown(int phase, LifecycleHandler shutdownHandler) {
        this.onInitialize(cfg -> cfg.onShutdown(phase, shutdownHandler));
    }

    private class ConfigurationImpl
    implements LegacyConfiguration {
        private ConfigurationImpl() {
        }

        @Override
        public <T> T getComponent(@Nonnull Class<T> componentType, @Nonnull Supplier<T> defaultImpl) {
            Object component = LegacyDefaultConfigurer.this.components.computeIfAbsent(componentType, type -> new Component<Object>(LegacyDefaultConfigurer.this.config, componentType.getSimpleName(), arg_0 -> this.lambda$getComponent$0(componentType, (Supplier)defaultImpl, arg_0))).get();
            return componentType.cast(component);
        }

        @Override
        public <M extends Message<?>> MessageMonitor<? super M> messageMonitor(@Nonnull Class<?> componentType, @Nonnull String componentName) {
            return LegacyDefaultConfigurer.this.messageMonitorFactoryComponent.get().apply(componentType, componentName);
        }

        @Override
        public Serializer eventSerializer() {
            return LegacyDefaultConfigurer.this.eventSerializer.get();
        }

        @Override
        public Serializer messageSerializer() {
            return LegacyDefaultConfigurer.this.messageSerializer.get();
        }

        @Override
        public void start() {
            LegacyDefaultConfigurer.this.invokeStartHandlers();
        }

        @Override
        public void shutdown() {
            LegacyDefaultConfigurer.this.invokeShutdownHandlers();
        }

        @Override
        public List<CorrelationDataProvider> correlationDataProviders() {
            return LegacyDefaultConfigurer.this.correlationProviders.get();
        }

        @Override
        public List<ModuleConfiguration> getModules() {
            return LegacyDefaultConfigurer.this.modules;
        }

        @Override
        public void onStart(int phase, LifecycleHandler startHandler) {
            if (this.isEarlierPhaseDuringStartUp(phase)) {
                logger.info("A start handler is being registered for phase [{}] whilst phase [{}] is in progress. Will run provided handler immediately instead.", (Object)phase, (Object)LegacyDefaultConfigurer.this.currentLifecyclePhase);
                startHandler.run().join();
            }
            this.registerLifecycleHandler(LegacyDefaultConfigurer.this.startHandlers, phase, startHandler);
        }

        private boolean isEarlierPhaseDuringStartUp(int phase) {
            return LegacyDefaultConfigurer.this.lifecycleState == LifecycleState.STARTING_UP && LegacyDefaultConfigurer.this.currentLifecyclePhase != null && phase <= LegacyDefaultConfigurer.this.currentLifecyclePhase;
        }

        @Override
        public void onShutdown(int phase, LifecycleHandler shutdownHandler) {
            if (this.isEarlierPhaseDuringShutdown(phase)) {
                logger.info("A shutdown handler is being registered for phase [{}] whilst phase [{}] is in progress. Will run provided handler immediately instead.", (Object)phase, (Object)LegacyDefaultConfigurer.this.currentLifecyclePhase);
                shutdownHandler.run().join();
            }
            this.registerLifecycleHandler(LegacyDefaultConfigurer.this.shutdownHandlers, phase, shutdownHandler);
        }

        private boolean isEarlierPhaseDuringShutdown(int phase) {
            return LegacyDefaultConfigurer.this.lifecycleState == LifecycleState.SHUTTING_DOWN && LegacyDefaultConfigurer.this.currentLifecyclePhase != null && phase >= LegacyDefaultConfigurer.this.currentLifecyclePhase;
        }

        private void registerLifecycleHandler(Map<Integer, List<LifecycleHandler>> lifecycleHandlers, int phase, LifecycleHandler lifecycleHandler) {
            lifecycleHandlers.compute(phase, (p, handlers) -> {
                if (handlers == null) {
                    handlers = new CopyOnWriteArrayList<LifecycleHandler>();
                }
                handlers.add(lifecycleHandler);
                return handlers;
            });
        }

        @Override
        public EventUpcasterChain upcasterChain() {
            return LegacyDefaultConfigurer.this.upcasterChain.get();
        }

        @Override
        public HandlerDefinition handlerDefinition(Class<?> inspectedType) {
            return LegacyDefaultConfigurer.this.handlerDefinition.get().apply(inspectedType);
        }

        private /* synthetic */ Object lambda$getComponent$0(Class componentType, Supplier defaultImpl, LegacyConfiguration c) {
            return LegacyDefaultConfigurer.this.defaultComponent(componentType, c).orElseGet(defaultImpl);
        }
    }

    private static enum LifecycleState {
        DOWN("down"),
        STARTING_UP("start"),
        UP("up"),
        SHUTTING_DOWN("shutdown");

        private final String description;

        private LifecycleState(String description) {
            this.description = description;
        }
    }
}

