/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.SagaConfiguration;
import org.axonframework.eventhandling.ErrorHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.deadletter.EnqueuePolicy;
import org.axonframework.messaging.deadletter.SequencedDeadLetterProcessor;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.monitoring.MessageMonitor;

public interface EventProcessingConfiguration {
    default public <T extends EventProcessor> Optional<T> eventProcessor(String name) {
        return Optional.ofNullable(this.eventProcessors().get(name));
    }

    default public <T extends EventProcessor> Optional<T> sagaEventProcessor(Class<?> sagaType) {
        return this.eventProcessorByProcessingGroup(this.sagaProcessingGroup(sagaType));
    }

    default public <T extends EventProcessor> Optional<T> eventProcessor(String name, Class<T> expectedType) {
        return this.eventProcessor(name).filter(expectedType::isInstance).map(expectedType::cast);
    }

    public <T extends EventProcessor> Optional<T> eventProcessorByProcessingGroup(String var1);

    default public <T extends EventProcessor> Optional<T> eventProcessorByProcessingGroup(String processingGroup, Class<T> expectedType) {
        return this.eventProcessorByProcessingGroup(processingGroup).filter(expectedType::isInstance).map(expectedType::cast);
    }

    public Map<String, EventProcessor> eventProcessors();

    public String sagaProcessingGroup(Class<?> var1);

    public List<MessageHandlerInterceptor<? super EventMessage<?>>> interceptorsFor(String var1);

    public ListenerInvocationErrorHandler listenerInvocationErrorHandler(String var1);

    public SequencingPolicy<? super EventMessage<?>> sequencingPolicy(String var1);

    public ErrorHandler errorHandler(String var1);

    public SagaStore sagaStore();

    public List<SagaConfiguration<?>> sagaConfigurations();

    default public <T> SagaConfiguration<T> sagaConfiguration(Class<T> sagaType) {
        return this.sagaConfigurations().stream().filter(c -> sagaType.equals(c.type())).findFirst().orElse(null);
    }

    public MessageMonitor<? super Message<?>> messageMonitor(Class<?> var1, String var2);

    public TokenStore tokenStore(String var1);

    public TransactionManager transactionManager(String var1);

    default public Optional<SequencedDeadLetterQueue<EventMessage<?>>> deadLetterQueue(@Nonnull String processingGroup) {
        return Optional.empty();
    }

    default public Optional<EnqueuePolicy<EventMessage<?>>> deadLetterPolicy(@Nonnull String processingGroup) {
        return Optional.empty();
    }

    default public Optional<SequencedDeadLetterProcessor<EventMessage<?>>> sequencedDeadLetterProcessor(@Nonnull String processingGroup) {
        return Optional.empty();
    }
}

