/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.common.Assert;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.config.LegacyConfiguration;
import org.axonframework.config.SagaConfiguration;
import org.axonframework.messaging.ScopeAware;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.modelling.command.LegacyRepository;
import org.axonframework.modelling.saga.AbstractSagaManager;

public class ConfigurationScopeAwareProvider
implements ScopeAwareProvider {
    private final LegacyConfiguration configuration;
    private List<ScopeAware> scopeAwareComponents;

    public ConfigurationScopeAwareProvider(LegacyConfiguration configuration) {
        this.configuration = (LegacyConfiguration)Assert.nonNull((Object)configuration, () -> "configuration may not be null");
    }

    public Stream<ScopeAware> provideScopeAwareStream(ScopeDescriptor scopeDescriptor) {
        if (this.scopeAwareComponents == null) {
            this.scopeAwareComponents = this.retrieveScopeAwareComponents();
        }
        return this.scopeAwareComponents.stream();
    }

    private List<ScopeAware> retrieveScopeAwareComponents() {
        ArrayList<ScopeAware> components = new ArrayList<ScopeAware>();
        components.addAll(this.retrieveAggregateRepositories());
        components.addAll(this.retrieveSagaManagers());
        return components;
    }

    private List<LegacyRepository> retrieveAggregateRepositories() {
        return this.configuration.findModules(AggregateConfiguration.class).stream().map(AggregateConfiguration::repository).collect(Collectors.toList());
    }

    private List<AbstractSagaManager> retrieveSagaManagers() {
        EventProcessingConfiguration eventProcessingConfiguration = this.configuration.eventProcessingConfiguration();
        if (eventProcessingConfiguration == null) {
            return Collections.emptyList();
        }
        return eventProcessingConfiguration.sagaConfigurations().stream().map(SagaConfiguration::manager).collect(Collectors.toList());
    }
}

