/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.util;

import java.util.Objects;
import org.axonframework.common.util.PriorityTask;

public class PriorityRunnable
implements Runnable,
PriorityTask {
    private final Runnable task;
    private final long priority;
    private final long sequence;

    public PriorityRunnable(Runnable task, long priority, long sequence) {
        this.task = task;
        this.priority = priority;
        this.sequence = sequence;
    }

    @Override
    public void run() {
        this.task.run();
    }

    @Override
    public long priority() {
        return this.priority;
    }

    @Override
    public long sequence() {
        return this.sequence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriorityRunnable that = (PriorityRunnable)o;
        return this.priority == that.priority && this.sequence == that.sequence && Objects.equals(this.task, that.task);
    }

    public int hashCode() {
        return Objects.hash(this.task, this.priority, this.sequence);
    }

    public String toString() {
        return "PriorityRunnable{task=" + String.valueOf(this.task) + ", priority=" + this.priority + ", sequence=" + this.sequence + "}";
    }
}

