/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class Oracle11Utils {
    private Oracle11Utils() {
    }

    public static void simulateAutoIncrement(Connection connection, String tableName, String columnName) throws SQLException {
        String sequenceName = tableName + "_seq";
        String triggerName = tableName + "_id";
        try (PreparedStatement pst = connection.prepareStatement("CREATE sequence " + sequenceName + " start with 1 increment by 1 nocycle");){
            pst.executeUpdate();
        }
        try (Statement st = connection.createStatement();){
            st.execute("create or replace trigger " + triggerName + "        before insert on " + tableName + "        for each row         begin                 :new." + columnName + " := " + sequenceName + ".nextval;         end;");
        }
    }

    public static PreparedStatement createNullStatement(Connection connection) throws SQLException {
        return connection.prepareStatement("select 1 from dual");
    }
}

