/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.netty.ws.NettyWebSocket;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.FunctionResolver;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.transport.TransportNotSupported;
import org.atmosphere.wasync.transport.TransportsUtil;
import org.atmosphere.wasync.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransport
extends WebSocketUpgradeHandler
implements Transport {
    private final Logger logger = LoggerFactory.getLogger(WebSocketTransport.class);
    private NettyWebSocket webSocket;
    private final AtomicBoolean ok = new AtomicBoolean(false);
    private final AtomicInteger reconnectAttempt = new AtomicInteger();
    private final AtomicBoolean reconnecting = new AtomicBoolean(false);
    private final List<FunctionWrapper> functions;
    private final List<Decoder<?, ?>> decoders;
    private final FunctionResolver resolver;
    private final Options options;
    private final RequestBuilder requestBuilder;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private Socket.STATUS status = Socket.STATUS.INIT;
    private final AtomicBoolean errorHandled = new AtomicBoolean();
    private Future underlyingFuture;
    private Future connectOperationFuture;
    protected final boolean protocolEnabled;
    protected boolean supportBinary = false;
    protected final ScheduledExecutorService timer;
    protected boolean protocolReceived = false;

    public WebSocketTransport(RequestBuilder requestBuilder, Options options, Request request, List<FunctionWrapper> functions) {
        super(Collections.emptyList());
        this.decoders = request.decoders();
        if (this.decoders.size() == 0) {
            this.decoders.add(new Decoder<String, Object>(){

                @Override
                public Object decode(Event e, String s) {
                    return s;
                }
            });
        }
        this.functions = functions;
        this.resolver = request.functionResolver();
        this.options = options;
        this.requestBuilder = requestBuilder;
        this.supportBinary = options.binary() || request.headers().get("Content-Type") != null && request.headers().get("Content-Type").contains("application/octet-stream");
        this.protocolEnabled = request.queryString().get("X-atmo-protocol") != null;
        this.timer = Executors.newSingleThreadScheduledExecutor();
    }

    public void onThrowable0(Throwable t) {
        this.logger.debug("", t);
        this.status = Socket.STATUS.ERROR;
        this.onFailure(t);
    }

    @Override
    public void close() {
        this.status = Socket.STATUS.CLOSE;
        if (this.closed.getAndSet(true)) {
            return;
        }
        if (this.options.reconnectTimeoutInMilliseconds() <= 0 && !this.options.reconnect()) {
            this.timer.shutdown();
        }
        TransportsUtil.invokeFunction(Event.CLOSE, this.decoders, this.functions, String.class, Event.CLOSE.name(), Event.CLOSE.name(), this.resolver);
        if (this.webSocket != null && this.webSocket.isOpen()) {
            this.webSocket.sendCloseFrame();
        }
        this.futureDone();
    }

    @Override
    public Socket.STATUS status() {
        return this.status;
    }

    void futureDone() {
        if (this.underlyingFuture != null) {
            this.underlyingFuture.done();
        }
    }

    @Override
    public boolean errorHandled() {
        return this.errorHandled.get();
    }

    @Override
    public void error(Throwable t) {
        this.logger.warn("", t);
        boolean handled = TransportsUtil.invokeFunction(Event.ERROR, this.decoders, this.functions, t.getClass(), t, Event.ERROR.name(), this.resolver);
        if (!handled) {
            this.connectFutureException(t);
        }
        this.connectOperationFuture.done();
    }

    @Override
    public void future(Future f) {
        this.underlyingFuture = f;
    }

    @Override
    public void connectedFuture(Future f) {
        this.connectOperationFuture = f;
    }

    protected void onBodyPartReceived0(HttpResponseBodyPart bodyPart) throws Exception {
        this.logger.trace("Body received {}", (Object)new String(bodyPart.getBodyPartBytes()));
    }

    protected void onStatusReceived0(HttpResponseStatus responseStatus) throws Exception {
        this.logger.trace("Status received {}", (Object)responseStatus);
        TransportsUtil.invokeFunction(Event.STATUS, this.decoders, this.functions, Integer.class, new Integer(responseStatus.getStatusCode()), Event.STATUS.name(), this.resolver);
        if (responseStatus.getStatusCode() != 101) {
            this.logger.debug("Invalid status code {} for WebSocket Handshake", (Object)responseStatus.getStatusCode());
            this.status = Socket.STATUS.ERROR;
            throw new TransportNotSupported(responseStatus.getStatusCode(), responseStatus.getStatusText());
        }
    }

    protected void onHeadersReceived0(HttpHeaders headers) throws Exception {
        this.logger.trace("Headers received {}", (Object)headers);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (Map.Entry entry : headers) {
            headerMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        TransportsUtil.invokeFunction(Event.HEADERS, this.decoders, this.functions, Map.class, headerMap, Event.HEADERS.name(), this.resolver);
    }

    protected void onCompleted0() throws Exception {
        this.logger.trace("onCompleted {}", (Object)this.webSocket);
        if (this.webSocket == null) {
            this.logger.error("WebSocket Handshake Failed");
            this.status = Socket.STATUS.ERROR;
            return;
        }
        TransportsUtil.invokeFunction(Event.TRANSPORT, this.decoders, this.functions, Request.TRANSPORT.class, (Object)this.name(), Event.TRANSPORT.name(), this.resolver);
    }

    void unlockFuture() {
        try {
            this.connectOperationFuture.finishOrThrowException();
        }
        catch (IOException e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    protected void onOpen0() {
        this.logger.trace("onOpen {}", (Object)this.webSocket);
        if (this.connectOperationFuture != null && !this.protocolEnabled) {
            this.unlockFuture();
        }
        Object l = new TextListener();
        if (this.supportBinary) {
            l = new BinaryListener((WebSocketListener)l);
        }
        this.webSocket.addWebSocketListener((WebSocketListener)l);
        l.onOpen((WebSocket)this.webSocket);
    }

    protected void setWebSocket0(NettyWebSocket webSocket) {
        this.webSocket = webSocket;
    }

    void connectFutureException(Throwable t) {
        IOException e = IOException.class.isAssignableFrom(t.getClass()) ? (IOException)t : new IOException(t);
        this.connectOperationFuture.ioException(e);
    }

    void tryReconnect() {
        this.reconnectAttempt.incrementAndGet();
        if (this.options.reconnectTimeoutInMilliseconds() > 0) {
            this.timer.schedule(new Runnable(){

                @Override
                public void run() {
                    WebSocketTransport.this.reconnect();
                }
            }, (long)this.options.reconnectTimeoutInMilliseconds(), TimeUnit.MILLISECONDS);
        } else {
            this.reconnect();
        }
    }

    void reconnect() {
        try {
            this.reconnecting.set(true);
            this.ok.set(false);
            this.status = Socket.STATUS.REOPENED;
            ListenableFuture webSocketListenableFuture = this.options.runtime().executeRequest(this.requestBuilder.build(), (AsyncHandler)this);
            this.logger.info("try reconnect : attempt [{}/{}]", (Object)this.reconnectAttempt.get(), (Object)this.options.reconnectAttempts());
            webSocketListenableFuture.get();
            this.logger.info("reconnect successful ! in attempt [{}/{}]", (Object)this.reconnectAttempt.get(), (Object)this.options.reconnectAttempts());
            TransportsUtil.invokeFunction(Event.REOPENED, this.decoders, this.functions, String.class, Event.REOPENED.name(), Event.REOPENED.name(), this.resolver);
            this.closed.set(false);
            this.reconnectAttempt.set(0);
            this.reconnecting.set(false);
        }
        catch (InterruptedException e) {
            this.reconnecting.set(false);
            this.logger.error("", (Throwable)e);
        }
        catch (ExecutionException e) {
            if (this.reconnectAttempt.get() < this.options.reconnectAttempts()) {
                this.tryReconnect();
            }
            this.reconnecting.set(false);
            this.reconnectAttempt.set(0);
            this.onFailure(e.getCause() != null ? e.getCause() : e);
        }
    }

    public boolean touchSuccess() {
        return this.ok.getAndSet(true);
    }

    @Override
    public Request.TRANSPORT name() {
        return Request.TRANSPORT.WEBSOCKET;
    }

    @Override
    public Transport registerF(FunctionWrapper function) {
        this.functions.add(function);
        return this;
    }

    public final void onFailure(Throwable t) {
        if (!this.reconnecting.get()) {
            this.logger.trace("onFailure {}", t);
            boolean handled = TransportsUtil.invokeFunction(Event.ERROR, this.decoders, this.functions, t.getClass(), t, Event.ERROR.name(), this.resolver);
            if (!handled) {
                this.connectFutureException(t);
            }
            this.errorHandled.set(handled);
            this.connectOperationFuture.done();
        }
    }

    public WebSocketTransport sendMessage(String message) {
        if (this.webSocket != null && !this.status.equals((Object)Socket.STATUS.ERROR) && !this.status.equals((Object)Socket.STATUS.CLOSE)) {
            this.webSocket.sendTextFrame(message);
        }
        return this;
    }

    public WebSocketTransport sendMessage(byte[] message) {
        if (this.webSocket != null && !this.status.equals((Object)Socket.STATUS.ERROR) && !this.status.equals((Object)Socket.STATUS.CLOSE)) {
            this.webSocket.sendBinaryFrame(message);
        }
        return this;
    }

    private final class TextListener
    implements WebSocketListener {
        private TextListener() {
        }

        public void onTextFrame(String message, boolean finalFragment, int rsv) {
            WebSocketTransport.this.logger.trace("onMessage {} for {}", (Object)message, (Object)WebSocketTransport.this.webSocket);
            WebSocketTransport.this.logger.trace("{} received {}", (Object)WebSocketTransport.this.name(), (Object)message);
            if (WebSocketTransport.this.protocolReceived || message.length() > 0) {
                TransportsUtil.invokeFunction(Event.MESSAGE, WebSocketTransport.this.decoders, WebSocketTransport.this.functions, message.getClass(), message, Event.MESSAGE.name(), WebSocketTransport.this.resolver);
                if (WebSocketTransport.this.connectOperationFuture != null && WebSocketTransport.this.protocolEnabled) {
                    WebSocketTransport.this.unlockFuture();
                }
            }
            WebSocketTransport.this.protocolReceived = true;
        }

        public void onOpen(WebSocket websocket) {
            WebSocketTransport.this.logger.trace("onOpen for {}", (Object)WebSocketTransport.this.webSocket);
            if (WebSocketTransport.this.status.equals((Object)Socket.STATUS.CLOSE) || WebSocketTransport.this.status.equals((Object)Socket.STATUS.ERROR)) {
                return;
            }
            WebSocketTransport.this.closed.set(false);
            Event newStatus = WebSocketTransport.this.status.equals((Object)Socket.STATUS.INIT) ? Event.OPEN : Event.REOPENED;
            WebSocketTransport.this.status = Socket.STATUS.OPEN;
            TransportsUtil.invokeFunction(newStatus, WebSocketTransport.this.decoders, WebSocketTransport.this.functions, String.class, newStatus.name(), newStatus.name(), WebSocketTransport.this.resolver);
        }

        public void onClose(WebSocket websocket, int code, String reason) {
            WebSocketTransport.this.logger.trace("onClose for {}", (Object)WebSocketTransport.this.webSocket);
            if (WebSocketTransport.this.closed.get()) {
                return;
            }
            WebSocketTransport.this.close();
            if (WebSocketTransport.this.options.reconnect()) {
                WebSocketTransport.this.tryReconnect();
            }
        }

        public void onError(Throwable t) {
            WebSocketTransport.this.logger.trace("onError for {}", t);
            WebSocketTransport.this.status = Socket.STATUS.ERROR;
            WebSocketTransport.this.logger.debug("", t);
            if (t.getClass().getName().equals("android.system.ErrnoException")) {
                if (WebSocketTransport.this.options.reconnect()) {
                    WebSocketTransport.this.close();
                    WebSocketTransport.this.tryReconnect();
                } else {
                    WebSocketTransport.this.onFailure(new IOException(t.getMessage(), t));
                }
            } else {
                WebSocketTransport.this.onFailure(t);
            }
        }
    }

    private final class BinaryListener
    implements WebSocketListener {
        private final WebSocketListener l;

        private BinaryListener(WebSocketListener l) {
            this.l = l;
        }

        public void onBinaryFrame(byte[] message, boolean finalFragment, int rsv) {
            WebSocketTransport.this.logger.trace("{} received {}", (Object)WebSocketTransport.this.name(), (Object)message);
            if (WebSocketTransport.this.protocolReceived || message.length > 0 && !Utils.whiteSpace(message)) {
                TransportsUtil.invokeFunction(Event.MESSAGE, WebSocketTransport.this.decoders, WebSocketTransport.this.functions, message.getClass(), message, Event.MESSAGE.name(), WebSocketTransport.this.resolver);
                if (WebSocketTransport.this.connectOperationFuture != null && WebSocketTransport.this.protocolEnabled) {
                    WebSocketTransport.this.unlockFuture();
                }
            }
            WebSocketTransport.this.protocolReceived = true;
        }

        public void onOpen(WebSocket websocket) {
            this.l.onOpen(websocket);
        }

        public void onClose(WebSocket websocket, int code, String reason) {
            this.l.onClose(websocket, code, reason);
        }

        public void onError(Throwable t) {
            this.l.onError(t);
        }
    }
}

