/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.RequestBuilder;
import java.util.List;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.transport.StreamTransport;
import org.atmosphere.wasync.transport.TransportNotSupported;
import org.atmosphere.wasync.transport.TransportsUtil;

public class SSETransport
extends StreamTransport {
    public SSETransport(RequestBuilder requestBuilder, Options options, Request request, List<FunctionWrapper> functions) {
        super(requestBuilder, options, request, functions);
    }

    @Override
    public Request.TRANSPORT name() {
        return Request.TRANSPORT.SSE;
    }

    @Override
    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        List ct = headers.getHeaders().get((Object)"Content-Type");
        if (ct == null || ct.size() == 0 || !((String)ct.get(0)).contains("text/event-stream")) {
            this.status = Socket.STATUS.ERROR;
            throw new TransportNotSupported(500, "Invalid Content-Type" + ct);
        }
        return super.onHeadersReceived(headers);
    }

    @Override
    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        String m = new String(bodyPart.getBodyPartBytes(), this.charSet).trim();
        if (m.length() > 0) {
            String[] data;
            for (String d : data = m.split("data:")) {
                if (d.length() <= 0) continue;
                TransportsUtil.invokeFunction(this.decoders, this.functions, d.getClass(), d, Event.MESSAGE.name(), this.resolver);
            }
        }
        if (this.connectOperationFuture != null) {
            this.connectOperationFuture.finishOrThrowException();
        }
        return AsyncHandler.STATE.CONTINUE;
    }
}

