/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.util;

import com.ning.http.client.AsyncHttpClient;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.atmosphere.wasync.Client;
import org.atmosphere.wasync.ClientFactory;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.OptionsBuilder;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.RequestBuilder;
import org.atmosphere.wasync.Socket;

public class WebSocketLoader {
    public static void main(String[] s) throws InterruptedException, IOException {
        int i;
        if (s.length == 0) {
            s = new String[]{"500", "1000", "http://127.0.0.1:8080/chat"};
        }
        int clientNum = Integer.valueOf(s[0]);
        final int messageNum = Integer.valueOf(s[1]);
        String url = s[2];
        System.out.println("Number of Client: " + clientNum);
        System.out.println("Number of Message: " + messageNum);
        AsyncHttpClient c = new AsyncHttpClient();
        final CountDownLatch l = new CountDownLatch(clientNum);
        final CountDownLatch messages = new CountDownLatch(messageNum * clientNum);
        Client<? extends Options, ? extends OptionsBuilder, ? extends RequestBuilder> client = ClientFactory.getDefault().newClient();
        RequestBuilder request = client.newRequestBuilder();
        ((RequestBuilder)request.method(Request.METHOD.GET)).uri(url);
        request.transport(Request.TRANSPORT.WEBSOCKET);
        long clientCount = l.getCount();
        final AtomicLong total = new AtomicLong(0L);
        Socket[] sockets = new Socket[clientNum];
        int i2 = 0;
        while ((long)i2 < clientCount) {
            final AtomicLong start = new AtomicLong(0L);
            sockets[i2] = client.create((Options)((OptionsBuilder)client.newOptionsBuilder().runtime(c)).build()).on(new Function<Integer>(){

                @Override
                public void on(Integer statusCode) {
                    start.set(System.currentTimeMillis());
                    l.countDown();
                }
            }).on(new Function<String>(){
                int mCount = 0;

                @Override
                public void on(String s) {
                    if (s.startsWith("message")) {
                        String[] m = s.split("\n\r");
                        this.mCount += m.length;
                        messages.countDown();
                        if (this.mCount == messageNum) {
                            total.addAndGet(System.currentTimeMillis() - start.get());
                        }
                    }
                }
            }).on(new Function<Throwable>(){

                @Override
                public void on(Throwable t) {
                    t.printStackTrace();
                }
            });
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < clientCount) {
            sockets[i2].open(request.build());
            ++i2;
        }
        l.await(60L, TimeUnit.SECONDS);
        System.out.println("OK, all Connected: " + clientNum);
        Socket socket = client.create((Options)((OptionsBuilder)client.newOptionsBuilder().runtime(c)).build());
        socket.open(request.build());
        for (i = 0; i < messageNum; ++i) {
            socket.fire("message" + i);
        }
        messages.await(5L, TimeUnit.MINUTES);
        socket.close();
        i = 0;
        while ((long)i < clientCount) {
            sockets[i].close();
            ++i;
        }
        c.close();
        System.out.println("Total: " + total.get() / clientCount);
    }
}

