/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.FunctionResolver;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.ReplayDecoder;
import org.atmosphere.wasync.util.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportsUtil {
    private static final Logger logger = LoggerFactory.getLogger(TransportsUtil.class);

    public static boolean invokeFunction(List<Decoder<? extends Object, ?>> decoders, List<FunctionWrapper> functions, Class<?> implementedType, Object instanceType, String functionName, FunctionResolver resolver) {
        return TransportsUtil.invokeFunction(Event.MESSAGE, decoders, functions, implementedType, instanceType, functionName, resolver);
    }

    public static boolean invokeFunction(Event e, List<Decoder<? extends Object, ?>> decoders, List<FunctionWrapper> functions, Class<?> implementedType, Object instanceType, String functionName, FunctionResolver resolver) {
        boolean hasMatch = false;
        String originalMessage = instanceType == null ? "" : instanceType.toString();
        for (FunctionWrapper wrapper : functions) {
            Function<?> f = wrapper.function();
            Class<?>[] typeArguments = TypeResolver.resolveArguments(f.getClass(), Function.class);
            if (typeArguments.length > 0 && instanceType != null && (instanceType = TransportsUtil.matchDecoder(e, instanceType, decoders)) != null) {
                implementedType = instanceType.getClass();
            }
            if (instanceType == null || typeArguments.length <= 0 || !typeArguments[0].isAssignableFrom(implementedType) || !resolver.resolve(originalMessage, functionName, wrapper)) continue;
            hasMatch = true;
            logger.debug("{} .on {}", (Object)functionName, instanceType);
            f.on(instanceType);
        }
        if (!hasMatch) {
            LoggerFactory.getLogger(TransportsUtil.class).trace("No Function {} matching {}", (Object)functionName, instanceType);
        }
        return hasMatch;
    }

    public static Object matchDecoder(Event e, Object instanceType, List<Decoder<? extends Object, ?>> decoders) {
        for (Decoder<Object, ?> d : decoders) {
            Class<?>[] typeArguments = TypeResolver.resolveArguments(d.getClass(), Decoder.class);
            if (instanceType == null || typeArguments.length <= 0 || !typeArguments[0].equals(instanceType.getClass())) continue;
            boolean replay = ReplayDecoder.class.isAssignableFrom(d.getClass());
            logger.trace("{} is trying to decode {}", d, instanceType);
            instanceType = d.decode(e, instanceType);
            if (!replay) continue;
            List l = (List)List.class.cast(instanceType);
            ArrayList nd = new ArrayList();
            boolean add = false;
            for (Decoder<Object, ?> d2 : decoders) {
                if (d2.equals(d)) {
                    add = true;
                    continue;
                }
                if (!add) continue;
                nd.add(d2);
            }
            Iterator<Decoder<Object, Object>> i$ = l.iterator();
            if (!i$.hasNext()) continue;
            Decoder<Object, Object> m = i$.next();
            return TransportsUtil.matchDecoder(e, m, nd);
        }
        return instanceType;
    }
}

