/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.websocket.WebSocket;
import com.ning.http.client.websocket.WebSocketListener;
import com.ning.http.client.websocket.WebSocketTextListener;
import com.ning.http.client.websocket.WebSocketUpgradeHandler;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.FunctionResolver;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.transport.TransportsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransport
extends WebSocketUpgradeHandler
implements Transport {
    private final Logger logger = LoggerFactory.getLogger(WebSocketTransport.class);
    private WebSocket webSocket;
    private final AtomicBoolean ok = new AtomicBoolean(false);
    private Future f;
    private final List<FunctionWrapper> functions;
    private final List<Decoder<?, ?>> decoders;
    private final FunctionResolver resolver;
    private final Options options;
    private final RequestBuilder requestBuilder;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private Socket.STATUS status = Socket.STATUS.INIT;
    private final AtomicBoolean errorHandled = new AtomicBoolean();

    public WebSocketTransport(RequestBuilder requestBuilder, Options options, Request request, List<FunctionWrapper> functions) {
        super(new WebSocketUpgradeHandler.Builder());
        this.decoders = request.decoders();
        if (this.decoders.size() == 0) {
            this.decoders.add(new Decoder<String, Object>(){

                @Override
                public Object decode(Event e, String s) {
                    return s;
                }
            });
        }
        this.functions = functions;
        this.resolver = request.functionResolver();
        this.options = options;
        this.requestBuilder = requestBuilder;
    }

    @Override
    public void onThrowable(Throwable t) {
        this.status = Socket.STATUS.ERROR;
        this.errorHandled.set(TransportsUtil.invokeFunction(this.decoders, this.functions, t.getClass(), t, Event.ERROR.name(), this.resolver));
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.status = Socket.STATUS.CLOSE;
        TransportsUtil.invokeFunction(Event.CLOSE, this.decoders, this.functions, String.class, Event.CLOSE.name(), Event.CLOSE.name(), this.resolver);
        if (this.webSocket != null) {
            this.webSocket.close();
        }
    }

    @Override
    public Socket.STATUS status() {
        return this.status;
    }

    @Override
    public boolean errorHandled() {
        return this.errorHandled.get();
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        TransportsUtil.invokeFunction(this.decoders, this.functions, Integer.class, new Integer(responseStatus.getStatusCode()), Event.STATUS.name(), this.resolver);
        if (responseStatus.getStatusCode() == 101) {
            return AsyncHandler.STATE.UPGRADE;
        }
        return AsyncHandler.STATE.ABORT;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        TransportsUtil.invokeFunction(this.decoders, this.functions, Map.class, headers.getHeaders(), Event.HEADERS.name(), this.resolver);
        return AsyncHandler.STATE.CONTINUE;
    }

    public WebSocket onCompleted() throws Exception {
        if (this.webSocket == null) {
            this.status = Socket.STATUS.ERROR;
            throw new IllegalStateException("WebSocket is null");
        }
        TransportsUtil.invokeFunction(this.decoders, this.functions, Request.TRANSPORT.class, (Object)this.name(), Event.TRANSPORT.name(), this.resolver);
        return this.webSocket;
    }

    public void onSuccess(WebSocket webSocket) {
        this.webSocket = webSocket;
        this.ok.set(true);
        WebSocketTextListener l = new WebSocketTextListener(){

            public void onMessage(String message) {
                if ((message = message.trim()).length() > 0) {
                    TransportsUtil.invokeFunction(Event.MESSAGE, WebSocketTransport.this.decoders, WebSocketTransport.this.functions, message.getClass(), message, Event.MESSAGE.name(), WebSocketTransport.this.resolver);
                }
            }

            public void onFragment(String fragment, boolean last) {
            }

            public void onOpen(WebSocket websocket) {
                if (WebSocketTransport.this.status.equals((Object)Socket.STATUS.CLOSE)) {
                    return;
                }
                boolean reconnect = false;
                if (!WebSocketTransport.this.status.equals((Object)Socket.STATUS.INIT)) {
                    reconnect = true;
                }
                WebSocketTransport.this.status = Socket.STATUS.OPEN;
                TransportsUtil.invokeFunction(reconnect ? Event.RECONNECT : Event.OPEN, WebSocketTransport.this.decoders, WebSocketTransport.this.functions, String.class, Event.OPEN.name(), Event.OPEN.name(), WebSocketTransport.this.resolver);
            }

            public void onClose(WebSocket websocket) {
                if (WebSocketTransport.this.closed.get()) {
                    return;
                }
                WebSocketTransport.this.status = Socket.STATUS.INIT;
                TransportsUtil.invokeFunction(Event.CLOSE, WebSocketTransport.this.decoders, WebSocketTransport.this.functions, String.class, Event.CLOSE.name(), Event.CLOSE.name(), WebSocketTransport.this.resolver);
                if (WebSocketTransport.this.options.reconnect()) {
                    if (WebSocketTransport.this.options.reconnectInSeconds() > 0) {
                        ScheduledExecutorService e = WebSocketTransport.this.options.runtime().getConfig().reaper();
                        e.schedule(new Runnable(){

                            @Override
                            public void run() {
                                WebSocketTransport.this.reconnect();
                            }
                        }, (long)WebSocketTransport.this.options.reconnectInSeconds(), TimeUnit.SECONDS);
                    } else {
                        WebSocketTransport.this.reconnect();
                    }
                } else {
                    WebSocketTransport.this.status = Socket.STATUS.CLOSE;
                }
            }

            public void onError(Throwable t) {
                WebSocketTransport.this.status = Socket.STATUS.ERROR;
                WebSocketTransport.this.errorHandled.set(TransportsUtil.invokeFunction(WebSocketTransport.this.decoders, WebSocketTransport.this.functions, t.getClass(), t, Event.ERROR.name(), WebSocketTransport.this.resolver));
            }
        };
        webSocket.addWebSocketListener((WebSocketListener)l);
        l.onOpen(webSocket);
    }

    void reconnect() {
        try {
            this.options.runtime().executeRequest(this.requestBuilder.build(), (AsyncHandler)this);
        }
        catch (IOException e) {
            this.logger.error("", (Throwable)e);
        }
    }

    @Override
    public Request.TRANSPORT name() {
        return Request.TRANSPORT.WEBSOCKET;
    }

    @Override
    public Transport future(Future f) {
        this.f = f;
        return this;
    }

    @Override
    public Transport registerF(FunctionWrapper function) {
        this.functions.add(function);
        return this;
    }

    public final void onFailure(Throwable t) {
        this.errorHandled.set(TransportsUtil.invokeFunction(this.decoders, this.functions, t.getClass(), t, Event.ERROR.name(), this.resolver));
    }
}

