/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.RequestBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.FunctionResolver;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.transport.TransportsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamTransport
implements AsyncHandler<String>,
Transport {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private final Logger logger = LoggerFactory.getLogger(StreamTransport.class);
    protected Future f;
    protected final List<FunctionWrapper> functions;
    private final List<Decoder<? extends Object, ?>> decoders;
    protected String charSet = "UTF-8";
    private final FunctionResolver resolver;
    private final Options options;
    private final RequestBuilder requestBuilder;
    private final Request request;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final boolean isBinary;
    private Socket.STATUS status = Socket.STATUS.INIT;
    private final AtomicBoolean errorHandled = new AtomicBoolean();

    public StreamTransport(RequestBuilder requestBuilder, Options options, Request request, List<FunctionWrapper> functions) {
        this.decoders = request.decoders();
        if (this.decoders.size() == 0) {
            this.decoders.add(new Decoder<String, Object>(){

                @Override
                public Object decode(Event e, String s) {
                    return s;
                }
            });
        }
        this.functions = functions;
        this.resolver = request.functionResolver();
        this.options = options;
        this.requestBuilder = requestBuilder;
        this.request = request;
        this.isBinary = request.headers().get("Content-Type") != null ? request.headers().get("Content-Type").contains("application/octet-stream") : false;
    }

    @Override
    public Transport future(Future f) {
        this.f = f;
        return this;
    }

    @Override
    public Transport registerF(FunctionWrapper function) {
        this.functions.add(function);
        return this;
    }

    @Override
    public void onThrowable(Throwable t) {
        this.status = Socket.STATUS.ERROR;
        this.errorHandled.set(TransportsUtil.invokeFunction(this.decoders, this.functions, t.getClass(), t, Event.ERROR.name(), this.resolver));
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        if (this.isBinary) {
            byte[] payload = bodyPart.getBodyPartBytes();
            TransportsUtil.invokeFunction(this.decoders, this.functions, payload.getClass(), payload, Event.MESSAGE.name(), this.resolver);
        } else {
            String m = new String(bodyPart.getBodyPartBytes(), this.charSet).trim();
            if (!m.isEmpty()) {
                TransportsUtil.invokeFunction(this.decoders, this.functions, m.getClass(), m, Event.MESSAGE.name(), this.resolver);
            }
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        TransportsUtil.invokeFunction(this.decoders, this.functions, Map.class, headers.getHeaders(), Event.MESSAGE.name(), this.resolver);
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        TransportsUtil.invokeFunction(this.decoders, this.functions, Request.TRANSPORT.class, (Object)this.name(), Event.TRANSPORT.name(), this.resolver);
        boolean reconnect = false;
        if (!this.status.equals((Object)Socket.STATUS.INIT)) {
            reconnect = true;
        }
        this.status = Socket.STATUS.OPEN;
        this.errorHandled.set(false);
        TransportsUtil.invokeFunction(reconnect ? Event.RECONNECT : Event.OPEN, this.decoders, this.functions, String.class, Event.OPEN.name(), Event.OPEN.name(), this.resolver);
        TransportsUtil.invokeFunction(Event.MESSAGE, this.decoders, this.functions, Integer.class, new Integer(responseStatus.getStatusCode()), Event.STATUS.name(), this.resolver);
        return AsyncHandler.STATE.CONTINUE;
    }

    public String onCompleted() throws Exception {
        if (this.closed.get()) {
            return "";
        }
        this.status = Socket.STATUS.INIT;
        if (this.options.reconnect()) {
            if (this.options.reconnectInSeconds() > 0) {
                ScheduledExecutorService e = this.options.runtime().getConfig().reaper();
                e.schedule(new Runnable(){

                    @Override
                    public void run() {
                        StreamTransport.this.reconnect();
                    }
                }, (long)this.options.reconnectInSeconds(), TimeUnit.SECONDS);
            } else {
                this.reconnect();
            }
        } else {
            this.status = Socket.STATUS.CLOSE;
        }
        return "";
    }

    void reconnect() {
        Map<String, List<String>> c = this.request.queryString();
        FluentStringsMap f = new FluentStringsMap();
        f.putAll(c);
        try {
            this.options.runtime().executeRequest(this.requestBuilder.setQueryParameters(f).build(), (AsyncHandler)this);
        }
        catch (IOException e) {
            this.logger.error("", (Throwable)e);
        }
    }

    @Override
    public Request.TRANSPORT name() {
        return Request.TRANSPORT.STREAMING;
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.status = Socket.STATUS.CLOSE;
        TransportsUtil.invokeFunction(this.decoders, this.functions, String.class, Event.CLOSE.name(), Event.CLOSE.name(), this.resolver);
    }

    @Override
    public Socket.STATUS status() {
        return this.status;
    }

    @Override
    public boolean errorHandled() {
        return this.errorHandled.get();
    }
}

