/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResource;

public interface AtmosphereRequest
extends HttpServletRequest {
    public boolean destroyed();

    public AtmosphereRequest destroyable(boolean var1);

    public String getPathInfo();

    public String getPathTranslated();

    public String getQueryString();

    public String getRemoteUser();

    public String getRequestedSessionId();

    public String getMethod();

    public Part getPart(String var1) throws IOException, ServletException;

    public Collection<Part> getParts() throws IOException, ServletException;

    public String getContentType();

    public DispatcherType getDispatcherType();

    public String getServletPath();

    public String getRequestURI();

    public StringBuffer getRequestURL();

    public Enumeration getHeaders(String var1);

    public int getIntHeader(String var1);

    public Enumeration<String> getHeaderNames();

    public boolean authenticate(HttpServletResponse var1) throws IOException, ServletException;

    public String getAuthType();

    public String getContextPath();

    public Cookie[] getCookies();

    public long getDateHeader(String var1);

    public String getHeader(String var1);

    public HttpServletRequest wrappedRequest();

    public String getHeader(String var1, boolean var2);

    public String getParameter(String var1);

    public Map<String, String[]> getParameterMap();

    public Enumeration<String> getParameterNames();

    public String[] getParameterValues(String var1);

    public String getProtocol();

    public ServletInputStream getInputStream() throws IOException;

    public BufferedReader getReader() throws IOException;

    public String getRealPath(String var1);

    public AtmosphereRequest headers(Map<String, String> var1);

    public AtmosphereRequest header(String var1, String var2);

    public AtmosphereRequest queryString(String var1);

    public Map<String, String> headersMap();

    public Map<String, String[]> queryStringsMap();

    public AtmosphereRequest method(String var1);

    public AtmosphereRequest contentType(String var1);

    public AtmosphereRequest body(String var1);

    public AtmosphereRequest body(byte[] var1);

    public AtmosphereRequest body(InputStream var1);

    public AtmosphereRequest body(Reader var1);

    public AtmosphereRequestImpl.Body body();

    public AtmosphereRequest servletPath(String var1);

    public AtmosphereRequest contextPath(String var1);

    public AtmosphereRequest requestURI(String var1);

    public void setAttribute(String var1, Object var2);

    public void setCharacterEncoding(String var1) throws UnsupportedEncodingException;

    public AsyncContext startAsync();

    public AsyncContext startAsync(ServletRequest var1, ServletResponse var2);

    public AsyncContext getAsyncContext();

    public Object getAttribute(String var1);

    public void removeAttribute(String var1);

    public LocalAttributes attributes();

    public HttpSession getSession();

    public HttpSession getSession(boolean var1);

    public Principal getUserPrincipal();

    public boolean isRequestedSessionIdFromCookie();

    public boolean isRequestedSessionIdFromUrl();

    public boolean isRequestedSessionIdFromURL();

    public boolean isRequestedSessionIdValid();

    public boolean isUserInRole(String var1);

    public void login(String var1, String var2) throws ServletException;

    public void logout() throws ServletException;

    public String getRemoteAddr();

    public String getRemoteHost();

    public int getRemotePort();

    public RequestDispatcher getRequestDispatcher(String var1);

    public String getScheme();

    public String getServerName();

    public int getServerPort();

    public ServletContext getServletContext();

    public boolean isAsyncStarted();

    public boolean isAsyncSupported();

    public boolean isSecure();

    public String getLocalName();

    public int getLocalPort();

    public String getLocalAddr();

    public Locale getLocale();

    public AtmosphereResource resource();

    public Enumeration<Locale> getLocales();

    public boolean dispatchRequestAsynchronously();

    public boolean isDestroyable();

    public AtmosphereRequest pathInfo(String var1);

    public Enumeration<String> getAttributeNames();

    public LocalAttributes localAttributes();

    public String getCharacterEncoding();

    public int getContentLength();

    public String uuid();

    public void destroy();

    public void destroy(boolean var1);

    public void setRequest(ServletRequest var1);

    public String toString();

    public String requestURL();

    public static interface Builder {
        public Builder destroyable(boolean var1);

        public Builder headers(Map<String, String> var1);

        public Builder cookies(Set<Cookie> var1);

        public Builder dispatchRequestAsynchronously(boolean var1);

        public Builder remoteAddr(String var1);

        public Builder remoteHost(String var1);

        public Builder remotePort(int var1);

        public Builder localAddr(String var1);

        public Builder localName(String var1);

        public Builder localPort(int var1);

        public Builder remoteInetSocketAddress(Callable var1);

        public Builder localInetSocketAddress(Callable var1);

        public Builder attributes(Map<String, Object> var1);

        public Builder request(HttpServletRequest var1);

        public Builder servletPath(String var1);

        public Builder requestURI(String var1);

        public Builder requestURL(String var1);

        public Builder pathInfo(String var1);

        public Builder queryString(String var1);

        public Builder body(byte[] var1);

        public Builder body(byte[] var1, int var2, int var3);

        public Builder encoding(String var1);

        public Builder method(String var1);

        public Builder contentType(String var1);

        public Builder contentLength(Long var1);

        public Builder body(String var1);

        public Builder inputStream(InputStream var1);

        public Builder reader(Reader var1);

        public AtmosphereRequest build();

        public Builder queryStrings(Map<String, String[]> var1);

        public Builder contextPath(String var1);

        public Builder serverName(String var1);

        public Builder serverPort(int var1);

        public Builder session(HttpSession var1);

        public Builder principal(Principal var1);

        public Builder authType(String var1);

        public Builder isSSecure(boolean var1);

        public Builder locale(Locale var1);

        public Builder userPrincipal(Principal var1);
    }

    public static final class LocalAttributes {
        private final Map<String, Object> localAttributes;

        public LocalAttributes(Map<String, Object> attributes) {
            this.localAttributes = attributes;
        }

        public LocalAttributes() {
            this.localAttributes = new ConcurrentHashMap<String, Object>();
        }

        public LocalAttributes put(String s, Object o) {
            this.localAttributes.put(s, o);
            return this;
        }

        public Object get(String s) {
            return this.localAttributes.get(s);
        }

        public Object remove(String name) {
            return this.localAttributes.remove(name);
        }

        public Map<String, Object> unmodifiableMap() {
            return Collections.unmodifiableMap(this.localAttributes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Map<String, Object> map = this.localAttributes;
            synchronized (map) {
                this.localAttributes.clear();
            }
        }

        public boolean containsKey(String key) {
            return this.localAttributes.containsKey(key);
        }
    }
}

