/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.runtime;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.atmosphere.runtime.AtmosphereResource;
import org.atmosphere.runtime.Broadcaster;
import org.atmosphere.runtime.BroadcasterListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereSession {
    protected final Logger logger = LoggerFactory.getLogger(AtmosphereSession.class);
    protected String uuid;
    protected BroadcasterListenerAdapter broadcasterListener;
    protected Broadcaster[] relatedBroadcasters;
    private AtmosphereResource resource;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition resourcePresent = this.lock.newCondition();

    public AtmosphereSession(AtmosphereResource r, Broadcaster ... broadcasters) {
        this.uuid = r.uuid();
        this.relatedBroadcasters = broadcasters;
        this.resource = r;
        this.broadcasterListener = new BroadcasterListenerAdapter(){

            @Override
            public void onAddAtmosphereResource(Broadcaster b, AtmosphereResource r) {
                if (r.uuid().equalsIgnoreCase(AtmosphereSession.this.uuid)) {
                    AtmosphereSession.this.logger.trace("AtmosphereSession tracking :  AtmosphereResource {} added", (Object)AtmosphereSession.this.uuid);
                    AtmosphereSession.this.setResource(r);
                }
            }

            @Override
            public void onRemoveAtmosphereResource(Broadcaster b, AtmosphereResource r) {
                if (r.uuid().equalsIgnoreCase(AtmosphereSession.this.uuid)) {
                    AtmosphereSession.this.logger.trace("AtmosphereSession tracking :  AtmosphereResource {} removed", (Object)AtmosphereSession.this.uuid);
                    AtmosphereSession.this.setResource(null);
                }
            }
        };
        for (Broadcaster b : broadcasters) {
            b.addBroadcasterListener(this.broadcasterListener);
        }
    }

    public AtmosphereSession(AtmosphereResource resource) {
        this(resource, resource.getAtmosphereConfig().getBroadcasterFactory().lookupAll().toArray(new Broadcaster[0]));
    }

    public AtmosphereResource acquire() {
        this.enterLock();
        try {
            AtmosphereResource atmosphereResource = this.resource;
            return atmosphereResource;
        }
        finally {
            this.releaseLock();
        }
    }

    public AtmosphereResource tryAcquire() throws InterruptedException {
        return this.tryAcquire(60);
    }

    public AtmosphereResource tryAcquire(int timeInSecond) throws InterruptedException {
        if (!this.enterLockWhenResourcePresent(timeInSecond)) {
            throw new IllegalStateException("There is no resource for session " + this.uuid);
        }
        try {
            AtmosphereResource atmosphereResource = this.resource;
            return atmosphereResource;
        }
        finally {
            this.releaseLock();
        }
    }

    public void close() {
        for (Broadcaster br : this.relatedBroadcasters) {
            br.removeBroadcasterListener(this.broadcasterListener);
        }
    }

    public String uuid() {
        return this.uuid;
    }

    private void setResource(AtmosphereResource res) {
        this.enterLock();
        try {
            this.resource = res;
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enterLockWhenResourcePresent(int timeInSecond) throws InterruptedException {
        long timeoutNanos = TimeUnit.SECONDS.toNanos(timeInSecond);
        boolean reentrant = this.lock.isHeldByCurrentThread();
        if (!this.lock.tryLock()) {
            long deadline = System.nanoTime() + timeoutNanos;
            if (!this.lock.tryLock(timeInSecond, TimeUnit.SECONDS)) {
                return false;
            }
            timeoutNanos = deadline - System.nanoTime();
        }
        boolean satisfied = false;
        boolean threw = true;
        try {
            satisfied = this.resource != null || this.awaitNanosForResourceToBePresent(timeoutNanos, reentrant);
            threw = false;
            boolean bl = satisfied;
            return bl;
        }
        finally {
            if (!satisfied) {
                try {
                    if (threw && !reentrant) {
                        this.signalWaiter();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    private boolean awaitNanosForResourceToBePresent(long nanos, boolean signalBeforeWaiting) throws InterruptedException {
        if (signalBeforeWaiting) {
            this.signalWaiter();
        }
        do {
            if (nanos < 0L) {
                return false;
            }
            nanos = this.resourcePresent.awaitNanos(nanos);
        } while (this.resource == null);
        return true;
    }

    private void enterLock() {
        this.lock.lock();
    }

    private void releaseLock() {
        try {
            if (this.lock.getHoldCount() == 1) {
                this.signalWaiter();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void signalWaiter() {
        if (this.resource != null) {
            this.resourcePresent.signal();
        }
    }
}

