/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import org.atmosphere.runtime.Action;
import org.atmosphere.runtime.AsyncIOInterceptorAdapter;
import org.atmosphere.runtime.AsyncIOWriter;
import org.atmosphere.runtime.AtmosphereInterceptorAdapter;
import org.atmosphere.runtime.AtmosphereInterceptorWriter;
import org.atmosphere.runtime.AtmosphereResource;
import org.atmosphere.runtime.AtmosphereResourceImpl;
import org.atmosphere.runtime.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidAtmosphereInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(AndroidAtmosphereInterceptor.class);
    private static final byte[] padding;
    private static final String paddingText;

    @Override
    public Action inspect(AtmosphereResource r) {
        if (!r.transport().equals((Object)AtmosphereResource.TRANSPORT.STREAMING)) {
            return Action.CONTINUE;
        }
        AtmosphereResponse response = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getResponse(false);
        String userAgent = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getRequest(false).getHeader("User-Agent");
        if (userAgent != null && (userAgent.indexOf("Android 2.") != -1 || userAgent.indexOf("Android 3.") != -1)) {
            super.inspect(r);
            AsyncIOWriter writer = response.getAsyncIOWriter();
            if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
                ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(new AsyncIOInterceptorAdapter(){

                    @Override
                    public void prePayload(AtmosphereResponse response, byte[] data, int offset, int length) {
                        response.write(padding, true);
                    }

                    @Override
                    public void postPayload(AtmosphereResponse response, byte[] data, int offset, int length) {
                        response.write(padding, true);
                    }
                });
            } else {
                logger.warn("Unable to apply {}. Your AsyncIOWriter must implement {}", (Object)this.getClass().getName(), (Object)AtmosphereInterceptorWriter.class.getName());
            }
        }
        return Action.CONTINUE;
    }

    @Override
    public String toString() {
        return "Android Interceptor Support";
    }

    static {
        StringBuilder whitespace = new StringBuilder();
        for (int i = 0; i < 4096; ++i) {
            whitespace.append(" ");
        }
        whitespace.append("\n");
        paddingText = whitespace.toString();
        padding = paddingText.getBytes();
    }
}

