/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import org.atmosphere.runtime.Action;
import org.atmosphere.runtime.AsyncSupport;
import org.atmosphere.runtime.AsynchronousProcessor;
import org.atmosphere.runtime.AtmosphereConfig;
import org.atmosphere.runtime.AtmosphereRequest;
import org.atmosphere.runtime.AtmosphereResource;
import org.atmosphere.runtime.AtmosphereResourceEvent;
import org.atmosphere.runtime.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.runtime.AtmosphereResourceImpl;
import org.atmosphere.runtime.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingIOCometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(BlockingIOCometSupport.class);
    protected static final String LATCH = BlockingIOCometSupport.class.getName() + ".latch";

    public BlockingIOCometSupport(AtmosphereConfig config) {
        super(config);
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = null;
        action = this.suspended(req, res);
        if (action.type() == Action.TYPE.SUSPEND) {
            this.suspend(action, req, res);
        } else if (action.type() == Action.TYPE.RESUME) {
            CountDownLatch latch = (CountDownLatch)req.getAttribute(LATCH);
            if (latch == null || req.getAttribute(AtmosphereResourceImpl.PRE_SUSPEND) == null) {
                logger.debug("response wasn't suspended: {}", (Object)res);
                return action;
            }
            latch.countDown();
            Action nextAction = this.resumed(req, res);
            if (nextAction.type() == Action.TYPE.SUSPEND) {
                this.suspend(action, req, res);
            }
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspend(Action action, AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        final CountDownLatch latch = new CountDownLatch(1);
        req.setAttribute(LATCH, latch);
        boolean ok = true;
        AtmosphereResource resource = req.resource();
        if (resource != null) {
            try {
                resource.addEventListener(new AtmosphereResourceEventListenerAdapter.OnResume(){

                    @Override
                    public void onResume(AtmosphereResourceEvent event) {
                        latch.countDown();
                    }
                });
                if (action.timeout() != -1L) {
                    ok = latch.await(action.timeout(), TimeUnit.MILLISECONDS);
                } else {
                    latch.await();
                }
            }
            catch (InterruptedException ex) {
                logger.trace("", (Throwable)ex);
            }
            finally {
                if (!ok) {
                    this.timedout(req, res);
                } else {
                    ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(resource)).cancel();
                }
            }
        }
    }

    @Override
    public Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action a = super.cancelled(req, res);
        if (req.getAttribute(LATCH) != null) {
            CountDownLatch latch = (CountDownLatch)req.getAttribute(LATCH);
            latch.countDown();
        }
        return a;
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        try {
            super.action(r);
            if (r.action().type() == Action.TYPE.RESUME) {
                this.complete(r);
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }

    @Override
    public AsyncSupport complete(AtmosphereResourceImpl r) {
        AtmosphereRequest req = r.getRequest(false);
        CountDownLatch latch = null;
        if (req.getAttribute(LATCH) != null) {
            latch = (CountDownLatch)req.getAttribute(LATCH);
        }
        if (latch != null) {
            latch.countDown();
        } else if (req.getAttribute(AtmosphereResourceImpl.PRE_SUSPEND) == null) {
            logger.trace("Unable to resume the suspended connection");
        }
        return this;
    }
}

