/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import java.util.Collection;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.service.BroadcasterListenerService;
import org.atmosphere.runtime.AtmosphereFramework;
import org.atmosphere.runtime.Broadcaster;
import org.atmosphere.runtime.BroadcasterListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereAnnotation(value=BroadcasterListenerService.class)
public class BroadcasterListenerServiceProcessor
implements Processor<BroadcasterListener> {
    private static final Logger logger = LoggerFactory.getLogger(BroadcasterListenerServiceProcessor.class);

    @Override
    public void handle(AtmosphereFramework framework, Class<BroadcasterListener> annotatedClass) {
        try {
            BroadcasterListener l = framework.newClassInstance(BroadcasterListener.class, annotatedClass);
            framework.addBroadcasterListener(l);
            Collection<Broadcaster> c = framework.getBroadcasterFactory().lookupAll();
            for (Broadcaster b : c) {
                l.onPostCreate(b);
            }
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
    }
}

