/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.atmosphere.runtime.AtmosphereResourceSession;

public class DefaultAtmosphereResourceSession
implements AtmosphereResourceSession {
    private final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private volatile boolean valid = true;

    @Override
    public Object setAttribute(String name, Object value) {
        this.checkValid();
        return this.attributes.put(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        this.checkValid();
        return this.attributes.get(name);
    }

    @Override
    public <T> T getAttribute(String name, Class<T> type) {
        return type.cast(this.getAttribute(name));
    }

    @Override
    public Collection<String> getAttributeNames() {
        this.checkValid();
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    @Override
    public void invalidate() {
        this.checkValid();
        this.valid = false;
        this.attributes.clear();
    }

    protected void checkValid() {
        if (!this.valid) {
            throw new IllegalStateException("Session is invalid");
        }
    }
}

