/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.runtime;

public final class Action {
    public static final Action CANCELLED = new Action(TYPE.CANCELLED, true);
    public static final Action CONTINUE = new Action(TYPE.CONTINUE, true);
    public static final Action CREATED = new Action(TYPE.CREATED, true);
    public static final Action RESUME = new Action(TYPE.RESUME, true);
    public static final Action SUSPEND = new Action(TYPE.SUSPEND, true);
    public static final Action DESTROYED = new Action(TYPE.DESTROYED, true);
    public static final Action SKIP_ATMOSPHEREHANDLER = new Action(TYPE.SKIP_ATMOSPHEREHANDLER);
    private long timeout;
    private TYPE type;
    private boolean immutable;

    public Action() {
        this(TYPE.CREATED);
    }

    public Action(TYPE type) {
        this(type, -1L);
    }

    public Action(TYPE type, boolean immutable) {
        this(type, -1L);
        this.immutable = immutable;
    }

    public Action(TYPE type, long timeout) {
        this.timeout = timeout;
        this.type = type;
    }

    public TYPE type() {
        return this.type;
    }

    public Action type(TYPE type) {
        if (this.immutable) {
            throw new IllegalStateException("immutable");
        }
        this.type = type;
        return this;
    }

    public long timeout() {
        return this.timeout;
    }

    public Action timeout(long timeout) {
        if (this.immutable) {
            throw new IllegalStateException("immutable");
        }
        this.timeout = timeout;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action action = (Action)o;
        if (this.timeout != action.timeout()) {
            return false;
        }
        return this.type == action.type();
    }

    public int hashCode() {
        int result = (int)(this.timeout ^ this.timeout >>> 32);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Action{timeout=" + this.timeout + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum TYPE {
        SUSPEND,
        RESUME,
        TIMEOUT,
        CANCELLED,
        CONTINUE,
        CREATED,
        DESTROYED,
        SUSPEND_MESSAGE,
        SKIP_ATMOSPHEREHANDLER;

    }
}

