/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import org.apache.catalina.CometEvent;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.ExecutorsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatCometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TomcatCometSupport.class);
    public static final String COMET_EVENT = "CometEvent";
    private static final String SUSPENDED = TomcatCometSupport.class.getName() + ".suspended";
    private final Boolean closeConnectionOnInputStream;

    public TomcatCometSupport(AtmosphereConfig config) {
        super(config);
        String b = config.getInitParameter("org.atmosphere.container.TomcatCometSupport.discardEOF");
        this.closeConnectionOnInputStream = b == null || Boolean.parseBoolean(b.toString());
        try {
            Class.forName(CometEvent.class.getName());
        }
        catch (Throwable e) {
            logger.error("Unable to load class {}. Please make sure you have properly installed Atmosphere http://goo.gl/KEi8pc", (Object)CometEvent.class.getName(), (Object)e);
            throw new IllegalStateException(TomcatCometSupport.unableToDetectComet());
        }
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        CometEvent event = (CometEvent)req.getAttribute(COMET_EVENT);
        if (event == null) {
            throw new IllegalStateException(TomcatCometSupport.unableToDetectComet());
        }
        Action action = null;
        if (event.getEventType() == CometEvent.EventType.BEGIN) {
            action = this.suspended(req, res);
            if (action.type() == Action.TYPE.SUSPEND) {
                try {
                    if (action.timeout() != -1L) {
                        event.setTimeout((int)action.timeout());
                    } else {
                        event.setTimeout(Integer.MAX_VALUE);
                    }
                    req.setAttribute(SUSPENDED, true);
                }
                catch (UnsupportedOperationException ex) {
                    logger.trace("Warning: CometEvent.setTimeout not supported on this Tomcat instance.  [The Tomcat native connector does not support timeouts on asynchronous I/O.]");
                }
                req.setAttribute(SUSPENDED, true);
            } else {
                this.close(event);
            }
        } else if (event.getEventType() != CometEvent.EventType.READ) {
            if (event.getEventSubType() == CometEvent.EventSubType.CLIENT_DISCONNECT) {
                if (req.getAttribute(SUSPENDED) != null && this.closeConnectionOnInputStream.booleanValue()) {
                    req.setAttribute(SUSPENDED, null);
                    action = this.cancelled(req, res);
                }
                this.close(event);
            } else if (event.getEventSubType() == CometEvent.EventSubType.TIMEOUT) {
                action = this.timedout(req, res);
                this.close(event);
            } else if (event.getEventType() == CometEvent.EventType.ERROR) {
                this.close(event);
            } else if (event.getEventType() == CometEvent.EventType.END) {
                if (req.resource() != null && req.resource().isResumed()) {
                    ((AtmosphereResourceImpl)req.resource()).cancel();
                } else if (req.getAttribute(SUSPENDED) != null && this.closeConnectionOnInputStream.booleanValue()) {
                    req.setAttribute(SUSPENDED, null);
                    action = this.cancelled(req, res);
                } else {
                    this.close(event);
                }
            }
        }
        return action;
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        super.action(r);
        if (r.action().type() == Action.TYPE.RESUME && r.isInScope()) {
            this.complete(r);
        }
    }

    private void close(CometEvent event) {
        try {
            event.close();
        }
        catch (Exception ex) {
            logger.trace("event.close", (Throwable)ex);
        }
    }

    @Override
    public AsyncSupport<AtmosphereResourceImpl> complete(AtmosphereResourceImpl r) {
        CometEvent event = (CometEvent)r.getRequest(false).getAttribute(COMET_EVENT);
        if (event == null) {
            return this;
        }
        if (!r.isResumed()) {
            ExecutorsFactory.getScheduler(this.config).schedule(() -> this.close(event), 500L, TimeUnit.MILLISECONDS);
        } else {
            this.close(event);
        }
        return this;
    }

    @Override
    public Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = super.cancelled(req, res);
        if (req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity") != null && (Long)req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity") == -1L) {
            CometEvent event = (CometEvent)req.getAttribute(COMET_EVENT);
            if (event == null) {
                return action;
            }
            try {
                event.close();
            }
            catch (IllegalStateException ex) {
                logger.trace("event.close", (Throwable)ex);
            }
        }
        return action;
    }

    private static String unableToDetectComet() {
        return "Tomcat failed to detect this is a Comet application because context.xml is missing or the Http11NioProtocol Connector is not enabled.You must use the atmosphere-native-runtime dependency in order to use native Comet Support\nIf that's not the case, you can also remove META-INF/context.xml and WEB-INF/lib/atmosphere-compat-tomcat.jar";
    }
}

