/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import javax.servlet.ServletException;
import org.atmosphere.annotation.AnnotationUtil;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.service.AtmosphereService;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereAnnotation(value=AtmosphereService.class)
public class AtmosphereServiceProcessor
implements Processor<Object> {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereServiceProcessor.class);

    @Override
    public void handle(AtmosphereFramework framework, Class<Object> annotatedClass) {
        try {
            Class<Object> aClass = annotatedClass;
            AtmosphereService a = aClass.getAnnotation(AtmosphereService.class);
            framework.setBroadcasterCacheClassName(a.broadcasterCache().getName());
            AnnotationUtil.atmosphereConfig(a.atmosphereConfig(), framework);
            framework.setDefaultBroadcasterClassName(a.broadcaster().getName());
            AnnotationUtil.filters(a.broadcastFilters(), framework);
            LinkedList<AtmosphereInterceptor> l = new LinkedList<AtmosphereInterceptor>();
            AtmosphereInterceptor aa = AnnotationUtil.listeners(a.listeners(), framework);
            if (aa != null) {
                l.add(aa);
            }
            if (!a.servlet().isEmpty()) {
                final ReflectorServletProcessor r = framework.newClassInstance(ReflectorServletProcessor.class, ReflectorServletProcessor.class);
                r.setServletClassName(a.servlet());
                String mapping = a.path();
                AnnotationUtil.interceptors(framework, Arrays.asList(a.interceptors()), l);
                if (!a.dispatch()) {
                    AtmosphereServletProcessor proxy = new AtmosphereServletProcessor(){
                        private String method = "GET";

                        @Override
                        public void onRequest(AtmosphereResource resource) throws IOException {
                            if (!resource.getRequest().getMethod().equalsIgnoreCase(this.method)) {
                                r.onRequest(resource);
                            }
                        }

                        @Override
                        public void onStateChange(AtmosphereResourceEvent event) throws IOException {
                            r.onStateChange(event);
                        }

                        @Override
                        public void destroy() {
                            r.destroy();
                        }

                        @Override
                        public void init(AtmosphereConfig config) throws ServletException {
                            String s = config.getInitParameter("org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor.method");
                            if (s != null) {
                                this.method = s;
                            }
                            r.init(config);
                        }
                    };
                    framework.addAtmosphereHandler(mapping, (AtmosphereHandler)proxy, l);
                } else {
                    framework.addAtmosphereHandler(mapping, (AtmosphereHandler)r, l);
                }
            } else {
                AnnotationUtil.interceptors(a.interceptors(), framework);
            }
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
    }
}

