/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import org.atmosphere.container.version.JSR356WebSocket;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.IOUtils;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR356Endpoint
extends Endpoint {
    private static final Logger logger = LoggerFactory.getLogger(JSR356Endpoint.class);
    private final WebSocketProcessor webSocketProcessor;
    private final Integer maxBinaryBufferSize;
    private final Integer maxTextBufferSize;
    private AtmosphereRequest request;
    private final AtmosphereFramework framework;
    private WebSocket webSocket;
    private final int webSocketWriteTimeout;
    private HandshakeRequest handshakeRequest;

    public JSR356Endpoint(AtmosphereFramework framework, WebSocketProcessor webSocketProcessor) {
        this.framework = framework;
        this.webSocketProcessor = webSocketProcessor;
        if (framework.isUseNativeImplementation()) {
            throw new IllegalStateException("You cannot use WebSocket native implementation with JSR356. Please set org.atmosphere.useNative to false");
        }
        String s = framework.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.maxIdleTime");
        this.webSocketWriteTimeout = s != null ? Integer.valueOf(s) : -1;
        s = framework.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.maxBinaryMessageSize");
        this.maxBinaryBufferSize = s != null ? Integer.valueOf(s) : Integer.valueOf(-1);
        s = framework.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.maxTextMessageSize");
        this.maxTextBufferSize = s != null ? Integer.valueOf(s) : Integer.valueOf(-1);
    }

    public JSR356Endpoint handshakeRequest(HandshakeRequest handshakeRequest) {
        this.handshakeRequest = handshakeRequest;
        return this;
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        String pathInfo;
        if (this.framework.isDestroyed()) {
            return;
        }
        if (!this.webSocketProcessor.handshake((HttpServletRequest)this.request)) {
            try {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, "Handshake not accepted."));
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
            }
            return;
        }
        if (!session.isOpen()) {
            logger.trace("Session Closed {}", (Object)session);
            return;
        }
        if (this.maxBinaryBufferSize != -1) {
            session.setMaxBinaryMessageBufferSize(this.maxBinaryBufferSize.intValue());
        }
        if (this.webSocketWriteTimeout != -1) {
            session.setMaxIdleTimeout((long)this.webSocketWriteTimeout);
        }
        if (this.maxTextBufferSize != -1) {
            session.setMaxTextMessageBufferSize(this.maxTextBufferSize.intValue());
        }
        this.webSocket = new JSR356WebSocket(session, this.framework.getAtmosphereConfig());
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry e : this.handshakeRequest.getHeaders().entrySet()) {
            headers.put((String)e.getKey(), ((List)e.getValue()).size() > 0 ? (String)((List)e.getValue()).get(0) : "");
        }
        String servletPath = IOUtils.guestServletPath(this.framework.getAtmosphereConfig());
        URI uri = session.getRequestURI();
        String[] paths = uri.getPath() != null ? uri.getPath().split("/") : new String[]{};
        int pathInfoStartIndex = 3;
        String contextPath = this.framework.getAtmosphereConfig().getServletContext().getContextPath();
        if ("".equals(contextPath) || "".equals(servletPath)) {
            pathInfoStartIndex = 2;
        }
        StringBuffer b = new StringBuffer("/");
        for (int i = 0; i < paths.length; ++i) {
            if (i < pathInfoStartIndex) continue;
            b.append(paths[i]).append("/");
        }
        if (b.length() > 1) {
            b.deleteCharAt(b.length() - 1);
        }
        if ((pathInfo = b.toString()).equals("/")) {
            pathInfo = null;
        }
        try {
            String requestURL = uri.toASCIIString();
            if (requestURL.contains("?")) {
                requestURL = requestURL.substring(0, requestURL.indexOf("?"));
            }
            if (!requestURL.startsWith("http://") || !requestURL.startsWith("https://")) {
                if (requestURL.startsWith("/")) {
                    String origin;
                    List l = (List)this.handshakeRequest.getHeaders().get("origin");
                    if (l == null) {
                        l = (List)this.handshakeRequest.getHeaders().get("Origin");
                    }
                    if (l != null && l.size() > 0) {
                        origin = (String)l.get(0);
                    } else {
                        logger.trace("Unable to retrieve the `origin` header for websocket {}", (Object)session);
                        origin = "http" + (session.isSecure() ? "s" : "") + "://0.0.0.0:80";
                    }
                    requestURL = origin + requestURL;
                } else if (requestURL.startsWith("ws://")) {
                    requestURL = requestURL.replace("ws://", "http://");
                } else if (requestURL.startsWith("wss://")) {
                    requestURL = requestURL.replace("wss://", "https://");
                }
            }
            this.request = new AtmosphereRequest.Builder().requestURI(uri.getPath()).requestURL(requestURL).headers(headers).session((HttpSession)this.handshakeRequest.getHttpSession()).servletPath(servletPath).contextPath(this.framework.getServletContext().getContextPath()).pathInfo(pathInfo).userPrincipal(session.getUserPrincipal()).build().queryString(session.getQueryString());
            this.framework.addInitParameter("org.atmosphere.cpr.allowQueryStreamAsPostOrGet", "false");
            this.webSocketProcessor.open(this.webSocket, this.request, AtmosphereResponse.newInstance(this.framework.getAtmosphereConfig(), this.request, this.webSocket));
            this.framework.addInitParameter("org.atmosphere.cpr.allowQueryStreamAsPostOrGet", "true");
            if (session.isOpen()) {
                session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                    public void onMessage(String s) {
                        JSR356Endpoint.this.webSocketProcessor.invokeWebSocketProtocol(JSR356Endpoint.this.webSocket, s);
                    }
                });
                session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

                    public void onMessage(ByteBuffer bb) {
                        byte[] b = bb.hasArray() ? bb.array() : new byte[bb.limit()];
                        bb.get(b);
                        JSR356Endpoint.this.webSocketProcessor.invokeWebSocketProtocol(JSR356Endpoint.this.webSocket, b, 0, b.length);
                    }
                });
            } else {
                logger.trace("Session closed during onOpen {}", (Object)session);
                this.onClose(session, new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "Session closed already"));
            }
        }
        catch (Throwable e) {
            if (session.isOpen()) {
                logger.error("", e);
            } else {
                logger.warn("Session closed during onOpen", e);
            }
            try {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, e.getMessage()));
            }
            catch (IOException e1) {
                logger.debug("", e);
            }
            return;
        }
    }

    public void onClose(Session session, CloseReason closeCode) {
        logger.trace("{} closed {}", (Object)session, (Object)closeCode);
        if (this.request != null) {
            this.request.destroy();
            this.webSocketProcessor.close(this.webSocket, closeCode.getCloseCode().getCode());
        }
    }

    public void onError(Session session, Throwable t) {
        logger.error("", t);
        this.webSocketProcessor.notifyListener(this.webSocket, new WebSocketEventListener.WebSocketEvent<Throwable>(t, WebSocketEventListener.WebSocketEvent.TYPE.EXCEPTION, this.webSocket));
    }
}

