/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDisconnectInterceptor
extends AtmosphereInterceptorAdapter {
    private final Logger logger = LoggerFactory.getLogger(OnDisconnectInterceptor.class);
    private AsynchronousProcessor p;
    private AtmosphereConfig config;

    @Override
    public void configure(AtmosphereConfig config) {
        if (AsynchronousProcessor.class.isAssignableFrom(config.framework().getAsyncSupport().getClass())) {
            this.p = (AsynchronousProcessor)AsynchronousProcessor.class.cast(config.framework().getAsyncSupport());
        }
        this.config = config;
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        if (Utils.webSocketMessage(r)) {
            return Action.CONTINUE;
        }
        AtmosphereRequest request = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getRequest(false);
        String s = request.getHeader("X-Atmosphere-Transport");
        String uuid = r.uuid();
        if (s != null && s.equalsIgnoreCase("close")) {
            this.logger.debug("AtmosphereResource {} disconnected", (Object)uuid);
            AtmosphereResource ss = this.config.resourcesFactory().find(uuid);
            if (ss != null) {
                ((AtmosphereResourceEventImpl)AtmosphereResourceEventImpl.class.cast(ss.getAtmosphereResourceEvent())).isClosedByClient(true);
                this.p.completeLifecycle(ss, false);
            } else {
                this.logger.debug("Was unable to execute onDisconnect on {}", (Object)r.uuid());
            }
            return Action.CANCELLED;
        }
        return Action.CONTINUE;
    }

    @Override
    public String toString() {
        return "Browser disconnection detection";
    }
}

