/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtmosphereResourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereResourceFactory.class);
    private static AtmosphereResourceFactory factory;
    private static final Broadcaster noOps;
    private static final AtmosphereHandler noOpsHandler;
    private static final AtmosphereHandler voidAtmosphereHandler;
    private final ConcurrentHashMap<String, AtmosphereResource> resources = new ConcurrentHashMap();

    public AtmosphereResourceFactory() {
        factory = this;
    }

    public final AtmosphereResource create(AtmosphereConfig config, AtmosphereRequest request, AtmosphereResponse response, AsyncSupport<?> a) {
        AtmosphereResource r = null;
        try {
            r = config.framework().newClassInstance(AtmosphereResource.class, AtmosphereResourceImpl.class);
            r.initialize(config, null, request, response, a, voidAtmosphereHandler);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return r;
    }

    public final AtmosphereResource create(AtmosphereConfig config, Broadcaster broadcaster, AtmosphereRequest request, AtmosphereResponse response, AsyncSupport<?> a, AtmosphereHandler handler) {
        return this.create(config, broadcaster, request, response, a, handler, AtmosphereResource.TRANSPORT.UNDEFINED);
    }

    public final AtmosphereResource create(AtmosphereConfig config, Broadcaster broadcaster, AtmosphereRequest request, AtmosphereResponse response, AsyncSupport<?> a, AtmosphereHandler handler, AtmosphereResource.TRANSPORT T) {
        AtmosphereResource r = null;
        try {
            r = config.framework().newClassInstance(AtmosphereResource.class, AtmosphereResourceImpl.class);
            if (request.getHeader("X-Atmosphere-Transport") == null) {
                request.header("X-Atmosphere-Transport", T.name());
            }
            r.initialize(config, broadcaster, request, response, a, handler);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return r;
    }

    public final AtmosphereResource create(AtmosphereConfig config, Broadcaster broadcaster, AtmosphereResponse response, AsyncSupport<?> a, AtmosphereHandler handler) {
        return this.create(config, broadcaster, response.request(), response, a, handler);
    }

    public final AtmosphereResource create(AtmosphereConfig config, Broadcaster broadcaster, AtmosphereResponse response, AsyncSupport<?> a, AtmosphereHandler handler, AtmosphereResource.TRANSPORT t) {
        return this.create(config, broadcaster, response.request(), response, a, handler, t);
    }

    public final AtmosphereResource create(AtmosphereConfig config, AtmosphereResponse response, AsyncSupport<?> a) {
        AtmosphereResource r = null;
        try {
            r = config.framework().newClassInstance(AtmosphereResource.class, AtmosphereResourceImpl.class);
            r.initialize(config, null, response.request(), response, a, voidAtmosphereHandler);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return r;
    }

    public final AtmosphereResource create(AtmosphereConfig config, String uuid) {
        AtmosphereResponse response = AtmosphereResponse.newInstance();
        response.setHeader("X-Atmosphere-tracking-id", uuid);
        return this.create(config, noOps, AtmosphereRequest.newInstance(), response, config.framework().getAsyncSupport(), noOpsHandler);
    }

    public final AtmosphereResource remove(String uuid) {
        logger.trace("Removing: {}", (Object)uuid);
        AtmosphereResource r = this.resources.remove(uuid);
        if (r != null) {
            r.getAtmosphereConfig().getBroadcasterFactory().removeAllAtmosphereResource(r);
        }
        return r;
    }

    public final AtmosphereResource find(String uuid) {
        if (uuid == null) {
            return null;
        }
        return this.resources.get(uuid);
    }

    public final Set<Broadcaster> broadcasters(String uuid) {
        Collection<Broadcaster> l = BroadcasterFactory.getDefault().lookupAll();
        HashSet<Broadcaster> h = new HashSet<Broadcaster>();
        for (Broadcaster b : l) {
            for (AtmosphereResource r : b.getAtmosphereResources()) {
                if (!r.uuid().equalsIgnoreCase(uuid)) continue;
                h.add(b);
            }
        }
        return h;
    }

    public static final AtmosphereResourceFactory getDefault() {
        if (factory == null) {
            new AtmosphereResourceFactory();
        }
        return factory;
    }

    public void registerUuidForFindCandidate(AtmosphereResource r) {
        logger.trace("Adding: {}", (Object)r);
        this.resources.put(r.uuid(), r);
    }

    public void unRegisterUuidForFindCandidate(AtmosphereResource r) {
        logger.trace("Removing: {}", (Object)r);
        this.resources.remove(r.uuid());
    }

    public void destroy() {
        this.resources.clear();
    }

    public ConcurrentHashMap<String, AtmosphereResource> resources() {
        return this.resources;
    }

    static {
        noOps = (Broadcaster)Proxy.newProxyInstance(Broadcaster.class.getClassLoader(), new Class[]{Broadcaster.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        });
        noOpsHandler = (AtmosphereHandler)Proxy.newProxyInstance(AtmosphereHandler.class.getClassLoader(), new Class[]{AtmosphereHandler.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        });
        voidAtmosphereHandler = new AbstractReflectorAtmosphereHandler(){

            @Override
            public void onRequest(AtmosphereResource resource) throws IOException {
            }

            @Override
            public void destroy() {
            }
        };
    }
}

