/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyCometSupport
extends AsynchronousProcessor {
    public static final String SUSPEND = NettyCometSupport.class.getName() + ".suspend";
    public static final String RESUME = NettyCometSupport.class.getName() + ".resume";
    private static final Logger logger = LoggerFactory.getLogger(NettyCometSupport.class);

    public NettyCometSupport(AtmosphereConfig config) {
        super(config);
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = this.suspended(req, res);
        if (action.type() == Action.TYPE.SUSPEND) {
            req.setAttribute(SUSPEND, action);
        } else if (action.type() == Action.TYPE.RESUME) {
            req.setAttribute(SUSPEND, action);
            Boolean resumeOnBroadcast = (Boolean)req.getAttribute("org.atmosphere.resumeOnBroadcast");
            if (resumeOnBroadcast != null && resumeOnBroadcast.booleanValue()) {
                return action;
            }
            Action nextAction = this.resumed(req, res);
            if (nextAction.type() == Action.TYPE.SUSPEND) {
                req.setAttribute(SUSPEND, action);
            }
        }
        return action;
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        super.action(r);
        if (r.isResumed() && r.getRequest(false).getAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK) != null) {
            this.complete(r);
        }
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }

    @Override
    public AsyncSupport complete(AtmosphereResourceImpl r) {
        try {
            AtmosphereResponse response = r.getResponse(false);
            AsyncIOWriter a = response.getAsyncIOWriter();
            if (a != null) {
                a.close(response);
            }
        }
        catch (IOException e) {
            logger.trace("", (Throwable)e);
        }
        return this;
    }
}

