/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.interceptor.AllowInterceptor;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSEAtmosphereInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(SSEAtmosphereInterceptor.class);
    private static final byte[] padding;
    private static final String paddingText;
    private static final byte[] END;
    private String contentType = "text/event-stream";

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter(ApplicationConfig.SSE_DEFAULT_CONTENTTYPE);
        if (s != null) {
            this.contentType = s;
        }
    }

    private boolean writePadding(AtmosphereResponse response) {
        if (response.request() != null && response.request().getAttribute("paddingWritten") != null) {
            return false;
        }
        response.setContentType(this.contentType);
        response.setCharacterEncoding("utf-8");
        boolean isUsingStream = (Boolean)response.request().getAttribute("org.atmosphere.useStream");
        if (isUsingStream) {
            ServletOutputStream stream = null;
            try {
                stream = response.getResponse().getOutputStream();
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
            }
            try {
                stream.write(padding);
                stream.flush();
            }
            catch (IOException ex) {
                logger.warn("SSE may not work", (Throwable)ex);
            }
        } else {
            PrintWriter w = null;
            try {
                w = response.getResponse().getWriter();
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
            }
            w.println(paddingText);
            w.flush();
        }
        response.resource().getRequest().setAttribute("paddingWritten", "true");
        return true;
    }

    @Override
    public Action inspect(final AtmosphereResource r) {
        String accept;
        if (Utils.webSocketMessage(r)) {
            return Action.CONTINUE;
        }
        final AtmosphereResponse response = r.getResponse();
        AtmosphereRequest request = r.getRequest();
        String string = accept = request.getHeader("Accept") == null ? "text/plain" : request.getHeader("Accept").trim();
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.SSE) || this.contentType.equalsIgnoreCase(accept)) {
            super.inspect(r);
            r.addEventListener(new P(response));
            AsyncIOWriter writer = response.getAsyncIOWriter();
            if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
                ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(new AsyncIOInterceptorAdapter(){

                    private boolean padding() {
                        if (!r.isSuspended()) {
                            return SSEAtmosphereInterceptor.this.writePadding(response);
                        }
                        return false;
                    }

                    @Override
                    public void prePayload(AtmosphereResponse response2, byte[] data, int offset, int length) {
                        boolean noPadding = this.padding();
                        if (!noPadding || r.getRequest().getAttribute(FrameworkConfig.CALLBACK_JAVASCRIPT_PROTOCOL) != null) {
                            response2.write("data:", true);
                        }
                    }

                    @Override
                    public void postPayload(AtmosphereResponse response2, byte[] data, int offset, int length) {
                        String ua;
                        if (r.isSuspended() || r.getRequest().getAttribute(FrameworkConfig.CALLBACK_JAVASCRIPT_PROTOCOL) != null || r.getRequest().getAttribute("org.atmosphere.jersey.containerResponse") != null) {
                            response2.write(END, true);
                        }
                        if ((ua = r.getRequest().getHeader("User-Agent")) != null && ua.contains("MSIE")) {
                            try {
                                response2.flushBuffer();
                            }
                            catch (IOException e) {
                                logger.trace("", (Throwable)e);
                            }
                            r.resume();
                        }
                    }
                });
            } else {
                logger.warn("Unable to apply {}. Your AsyncIOWriter must implement {}", (Object)this.getClass().getName(), (Object)AtmosphereInterceptorWriter.class.getName());
            }
        }
        return Action.CONTINUE;
    }

    @Override
    public String toString() {
        return "SSE Interceptor Support";
    }

    static {
        END = "\r\n\r\n".getBytes();
        StringBuffer whitespace = new StringBuffer();
        for (int i = 0; i < 2000; ++i) {
            whitespace.append(" ");
        }
        whitespace.append("\n");
        paddingText = whitespace.toString();
        padding = paddingText.getBytes();
    }

    private final class P
    extends AtmosphereResourceEventListenerAdapter.OnPreSuspend
    implements AllowInterceptor {
        private final AtmosphereResponse response;

        private P(AtmosphereResponse response) {
            this.response = response;
        }

        @Override
        public void onPreSuspend(AtmosphereResourceEvent event) {
            SSEAtmosphereInterceptor.this.writePadding(this.response);
        }
    }
}

