/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.Map;
import java.util.WeakHashMap;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.util.IOUtils;
import org.atmosphere.websocket.DefaultWebSocketProcessor;
import org.atmosphere.websocket.WebSocketProcessor;

public class WebSocketProcessorFactory {
    private static WebSocketProcessorFactory factory;
    private final Map<AtmosphereFramework, WebSocketProcessor> processors = new WeakHashMap<AtmosphereFramework, WebSocketProcessor>();

    public static final synchronized WebSocketProcessorFactory getDefault() {
        if (factory == null) {
            factory = new WebSocketProcessorFactory();
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSocketProcessor getWebSocketProcessor(AtmosphereFramework framework) {
        WebSocketProcessor processor = this.processors.get(framework);
        if (processor == null) {
            AtmosphereFramework atmosphereFramework = framework;
            synchronized (atmosphereFramework) {
                processor = this.createProcessor(framework);
                this.processors.put(framework, processor);
            }
        }
        return processor;
    }

    public synchronized void destroy() {
        for (WebSocketProcessor processor : this.processors.values()) {
            processor.destroy();
        }
        this.processors.clear();
    }

    private WebSocketProcessor createProcessor(AtmosphereFramework framework) {
        WebSocketProcessor processor = null;
        String webSocketProcessorName = framework.getWebSocketProcessorClassName();
        if (!webSocketProcessorName.equalsIgnoreCase(DefaultWebSocketProcessor.class.getName())) {
            try {
                processor = framework.newClassInstance(WebSocketProcessor.class, IOUtils.loadClass(this.getClass(), webSocketProcessorName));
            }
            catch (Exception ex) {
                processor = new DefaultWebSocketProcessor(framework);
            }
        }
        if (processor == null) {
            processor = new DefaultWebSocketProcessor(framework);
        }
        return processor;
    }
}

