/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import java.util.ArrayList;
import org.atmosphere.annotation.AnnotationUtil;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.managed.ManagedAtmosphereHandler;
import org.atmosphere.config.managed.ManagedServiceInterceptor;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.handler.AnnotatedProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereAnnotation(value=ManagedService.class)
public class ManagedServiceProcessor
implements Processor<Object> {
    private static final Logger logger = LoggerFactory.getLogger(ManagedServiceProcessor.class);

    @Override
    public void handle(AtmosphereFramework framework, Class<Object> annotatedClass) {
        try {
            Class<? extends AtmosphereInterceptor>[] interceptors;
            Class<Object> aClass = annotatedClass;
            ManagedService a = aClass.getAnnotation(ManagedService.class);
            framework.setBroadcasterCacheClassName(a.broadcasterCache().getName());
            ArrayList<AtmosphereInterceptor> l = new ArrayList<AtmosphereInterceptor>();
            AnnotationUtil.atmosphereConfig(a.atmosphereConfig(), framework);
            AnnotationUtil.filters(a.broadcastFilters(), framework);
            AtmosphereInterceptor aa = AnnotationUtil.listeners(a.listeners(), framework);
            if (aa != null) {
                l.add(aa);
            }
            Object c = framework.newClassInstance(Object.class, aClass);
            AnnotatedProxy handler = framework.newClassInstance(ManagedAtmosphereHandler.class, ManagedAtmosphereHandler.class).configure(framework.getAtmosphereConfig(), c);
            l.add(framework.newClassInstance(AtmosphereInterceptor.class, ManagedServiceInterceptor.class));
            for (Class<? extends AtmosphereInterceptor> i : interceptors = a.interceptors()) {
                try {
                    l.add(framework.newClassInstance(AtmosphereInterceptor.class, i));
                }
                catch (Throwable e) {
                    logger.warn("", e);
                }
            }
            framework.addAtmosphereHandler(a.path(), (AtmosphereHandler)handler, AnnotationUtil.broadcaster(framework, a.broadcaster(), a.path()), l);
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
    }
}

