/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRegistration;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder readEntirely(AtmosphereResource r) {
        StringBuilder stringBuilder = new StringBuilder();
        AtmosphereRequest request = r.getRequest();
        if (request.body().isEmpty()) {
            BufferedReader bufferedReader = null;
            try {
                block21: {
                    try {
                        ServletInputStream inputStream = request.getInputStream();
                        if (inputStream != null) {
                            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                        }
                    }
                    catch (IllegalStateException ex) {
                        logger.trace("", (Throwable)ex);
                        BufferedReader reader = request.getReader();
                        if (reader == null) break block21;
                        bufferedReader = new BufferedReader(reader);
                    }
                }
                if (bufferedReader != null) {
                    char[] charBuffer = new char[8192];
                    int bytesRead = -1;
                    while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                        stringBuilder.append(charBuffer, 0, bytesRead);
                    }
                }
                stringBuilder.append("");
            }
            catch (IOException ex) {
                logger.warn("", (Throwable)ex);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException ex) {
                        logger.warn("", (Throwable)ex);
                    }
                }
            }
        } else {
            AtmosphereRequest.Body body = request.body();
            try {
                stringBuilder.append(body.hasString() ? body.asString() : new String(body.asBytes(), body.byteOffset(), body.byteLength(), request.getCharacterEncoding()));
            }
            catch (UnsupportedEncodingException e) {
                logger.error("", (Throwable)e);
            }
        }
        return stringBuilder;
    }

    public static String guestServletPath(AtmosphereFramework framework, Class<? extends Servlet> clazz, Class<?> callee) {
        String servletPath = "";
        try {
            Map m = framework.getServletContext().getServletRegistrations();
            for (Map.Entry e : m.entrySet()) {
                if (!clazz.isAssignableFrom(IOUtils.loadClass(callee, ((ServletRegistration)e.getValue()).getClassName()))) continue;
                servletPath = "/" + ((String)((ServletRegistration)e.getValue()).getMappings().iterator().next()).replace("/", "").replace("*", "");
                break;
            }
        }
        catch (Exception ex) {
            logger.trace("", (Throwable)ex);
        }
        return servletPath;
    }

    public static Class<?> loadClass(Class thisClass, String className) throws Exception {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            return thisClass.getClassLoader().loadClass(className);
        }
    }
}

