/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import org.atmosphere.container.version.JSR356WebSocket;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.util.IOUtils;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR356Endpoint
extends Endpoint {
    private static final Logger logger = LoggerFactory.getLogger(JSR356Endpoint.class);
    private final WebSocketProcessor webSocketProcessor;
    private final Integer maxBinaryBufferSize;
    private final Integer maxTextBufferSize;
    private AtmosphereRequest request;
    private final AtmosphereFramework framework;
    private WebSocket webSocket;
    private final int webSocketWriteTimeout;
    private String servletPath = "";
    private HandshakeRequest handshakeRequest;

    public JSR356Endpoint(AtmosphereFramework framework, WebSocketProcessor webSocketProcessor) {
        this.framework = framework;
        this.webSocketProcessor = webSocketProcessor;
        if (framework.isUseNativeImplementation()) {
            throw new IllegalStateException("You cannot use WebSocket native implementation with JSR356. Please set org.atmosphere.useNative to false");
        }
        String s = framework.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.maxIdleTime");
        this.webSocketWriteTimeout = s != null ? Integer.valueOf(s) : -1;
        s = framework.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.maxBinaryMessageSize");
        this.maxBinaryBufferSize = s != null ? Integer.valueOf(s) : Integer.valueOf(-1);
        s = framework.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.maxTextMessageSize");
        this.maxTextBufferSize = s != null ? Integer.valueOf(s) : Integer.valueOf(-1);
        this.servletPath = IOUtils.guestServletPath(framework, AtmosphereServlet.class, ((Object)((Object)this)).getClass());
    }

    public JSR356Endpoint handshakeRequest(HandshakeRequest handshakeRequest) {
        this.handshakeRequest = handshakeRequest;
        return this;
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        if (!this.webSocketProcessor.handshake((HttpServletRequest)this.request)) {
            try {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, "Handshake not accepted."));
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
            }
            return;
        }
        if (this.maxBinaryBufferSize != -1) {
            session.setMaxBinaryMessageBufferSize(this.maxBinaryBufferSize.intValue());
        }
        if (this.webSocketWriteTimeout != -1) {
            session.setMaxIdleTimeout((long)this.webSocketWriteTimeout);
        }
        if (this.maxTextBufferSize != -1) {
            session.setMaxTextMessageBufferSize(this.maxTextBufferSize.intValue());
        }
        this.webSocket = new JSR356WebSocket(session, this.framework.getAtmosphereConfig());
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry e : this.handshakeRequest.getHeaders().entrySet()) {
            headers.put((String)e.getKey(), ((List)e.getValue()).size() > 0 ? (String)((List)e.getValue()).get(0) : "");
        }
        String pathInfo = "";
        StringBuffer p = new StringBuffer("/");
        try {
            boolean append = true;
            for (Map.Entry e : session.getPathParameters().entrySet()) {
                if (append && !((String)e.getKey()).equalsIgnoreCase("{path}")) {
                    append = false;
                }
                if (append) {
                    p.append((String)e.getValue()).append("/");
                    continue;
                }
                p.insert(0, (String)e.getValue()).insert(0, "/");
            }
            if (p.length() > 1) {
                p.deleteCharAt(p.length() - 1);
            }
            if (!(pathInfo = p.toString()).equals(this.servletPath) && pathInfo.length() > this.servletPath.length()) {
                pathInfo = p.toString().substring(this.servletPath.length());
            } else if (pathInfo.equals(this.servletPath)) {
                pathInfo = null;
            }
        }
        catch (Exception ex) {
            logger.warn("Unexpected path decoding", (Throwable)ex);
        }
        try {
            String requestUri = session.getRequestURI().toASCIIString();
            if (requestUri.contains("?")) {
                requestUri = requestUri.substring(0, requestUri.indexOf("?"));
            }
            this.request = new AtmosphereRequest.Builder().requestURI(requestUri).requestURL(requestUri).headers(headers).session((HttpSession)this.handshakeRequest.getHttpSession()).servletPath(this.servletPath).contextPath(this.framework.getServletContext().getContextPath()).pathInfo(pathInfo).userPrincipal(session.getUserPrincipal()).build().queryString(session.getQueryString());
            this.framework.addInitParameter(ApplicationConfig.ALLOW_QUERYSTRING_AS_REQUEST, "false");
            this.webSocketProcessor.open(this.webSocket, this.request, AtmosphereResponse.newInstance(this.framework.getAtmosphereConfig(), this.request, this.webSocket));
            this.framework.addInitParameter(ApplicationConfig.ALLOW_QUERYSTRING_AS_REQUEST, "true");
        }
        catch (Throwable e) {
            try {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, e.getMessage()));
            }
            catch (IOException e1) {
                logger.trace("", e);
            }
            logger.error("", e);
            return;
        }
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String s) {
                JSR356Endpoint.this.webSocketProcessor.invokeWebSocketProtocol(JSR356Endpoint.this.webSocket, s);
            }
        });
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

            public void onMessage(ByteBuffer bb) {
                byte[] b = new byte[bb.limit()];
                bb.get(b);
                JSR356Endpoint.this.webSocketProcessor.invokeWebSocketProtocol(JSR356Endpoint.this.webSocket, b, 0, b.length);
            }
        });
    }

    public void onClose(Session session, CloseReason closeCode) {
        logger.trace("{} closed {}", (Object)session, (Object)closeCode);
        this.request.destroy();
        this.webSocketProcessor.close(this.webSocket, closeCode.getCloseCode().getCode());
    }

    public void onError(Session session, Throwable t) {
        logger.error("", t);
        this.webSocketProcessor.notifyListener(this.webSocket, new WebSocketEventListener.WebSocketEvent<Throwable>(t, WebSocketEventListener.WebSocketEvent.TYPE.EXCEPTION, this.webSocket));
    }
}

