/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.config.managed;

import java.util.Map;
import org.atmosphere.config.managed.ManagedAtmosphereHandler;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.Singleton;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.handler.AnnotatedProxy;
import org.atmosphere.interceptor.InvokationOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedServiceInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ManagedServiceInterceptor.class);
    private AtmosphereConfig config;
    private boolean wildcardMapping = false;

    @Override
    public void configure(AtmosphereConfig config) {
        this.config = config;
        this.optimizeMapping();
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        if (!this.wildcardMapping) {
            return Action.CONTINUE;
        }
        this.mapAnnotatedService(r.getRequest(), (AtmosphereFramework.AtmosphereHandlerWrapper)r.getRequest().getAttribute(FrameworkConfig.ATMOSPHERE_HANDLER_WRAPPER));
        return Action.CONTINUE;
    }

    protected void optimizeMapping() {
        for (String w : this.config.handlers().keySet()) {
            if (!w.contains("{") || !w.contains("}")) continue;
            this.wildcardMapping = true;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mapAnnotatedService(AtmosphereRequest request, AtmosphereFramework.AtmosphereHandlerWrapper w) {
        Broadcaster b = w.broadcaster;
        String pathInfo = null;
        try {
            pathInfo = request.getPathInfo();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        String path = pathInfo != null ? request.getServletPath() + pathInfo : request.getServletPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        if (b.getID().contains("{")) {
            this.config.getBroadcasterFactory().remove(b.getID());
        }
        Map<String, AtmosphereFramework.AtmosphereHandlerWrapper> map = this.config.handlers();
        synchronized (map) {
            String targetPath;
            AnnotatedProxy ap;
            ManagedService a;
            if (this.config.handlers().get(path) == null && AnnotatedProxy.class.isAssignableFrom(w.atmosphereHandler.getClass()) && (a = (ap = (AnnotatedProxy)AnnotatedProxy.class.cast(w.atmosphereHandler)).target().getClass().getAnnotation(ManagedService.class)) != null && (targetPath = a.path()).indexOf("{") != -1 && targetPath.indexOf("}") != -1) {
                try {
                    boolean singleton;
                    boolean bl = singleton = ap.target().getClass().getAnnotation(Singleton.class) != null;
                    if (!singleton) {
                        ManagedAtmosphereHandler h = (ManagedAtmosphereHandler)w.atmosphereHandler.getClass().getConstructor(Object.class).newInstance(ap.target().getClass().newInstance());
                        this.config.framework().addAtmosphereHandler(path, (AtmosphereHandler)h, w.interceptors);
                    } else {
                        this.config.framework().addAtmosphereHandler(path, w.atmosphereHandler, w.interceptors);
                    }
                    request.setAttribute(FrameworkConfig.NEW_MAPPING, "true");
                }
                catch (Throwable e) {
                    logger.warn("Unable to create AtmosphereHandler", e);
                }
            }
        }
    }

    @Override
    public InvokationOrder.PRIORITY priority() {
        return InvokationOrder.AFTER_DEFAULT;
    }

    @Override
    public String toString() {
        return "@ManagedService Interceptor";
    }
}

