/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.config.managed;

import java.util.Map;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.config.service.Singleton;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.interceptor.InvokationOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereHandlerServiceInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereHandlerServiceInterceptor.class);
    private AtmosphereConfig config;
    private boolean wildcardMapping = false;

    @Override
    public void configure(AtmosphereConfig config) {
        this.config = config;
        this.optimizeMapping();
    }

    protected void optimizeMapping() {
        for (String w : this.config.handlers().keySet()) {
            if (!w.contains("{") || !w.contains("}")) continue;
            this.wildcardMapping = true;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Action inspect(AtmosphereResource r) {
        if (!this.wildcardMapping) {
            return Action.CONTINUE;
        }
        AtmosphereRequest request = r.getRequest();
        AtmosphereFramework.AtmosphereHandlerWrapper w = (AtmosphereFramework.AtmosphereHandlerWrapper)r.getRequest().getAttribute(FrameworkConfig.ATMOSPHERE_HANDLER_WRAPPER);
        Broadcaster b = w.broadcaster;
        String pathInfo = null;
        try {
            pathInfo = request.getPathInfo();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        String path = pathInfo != null ? request.getServletPath() + pathInfo : request.getServletPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        if (b.getID().contains("{")) {
            this.config.getBroadcasterFactory().remove(b.getID());
        }
        Map<String, AtmosphereFramework.AtmosphereHandlerWrapper> map = this.config.handlers();
        synchronized (map) {
            AtmosphereHandlerService m;
            if (this.config.handlers().get(path) == null && (m = w.atmosphereHandler.getClass().getAnnotation(AtmosphereHandlerService.class)) != null) {
                try {
                    boolean singleton;
                    boolean bl = singleton = w.atmosphereHandler.getClass().getAnnotation(Singleton.class) != null;
                    if (!singleton) {
                        this.config.framework().addAtmosphereHandler(path, (AtmosphereHandler)w.atmosphereHandler.getClass().newInstance(), w.interceptors);
                    } else {
                        this.config.framework().addAtmosphereHandler(path, w.atmosphereHandler, w.interceptors);
                    }
                    request.setAttribute(FrameworkConfig.NEW_MAPPING, "true");
                }
                catch (Throwable e) {
                    logger.warn("Unable to create AtmosphereHandler", e);
                }
            }
        }
        return Action.CONTINUE;
    }

    @Override
    public InvokationOrder.PRIORITY priority() {
        return InvokationOrder.BEFORE_DEFAULT;
    }
}

