/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;

public class DefaultHeadersInterceptor
extends AtmosphereInterceptorAdapter {
    private boolean injectCacheHeaders;
    private boolean enableAccessControl;
    private boolean writeHeaders;

    @Override
    public void configure(AtmosphereConfig config) {
        String nocache = config.getInitParameter(ApplicationConfig.NO_CACHE_HEADERS);
        this.injectCacheHeaders = nocache == null;
        String ac = config.getInitParameter(ApplicationConfig.DROP_ACCESS_CONTROL_ALLOW_ORIGIN_HEADER);
        this.enableAccessControl = ac != null ? !Boolean.parseBoolean(ac) : true;
        String wh = config.getInitParameter(FrameworkConfig.WRITE_HEADERS);
        this.writeHeaders = wh != null ? Boolean.parseBoolean(wh) : true;
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        AtmosphereResponse response = r.getResponse();
        AtmosphereRequest request = r.getRequest();
        request.setAttribute(ApplicationConfig.NO_CACHE_HEADERS, this.injectCacheHeaders);
        request.setAttribute(ApplicationConfig.DROP_ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, this.enableAccessControl);
        if (this.writeHeaders && this.injectCacheHeaders) {
            response.setHeader("Expires", "-1");
            response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
            response.setHeader("Pragma", "no-cache");
        }
        if (this.writeHeaders && this.enableAccessControl) {
            response.setHeader("Access-Control-Allow-Origin", request.getHeader("Origin") == null ? "*" : request.getHeader("Origin"));
            response.setHeader("Access-Control-Allow-Credentials", "true");
        }
        return Action.CONTINUE;
    }

    public String toString() {
        return "Default Response's Headers Interceptor";
    }
}

