/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.atmosphere.annotation.AnnotationUtil;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.managed.MeteorServiceInterceptor;
import org.atmosphere.config.service.MeteorService;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereAnnotation(value=MeteorService.class)
public class MeteorServiceProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(MeteorServiceProcessor.class);

    @Override
    public void handle(AtmosphereFramework framework, Class<? extends Annotation> annotation, Class<?> discoveredClass) {
        try {
            ReflectorServletProcessor r = new ReflectorServletProcessor();
            r.setServletClassName(discoveredClass.getName());
            Class<?> s = discoveredClass;
            MeteorService m = s.getAnnotation(MeteorService.class);
            String mapping = m.path();
            AnnotationUtil.atmosphereConfig(m.atmosphereConfig(), framework);
            framework.setDefaultBroadcasterClassName(m.broadcaster().getName());
            AnnotationUtil.filters(m.broadcastFilters(), framework);
            Class<? extends AtmosphereInterceptor>[] interceptors = m.interceptors();
            ArrayList<AtmosphereInterceptor> l = new ArrayList<AtmosphereInterceptor>();
            for (Class<? extends AtmosphereInterceptor> i : interceptors) {
                try {
                    AtmosphereInterceptor ai = i.newInstance();
                    l.add(ai);
                }
                catch (Throwable e) {
                    logger.warn("", e);
                }
            }
            if (m.path().contains("{")) {
                l.add(new MeteorServiceInterceptor());
            }
            framework.addAtmosphereHandler(mapping, (AtmosphereHandler)r, l);
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
    }
}

